/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.learningdesign.dto.LicenseDTO;

public class License
implements Serializable {
    private Long licenseID;
    private String name;
    private String code;
    private String url;
    private Boolean defaultLicense;
    private String pictureURL;

    public License() {
    }

    public License(Long licenseID, String name, String code, String url, Boolean defaultLicense, String pictureURL) {
        this.licenseID = licenseID;
        this.name = name;
        this.code = code;
        this.url = url;
        this.defaultLicense = defaultLicense;
        this.pictureURL = pictureURL;
    }

    public LicenseDTO getLicenseDTO(String serverURL) {
        return new LicenseDTO(this.licenseID, this.name, this.code, this.url, this.defaultLicense, this.pictureURL, serverURL);
    }

    public Boolean getDefaultLicense() {
        return this.defaultLicense;
    }

    public void setDefaultLicense(Boolean defaultLicense) {
        this.defaultLicense = defaultLicense;
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public void setLicenseID(Long licenseID) {
        this.licenseID = licenseID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPictureURL() {
        return this.pictureURL;
    }

    public void setPictureURL(String pictureURL) {
        this.pictureURL = pictureURL;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isSameLicenseType(License otherLicense) {
        if (this.licenseID != null && this.licenseID.equals(otherLicense.getLicenseID())) {
            String name1 = this.name != null ? StringUtils.strip((String)this.name) : "";
            String name2 = otherLicense.getName() != null ? StringUtils.strip((String)otherLicense.getName()) : "";
            return name1.equals(name2);
        }
        return false;
    }
}

