/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;

public class LessonClass
extends Grouping {
    private static Logger log = Logger.getLogger(LessonClass.class);
    private Group staffGroup;
    private Lesson lesson;

    public LessonClass() {
    }

    public LessonClass(Long groupingId, Set groups, Set activities, Group staffGroup, Lesson lesson) {
        super(groupingId, groups, activities, null);
        this.staffGroup = staffGroup;
        this.lesson = lesson;
    }

    public Group getStaffGroup() {
        return this.staffGroup;
    }

    public void setStaffGroup(Group staffGroup) {
        this.staffGroup = staffGroup;
    }

    public Lesson getLesson() {
        return this.lesson;
    }

    public void setLesson(Lesson lesson) {
        this.lesson = lesson;
    }

    @Override
    public boolean isLearnerGroup(Group group) {
        if (group == null || group.getGroupId() == null || this.staffGroup.getGroupId() == null) {
            return false;
        }
        return this.staffGroup.getGroupId() != group.getGroupId();
    }

    @Override
    public Grouping createCopy(int uiidOffset) {
        LessonClass lessonClass = new LessonClass();
        lessonClass.staffGroup = this.staffGroup;
        lessonClass.lesson = this.lesson;
        return lessonClass;
    }

    public boolean isStaffMember(User user) {
        if (user == null) {
            return false;
        }
        Group staff = this.getStaffGroup();
        return staff != null && staff.hasLearner(user);
    }

    public boolean addLearner(User user) {
        if (user == null) {
            return false;
        }
        Group learnersGroup = this.createLearnerGroupIfMissing();
        if (!learnersGroup.hasLearner(user)) {
            learnersGroup.getUsers().add(user);
            return true;
        }
        return false;
    }

    private Group createLearnerGroupIfMissing() {
        Group learnersGroup = this.getLearnersGroup();
        if (learnersGroup == null) {
            Organisation lessonOrganisation;
            Organisation organisation = lessonOrganisation = this.getLesson() != null ? this.getLesson().getOrganisation() : null;
            if (lessonOrganisation == null) {
                log.warn((Object)"Adding a learner to a lesson class with no related organisation. Learner group name will be 'learners'.");
            }
            String learnerGroupName = lessonOrganisation != null ? lessonOrganisation.getName() : "";
            learnerGroupName = learnerGroupName + "learners";
            this.getGroups().add(Group.createLearnerGroup(this, learnerGroupName, new HashSet()));
            learnersGroup = this.getLearnersGroup();
        }
        return learnersGroup;
    }

    public int addLearners(Collection<User> newLearners) {
        if (newLearners == null) {
            return 0;
        }
        Group learnersGroup = this.createLearnerGroupIfMissing();
        int originalNumber = learnersGroup.getUsers().size();
        learnersGroup.getUsers().addAll(newLearners);
        int newNumber = learnersGroup.getUsers().size();
        return newNumber - originalNumber;
    }

    public int setLearners(Collection<User> newLearners) {
        if (newLearners == null) {
            return 0;
        }
        Group learnersGroup = this.createLearnerGroupIfMissing();
        learnersGroup.getUsers().clear();
        learnersGroup.getUsers().addAll(newLearners);
        int newNumber = learnersGroup.getUsers().size();
        return newNumber;
    }

    public Group getLearnersGroup() {
        Group learnersGroup = null;
        Iterator<Group> iter = this.getGroups().iterator();
        while (learnersGroup == null && iter.hasNext()) {
            learnersGroup = iter.next();
            if (this.isLearnerGroup(learnersGroup)) continue;
            learnersGroup = null;
        }
        return learnersGroup;
    }

    public boolean addStaffMember(User user) {
        if (user == null) {
            return false;
        }
        Group staffGroup = this.getStaffGroup();
        if (staffGroup == null) {
            staffGroup = this.createStaffGroupIfMissing();
        }
        if (!staffGroup.hasLearner(user)) {
            staffGroup.getUsers().add(user);
            return true;
        }
        return false;
    }

    public int addStaffMembers(Collection<User> newStaff) {
        if (newStaff == null) {
            return 0;
        }
        Group staffGroup = this.createStaffGroupIfMissing();
        int originalNumber = staffGroup.getUsers().size();
        staffGroup.getUsers().addAll(newStaff);
        int newNumber = staffGroup.getUsers().size();
        return newNumber - originalNumber;
    }

    public int setStaffMembers(Collection<User> newStaff) {
        if (newStaff == null) {
            return 0;
        }
        Group staffGroup = this.createStaffGroupIfMissing();
        staffGroup.getUsers().clear();
        staffGroup.getUsers().addAll(newStaff);
        int newNumber = staffGroup.getUsers().size();
        return newNumber;
    }

    private Group createStaffGroupIfMissing() {
        Group staffGroup = this.getStaffGroup();
        if (staffGroup == null) {
            Organisation lessonOrganisation;
            Organisation organisation = lessonOrganisation = this.getLesson() != null ? this.getLesson().getOrganisation() : null;
            if (lessonOrganisation == null) {
                log.warn((Object)"Adding a staff member to a lesson class with no related organisation. Staff group name will be 'staff'.");
            }
            String staffGroupName = lessonOrganisation != null ? lessonOrganisation.getName() : "";
            staffGroupName = staffGroupName + "staff";
            this.setStaffGroup(Group.createStaffGroup(this, staffGroupName, new HashSet()));
            staffGroup = this.getStaffGroup();
        }
        return staffGroup;
    }
}

