/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.dao.hibernate;

import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.rating.dao.IRatingCriteriaDAO;
import org.lamsfoundation.lams.rating.model.AuthoredItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.LearnerItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.LessonRatingCriteria;
import org.lamsfoundation.lams.rating.model.RatingCriteria;
import org.lamsfoundation.lams.rating.model.ToolActivityRatingCriteria;
import org.lamsfoundation.lams.tool.exception.DataMissingException;

public class RatingCriteriaDAO
extends LAMSBaseDAO
implements IRatingCriteriaDAO {
    private static final String FIND_BY_TOOL_CONTENT_ID = "FROM " + RatingCriteria.class.getName() + " AS r WHERE r.toolContentId=? order by r.orderId asc";
    private static final String IS_COMMENTS_ENABLED_FOR_TOOL_CONTENT_ID = "SELECT COUNT(*) FROM " + RatingCriteria.class.getName() + " AS r WHERE r.toolContentId=? AND r.ratingStyle = 0";
    private static final String GET_COMMENTS_MIN_WORDS_LIMIT_FOR_TOOL_CONTENT_ID = "SELECT r.commentsMinWordsLimit FROM " + RatingCriteria.class.getName() + " AS r WHERE r.toolContentId=? AND r.ratingStyle = 0";

    @Override
    public void saveOrUpdate(RatingCriteria criteria) {
        this.getSession().saveOrUpdate((Object)criteria);
        this.getSession().flush();
    }

    @Override
    public void deleteRatingCriteria(Long ratingCriteriaId) {
        this.deleteById(RatingCriteria.class, ratingCriteriaId);
    }

    @Override
    public List<RatingCriteria> getByToolContentId(Long toolContentId) {
        return this.doFind(FIND_BY_TOOL_CONTENT_ID, toolContentId);
    }

    @Override
    public RatingCriteria getByRatingCriteriaId(Long ratingCriteriaId) {
        if (ratingCriteriaId == null) {
            return null;
        }
        RatingCriteria criteria = (RatingCriteria)super.find(RatingCriteria.class, ratingCriteriaId);
        if (criteria != null) {
            Integer criteriaType = criteria.getRatingCriteriaTypeId();
            if (criteriaType != null) {
                switch (criteriaType) {
                    case 1: {
                        return this.getByRatingCriteriaId(ratingCriteriaId, ToolActivityRatingCriteria.class);
                    }
                    case 2: {
                        return this.getByRatingCriteriaId(ratingCriteriaId, AuthoredItemRatingCriteria.class);
                    }
                    case 3: {
                        return this.getByRatingCriteriaId(ratingCriteriaId, LearnerItemRatingCriteria.class);
                    }
                    case 4: {
                        return this.getByRatingCriteriaId(ratingCriteriaId, LessonRatingCriteria.class);
                    }
                }
            }
            throw new DataMissingException("Unable to get RatingCriteria as the RatingCriteria type is unknown or missing. RatingCriteria type is " + criteriaType);
        }
        return null;
    }

    @Override
    public RatingCriteria getByRatingCriteriaId(Long ratingCriteriaId, Class clasz) {
        return (RatingCriteria)super.find(clasz, ratingCriteriaId);
    }

    @Override
    public boolean isCommentsEnabledForToolContent(Long toolContentId) {
        List list = super.find(IS_COMMENTS_ENABLED_FOR_TOOL_CONTENT_ID, new Object[]{toolContentId});
        return ((Number)list.get(0)).intValue() == 1;
    }

    @Override
    public int getCommentsMinWordsLimitForToolContent(Long toolContentId) {
        List list = super.find(GET_COMMENTS_MIN_WORDS_LIMIT_FOR_TOOL_CONTENT_ID, new Object[]{toolContentId});
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((Number)list.get(0)).intValue();
    }
}

