/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.dao.hibernate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.rating.dao.IRatingDAO;
import org.lamsfoundation.lams.rating.dto.ItemRatingCriteriaDTO;
import org.lamsfoundation.lams.rating.model.Rating;
import org.lamsfoundation.lams.rating.model.RatingComment;

public class RatingDAO
extends LAMSBaseDAO
implements IRatingDAO {
    private static final String FIND_RATING_BY_CRITERIA_AND_USER_AND_ITEM = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=? AND r.itemId=?";
    private static final String FIND_RATING_BY_CRITERIA_AND_USER = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=?";
    private static final String FIND_RATINGS_BY_ITEM = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=? AND r.toolSessionId=? AND r.itemId=?";
    private static final String FIND_RATINGS_BY_USER = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=? AND r.learner.userId=?";
    private static final String FIND_RATINGS_BY_USER_CRITERIA = "FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.learner.userId=?";
    private static final String FIND_RATING_AVERAGE_BY_ITEM = "SELECT AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=? AND r.toolSessionId=? AND r.itemId=?";
    private static final String FIND_RATING_AVERAGE_BY_CONTENT_AND_ITEM = "SELECT r.itemId, r.ratingCriteria.ratingCriteriaId, AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=? AND r.toolSessionId=? AND r.itemId=? GROUP BY r.ratingCriteria.ratingCriteriaId";
    private static final String FIND_RATING_AVERAGE_BY_CONTENT_AND_ITEMS = "SELECT r.itemId, r.ratingCriteria.ratingCriteriaId, AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=:contentId AND r.toolSessionId=:toolSessionId AND r.itemId IN (:itemIds) GROUP BY r.itemId, r.ratingCriteria.ratingCriteriaId";
    private static final String FIND_RATING_AVERAGE_BY_CONTENT_ID = "SELECT r.itemId, r.ratingCriteria.ratingCriteriaId, AVG(r.rating), COUNT(*) FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=? GROUP BY r.itemId, r.ratingCriteria.ratingCriteriaId";
    private static final String TOOL_SELECT_LEFT_JOIN_BY_USER_STANDARD = "SELECT r.item_id, ANY_VALUE(rc.comment) comment, ANY_VALUE(r2.rating) rating, AVG(r.rating) average_rating, COUNT(r.rating) count_vote  FROM lams_rating r   LEFT JOIN lams_rating r2  ON r2.rating_criteria_id = r.rating_criteria_id AND r.item_id = r2.item_id AND r2.user_id = :userId  LEFT JOIN lams_rating_comment rc ON rc.rating_criteria_id = r.rating_criteria_id AND rc.item_id = r2.item_id AND rc.user_id = :userId  WHERE r.rating_criteria_id = :ratingCriteriaId  GROUP BY r.item_id";
    private static final String TOOL_SELECT_LEFT_JOIN_BY_USER_COMMENT = "SELECT r.item_id, r.comment      FROM lams_rating_comment r WHERE r.rating_criteria_id = :ratingCriteriaId AND r.user_id = :userId";
    private static final String TOOL_SELECT_LEFT_JOIN_FOR_USER_STANDARD = "SELECT DISTINCT r.item_id, rc.comment, NULL rating, calc.average_rating, calc.count_vote       FROM lams_rating r      JOIN lams_rating_criteria c ON r.item_id = :userId AND c.tool_content_id = :toolContentId       AND c.rating_criteria_id = :ratingCriteriaId AND c.rating_criteria_id = r.rating_criteria_id       LEFT JOIN lams_rating_comment rc ON rc.rating_criteria_id = r.rating_criteria_id AND rc.item_id = r.item_id and rc.user_id = r.user_id       LEFT JOIN (                 SELECT r2.item_id, AVG(r2.rating) average_rating, COUNT(*) count_vote                  FROM lams_rating r2 WHERE r2.rating_criteria_id = :ratingCriteriaId AND r2.item_id = :userId                 GROUP BY r2.item_id                  ) calc ON calc.item_id = r.item_id ";
    private static final String TOOL_SELECT_LEFT_JOIN_FOR_USER_COMMENT = "SELECT r.item_id, r.comment     FROM lams_rating_comment r      WHERE r.item_id = :userId AND r.rating_criteria_id = :ratingCriteriaId";

    @Override
    public void saveOrUpdate(Object object) {
        this.getSession().saveOrUpdate(object);
        this.getSession().flush();
    }

    @Override
    public void delete(Object object) {
        this.getSession().delete(object);
        this.getSession().flush();
    }

    @Override
    public Rating getRating(Long ratingCriteriaId, Integer userId, Long itemId) {
        List<?> list = this.doFind(FIND_RATING_BY_CRITERIA_AND_USER_AND_ITEM, ratingCriteriaId, userId, itemId);
        if (list.size() > 0) {
            return (Rating)list.get(0);
        }
        return null;
    }

    @Override
    public List<Rating> getRatingsByItem(Long contentId, Long toolSessionId, Long itemId) {
        return super.find(FIND_RATINGS_BY_ITEM, new Object[]{contentId, toolSessionId, itemId});
    }

    private Rating getRating(Long ratingCriteriaId, Integer userId) {
        List<?> list = this.doFind(FIND_RATING_BY_CRITERIA_AND_USER, ratingCriteriaId, userId);
        if (list.size() > 0) {
            return (Rating)list.get(0);
        }
        return null;
    }

    @Override
    public List<Rating> getRatingsByUser(Long contentId, Integer userId) {
        return this.doFind(FIND_RATINGS_BY_USER, contentId, userId);
    }

    @Override
    public List<Rating> getRatingsByUserCriteria(Long criteriaId, Integer userId) {
        return this.doFind(FIND_RATINGS_BY_USER_CRITERIA, criteriaId, userId);
    }

    @Override
    public ItemRatingCriteriaDTO getRatingAverageDTOByItem(Long ratingCriteriaId, Long toolSessionId, Long itemId) {
        List<?> list = this.doFind(FIND_RATING_AVERAGE_BY_ITEM, ratingCriteriaId, toolSessionId, itemId);
        Object[] results = (Object[])list.get(0);
        Object averageRatingObj = results[0] == null ? Integer.valueOf(0) : results[0];
        String numberOfVotes = results[1] == null ? "0" : String.valueOf(results[1]);
        return new ItemRatingCriteriaDTO((Number)averageRatingObj, numberOfVotes);
    }

    @Override
    public List<Object[]> getRatingAverageByContentAndItem(Long contentId, Long toolSessionId, Long itemId) {
        return this.doFind(FIND_RATING_AVERAGE_BY_CONTENT_AND_ITEM, contentId, toolSessionId, itemId);
    }

    @Override
    public List<Object[]> getRatingAverageByContentAndItems(Long contentId, Long toolSessionId, Collection<Long> itemIds) {
        return this.getSession().createQuery(FIND_RATING_AVERAGE_BY_CONTENT_AND_ITEMS).setLong("contentId", contentId.longValue()).setLong("toolSessionId", toolSessionId.longValue()).setParameterList("itemIds", itemIds).list();
    }

    @Override
    public List<Object[]> getRatingAverageByContent(Long contentId) {
        return this.doFind(FIND_RATING_AVERAGE_BY_CONTENT_ID, contentId);
    }

    @Override
    public Rating get(Long uid) {
        if (uid != null) {
            Object o = super.find(Rating.class, uid);
            return (Rating)o;
        }
        return null;
    }

    @Override
    public int getCountItemsRatedByUser(Long toolContentId, Integer userId) {
        String FIND_ITEM_IDS_RATED_BY_USER = "SELECT DISTINCT r.itemId FROM  " + Rating.class.getName() + " AS r  WHERE r.ratingCriteria.toolContentId = :toolContentId AND r.learner.userId =:userId";
        String FIND_ITEM_IDS_COMMENTED_BY_USER = "SELECT DISTINCT comment.itemId FROM " + RatingComment.class.getName() + " AS comment  WHERE comment.ratingCriteria.toolContentId = :toolContentId AND comment.learner.userId =:userId AND comment.ratingCriteria.commentsEnabled IS TRUE";
        List ratedItemIds = this.getSession().createQuery(FIND_ITEM_IDS_RATED_BY_USER).setLong("toolContentId", toolContentId.longValue()).setInteger("userId", userId.intValue()).list();
        List commentedItemIds = this.getSession().createQuery(FIND_ITEM_IDS_COMMENTED_BY_USER).setLong("toolContentId", toolContentId.longValue()).setInteger("userId", userId.intValue()).list();
        HashSet unionItemIds = new HashSet(ratedItemIds);
        unionItemIds.addAll(commentedItemIds);
        return unionItemIds.size();
    }

    @Override
    public int getCountItemsRatedByUserByCriteria(Long criteriaId, Integer userId) {
        String FIND_ITEM_IDS_RATED_BY_USER = "SELECT DISTINCT r.itemId FROM  " + Rating.class.getName() + " AS r  WHERE r.ratingCriteria.ratingCriteriaId = :criteriaId AND r.learner.userId =:userId";
        String FIND_ITEM_IDS_COMMENTED_BY_USER = "SELECT DISTINCT comment.itemId FROM " + RatingComment.class.getName() + " AS comment  WHERE comment.ratingCriteria.ratingCriteriaId = :criteriaId AND comment.learner.userId =:userId AND comment.ratingCriteria.commentsEnabled IS TRUE";
        List ratedItemIds = this.getSession().createQuery(FIND_ITEM_IDS_RATED_BY_USER).setLong("criteriaId", criteriaId.longValue()).setInteger("userId", userId.intValue()).list();
        List commentedItemIds = this.getSession().createQuery(FIND_ITEM_IDS_COMMENTED_BY_USER).setLong("criteriaId", criteriaId.longValue()).setInteger("userId", userId.intValue()).list();
        HashSet unionItemIds = new HashSet(ratedItemIds);
        unionItemIds.addAll(commentedItemIds);
        return unionItemIds.size();
    }

    @Override
    public Map<Long, Long> countUsersRatedEachItem(Long contentId, Long toolSessionId, Collection<Long> itemIds, Integer excludeUserId) {
        HashMap<Long, Long> itemIdToRatedUsersCountMap = new HashMap<Long, Long>();
        if (itemIds.isEmpty()) {
            return itemIdToRatedUsersCountMap;
        }
        String FIND_ITEMID_USERID_PAIRS_BY_CONTENT_AND_ITEMS = "SELECT r.itemId, r.learner.userId FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.toolContentId=:contentId AND r.itemId IN (:itemIds) AND r.toolSessionId=:toolSessionId";
        String FIND_ITEMID_USERID_COMMENT_PAIRS_BY_CONTENT_AND_ITEMS = "SELECT comment.itemId, comment.learner.userId FROM " + RatingComment.class.getName() + " AS r where comment.ratingCriteria.toolContentId=:contentId AND comment.itemId IN (:itemIds) AND comment.ratingCriteria.commentsEnabled IS TRUE AND comment.toolSessionId=:toolSessionId";
        List ratedItemObjs = this.getSession().createQuery(FIND_ITEMID_USERID_PAIRS_BY_CONTENT_AND_ITEMS).setLong("contentId", contentId.longValue()).setLong("toolSessionId", toolSessionId.longValue()).setParameterList("itemIds", itemIds).list();
        List commentedItemObjs = this.getSession().createQuery(FIND_ITEMID_USERID_COMMENT_PAIRS_BY_CONTENT_AND_ITEMS).setLong("contentId", contentId.longValue()).setParameterList("itemIds", itemIds).setLong("toolSessionId", toolSessionId.longValue()).list();
        return this.createUsersRatedEachItem(itemIds, excludeUserId, itemIdToRatedUsersCountMap, ratedItemObjs, commentedItemObjs);
    }

    @Override
    public Map<Long, Long> countUsersRatedEachItemByCriteria(Long criteriaId, Long toolSessionId, Collection<Long> itemIds, Integer excludeUserId) {
        HashMap<Long, Long> itemIdToRatedUsersCountMap = new HashMap<Long, Long>();
        if (itemIds.isEmpty()) {
            return itemIdToRatedUsersCountMap;
        }
        String FIND_ITEMID_USERID_PAIRS_BY_CONTENT_AND_ITEMS = "SELECT r.itemId, r.learner.userId FROM " + Rating.class.getName() + " AS r where r.ratingCriteria.ratingCriteriaId=:criteriaId AND r.itemId IN (:itemIds) AND r.toolSessionId=:toolSessionId";
        String FIND_ITEMID_USERID_COMMENT_PAIRS_BY_CONTENT_AND_ITEMS = "SELECT comment.itemId, comment.learner.userId FROM " + RatingComment.class.getName() + " AS r where comment.ratingCriteria.ratingStyle=0 AND comment.ratingCriteria.ratingCriteriaId=:criteriaId  AND comment.itemId IN (:itemIds) AND comment.ratingCriteria.commentsEnabled IS TRUE AND comment.toolSessionId=:toolSessionId";
        List ratedItemObjs = this.getSession().createQuery(FIND_ITEMID_USERID_PAIRS_BY_CONTENT_AND_ITEMS).setLong("criteriaId", criteriaId.longValue()).setLong("toolSessionId", toolSessionId.longValue()).setParameterList("itemIds", itemIds).list();
        List commentedItemObjs = this.getSession().createQuery(FIND_ITEMID_USERID_COMMENT_PAIRS_BY_CONTENT_AND_ITEMS).setLong("criteriaId", criteriaId.longValue()).setParameterList("itemIds", itemIds).setLong("toolSessionId", toolSessionId.longValue()).list();
        return this.createUsersRatedEachItem(itemIds, excludeUserId, itemIdToRatedUsersCountMap, ratedItemObjs, commentedItemObjs);
    }

    private Map<Long, Long> createUsersRatedEachItem(Collection<Long> itemIds, Integer excludeUserId, HashMap<Long, Long> itemIdToRatedUsersCountMap, List<Object[]> ratedItemObjs, List<Object[]> commentedItemObjs) {
        for (Long itemId : itemIds) {
            Integer userIdIter;
            Long itemIdIter;
            HashSet<Integer> userIds = new HashSet<Integer>();
            for (Object[] ratedItemObj : ratedItemObjs) {
                itemIdIter = (Long)ratedItemObj[0];
                userIdIter = (Integer)ratedItemObj[1];
                if (!itemIdIter.equals(itemId)) continue;
                userIds.add(userIdIter);
            }
            for (Object[] commentedItemObj : commentedItemObjs) {
                itemIdIter = (Long)commentedItemObj[0];
                userIdIter = (Integer)commentedItemObj[1];
                if (!itemIdIter.equals(itemId)) continue;
                userIds.add(userIdIter);
            }
            userIds.remove(excludeUserId);
            itemIdToRatedUsersCountMap.put(itemId, new Long(userIds.size()));
        }
        return itemIdToRatedUsersCountMap;
    }

    @Override
    public String getRatingSelectJoinSQL(Integer ratingStyle, boolean getByUser) {
        if (ratingStyle == 0) {
            return getByUser ? TOOL_SELECT_LEFT_JOIN_BY_USER_COMMENT : TOOL_SELECT_LEFT_JOIN_FOR_USER_COMMENT;
        }
        return getByUser ? TOOL_SELECT_LEFT_JOIN_BY_USER_STANDARD : TOOL_SELECT_LEFT_JOIN_FOR_USER_STANDARD;
    }
}

