/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.statistics.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.lesson.CompletedActivityProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.statistics.dto.GroupStatisticsDTO;
import org.lamsfoundation.lams.statistics.dto.StatisticsDTO;
import org.lamsfoundation.lams.statistics.service.IStatisticsService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

public class StatisticsService
implements IStatisticsService {
    private IBaseDAO baseDAO;
    private IUserManagementService userService;

    @Override
    public StatisticsDTO getOverallStatistics() {
        StatisticsDTO statisticsDTO = new StatisticsDTO();
        HashMap<String, Object> groupMap = new HashMap<String, Object>();
        groupMap.put("organisationType.organisationTypeId", OrganisationType.COURSE_TYPE);
        statisticsDTO.setGroups(this.baseDAO.countByProperties(Organisation.class, groupMap));
        HashMap<String, Object> subGroupMap = new HashMap<String, Object>();
        subGroupMap.put("organisationType.organisationTypeId", OrganisationType.CLASS_TYPE);
        statisticsDTO.setSubGroups(this.baseDAO.countByProperties(Organisation.class, subGroupMap));
        statisticsDTO.setActivities(this.baseDAO.countAll(Activity.class));
        statisticsDTO.setCompletedActivities(this.baseDAO.countAll(CompletedActivityProgress.class));
        statisticsDTO.setLessons(this.baseDAO.countAll(Lesson.class));
        statisticsDTO.setSequences(this.baseDAO.countAll(LearningDesign.class));
        statisticsDTO.setUsers(this.baseDAO.countAll(User.class));
        return statisticsDTO;
    }

    @Override
    public GroupStatisticsDTO getGroupStatisticsDTO(Integer orgId) throws Exception {
        ArrayList<GroupStatisticsDTO> subGroupStatsList;
        Organisation group = (Organisation)this.baseDAO.find(Organisation.class, orgId);
        GroupStatisticsDTO groupStats = new GroupStatisticsDTO();
        if (group != null) {
            groupStats.setName(group.getName());
            groupStats.setLessons(group.getLessons().size());
            groupStats.setTotalUsers(this.userService.getAllUsers(group.getOrganisationId()).size());
            groupStats.setAuthors(this.userService.getUsersFromOrganisationByRole(group.getOrganisationId(), "AUTHOR", false).size());
            groupStats.setMonitors(this.userService.getUsersFromOrganisationByRole(group.getOrganisationId(), "MONITOR", false).size());
            groupStats.setLearners(this.userService.getUsersFromOrganisationByRole(group.getOrganisationId(), "LEARNER", false).size());
            Set subGroups = group.getChildOrganisations();
            subGroupStatsList = new ArrayList<GroupStatisticsDTO>();
            if (subGroups != null) {
                for (Organisation subGroup : subGroups) {
                    GroupStatisticsDTO subGroupStats = new GroupStatisticsDTO();
                    subGroupStats.setName(subGroup.getName());
                    subGroupStats.setLessons(subGroup.getLessons().size());
                    subGroupStats.setTotalUsers(this.userService.getAllUsers(subGroup.getOrganisationId()).size());
                    subGroupStats.setAuthors(this.userService.getUsersFromOrganisationByRole(subGroup.getOrganisationId(), "AUTHOR", false).size());
                    subGroupStats.setMonitors(this.userService.getUsersFromOrganisationByRole(subGroup.getOrganisationId(), "MONITOR", false).size());
                    subGroupStats.setLearners(this.userService.getUsersFromOrganisationByRole(subGroup.getOrganisationId(), "LEARNER", false).size());
                    subGroupStatsList.add(subGroupStats);
                }
            }
        } else {
            throw new Exception("Tried to fetch data for null group with id: " + orgId);
        }
        groupStats.setSubGroups(subGroupStatsList);
        return groupStats;
    }

    @Override
    public Map<String, Integer> getGroupMap() {
        HashMap<String, Integer> groupMap = new HashMap<String, Integer>();
        List groups = this.userService.findByProperty(Organisation.class, "organisationType.organisationTypeId", OrganisationType.COURSE_TYPE);
        if (groups != null) {
            for (Organisation group : groups) {
                groupMap.put(group.getName(), group.getOrganisationId());
            }
        }
        return groupMap;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setUserService(IUserManagementService userService) {
        this.userService = userService;
    }
}

