/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.timezone.service;

import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.timezone.Timezone;
import org.lamsfoundation.lams.timezone.dao.ITimezoneDAO;
import org.lamsfoundation.lams.timezone.service.ITimezoneService;

public class TimezoneService
implements ITimezoneService {
    protected Logger log = Logger.getLogger(TimezoneService.class);
    protected ITimezoneDAO timezoneDAO;

    @Override
    public List<Timezone> getDefaultTimezones() {
        return this.timezoneDAO.getDefaultTimezones();
    }

    @Override
    public void updateTimezones(Collection<Timezone> newTimezones) {
        this.log.debug((Object)"Updating list of available timezones.");
        List<Timezone> oldTimezones = this.getDefaultTimezones();
        Collection timezonesToDelete = CollectionUtils.subtract(oldTimezones, newTimezones);
        Collection timezonesToAdd = CollectionUtils.subtract(newTimezones, oldTimezones);
        for (Timezone timezone : timezonesToDelete) {
            this.timezoneDAO.removeTimezone(timezone);
        }
        for (Timezone timezone : timezonesToAdd) {
            this.timezoneDAO.addTimezone(timezone);
        }
    }

    @Override
    public Timezone getServerTimezone() {
        Timezone serverTimezone = this.timezoneDAO.getServerTimezone();
        if (serverTimezone == null) {
            serverTimezone = new Timezone();
            serverTimezone.setTimezoneId(TimeZone.getDefault().getID());
            serverTimezone.setServerTimezone(true);
            this.timezoneDAO.addTimezone(serverTimezone);
        }
        return serverTimezone;
    }

    @Override
    public void setServerTimezone(String timeZoneId) {
        Timezone serverTimezone = this.timezoneDAO.getServerTimezone();
        serverTimezone.setTimezoneId(timeZoneId);
        this.timezoneDAO.setServerTimezone(serverTimezone);
    }

    public ITimezoneDAO getTimezoneDAO() {
        return this.timezoneDAO;
    }

    public void setTimezoneDAO(ITimezoneDAO timezoneDAO) {
        this.timezoneDAO = timezoneDAO;
    }
}

