/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Query;
import org.lamsfoundation.lams.dao.hibernate.LAMSBaseDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.dao.IOrganisationDAO;
import org.lamsfoundation.lams.usermanagement.dto.OrganisationDTO;
import org.springframework.stereotype.Repository;

@Repository
public class OrganisationDAO
extends LAMSBaseDAO
implements IOrganisationDAO {
    private static final String GET_PAGED_COURSES = "SELECT o FROM Organisation o WHERE o.organisationType.organisationTypeId =:typeId AND o.organisationState.organisationStateId =:stateId AND o.parentOrganisation.organisationId =:parentOrgId AND (o.name LIKE CONCAT('%', :searchString, '%')) ORDER BY ";
    private static final String GET_COUNT_COURSES_BY_PARENT_TYPE_STATE = "SELECT count(*) FROM Organisation o  WHERE o.parentOrganisation.organisationId =:parentOrgId  AND o.organisationType.organisationTypeId =:typeId  AND o.organisationState.organisationStateId =:stateId  AND (o.name LIKE CONCAT('%', :searchString, '%')) ";

    @Override
    public List<OrganisationDTO> getActiveCoursesByUser(Integer userId, boolean isSysadmin, int page, int size, String searchString) {
        String GET_ALL_ACTIVE_COURSE_IDS = "SELECT o.organisationId, o.name FROM Organisation o WHERE o.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " AND o.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " AND (o.name LIKE CONCAT('%', :searchString, '%')) ORDER BY o.name";
        String GET_ACTIVE_COURSE_IDS_BY_USER = "SELECT uo.organisation.organisationId, uo.organisation.name FROM UserOrganisation uo  WHERE uo.organisation.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " AND uo.organisation.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " AND uo.user.userId = :userId  AND (uo.organisation.name LIKE CONCAT('%', :searchString, '%')) ORDER BY uo.organisation.name";
        String queryStr = isSysadmin ? GET_ALL_ACTIVE_COURSE_IDS : GET_ACTIVE_COURSE_IDS_BY_USER;
        Query query = this.getSession().createQuery(queryStr);
        searchString = searchString == null ? "" : searchString;
        query.setString("searchString", searchString);
        if (!isSysadmin) {
            query.setInteger("userId", userId.intValue());
        }
        query.setFirstResult(page * size);
        query.setMaxResults(size);
        List list = query.list();
        ArrayList<OrganisationDTO> orgDtos = new ArrayList<OrganisationDTO>();
        if (list != null && list.size() > 0) {
            for (Object[] element : list) {
                Integer orgId = ((Number)element[0]).intValue();
                String name = (String)element[1];
                OrganisationDTO orgDto = new OrganisationDTO(orgId, name);
                orgDtos.add(orgDto);
            }
        }
        return orgDtos;
    }

    @Override
    public int getCountActiveCoursesByUser(Integer userId, boolean isSysadmin, String searchString) {
        String GET_ALL_ACTIVE_COURSE_IDS = "SELECT COUNT(o) FROM Organisation o WHERE o.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " AND o.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " AND (o.name LIKE CONCAT('%', :searchString, '%'))";
        String GET_ACTIVE_COURSE_IDS_BY_USER = "SELECT COUNT(uo) FROM UserOrganisation uo  WHERE uo.organisation.organisationType.organisationTypeId = " + OrganisationType.COURSE_TYPE + " AND uo.organisation.organisationState.organisationStateId = " + OrganisationState.ACTIVE + " AND uo.user.userId = :userId  AND (uo.organisation.name LIKE CONCAT('%', :searchString, '%'))";
        String queryStr = isSysadmin ? GET_ALL_ACTIVE_COURSE_IDS : GET_ACTIVE_COURSE_IDS_BY_USER;
        Query query = this.getSession().createQuery(queryStr);
        searchString = searchString == null ? "" : searchString;
        query.setString("searchString", searchString);
        if (!isSysadmin) {
            query.setInteger("userId", userId.intValue());
        }
        return ((Number)query.uniqueResult()).intValue();
    }

    @Override
    public List<Organisation> getPagedCourses(Integer parentOrgId, Integer typeId, Integer stateId, int page, int size, String sortBy, String sortOrder, String searchString) {
        String sortByParam = "o.name";
        switch (sortBy) {
            case "id": {
                sortByParam = "o.organisationId";
                break;
            }
            case "name": {
                sortByParam = "o.name";
                break;
            }
            case "code": {
                sortByParam = "o.code";
                break;
            }
            case "description": {
                sortByParam = "o.description";
            }
        }
        Query query = this.getSession().createQuery(GET_PAGED_COURSES + sortByParam + " " + sortOrder);
        query.setInteger("typeId", typeId.intValue());
        query.setInteger("stateId", stateId.intValue());
        query.setInteger("parentOrgId", parentOrgId.intValue());
        searchString = searchString == null ? "" : searchString;
        query.setString("searchString", searchString);
        query.setFirstResult(page * size);
        query.setMaxResults(size);
        return query.list();
    }

    @Override
    public int getCountCoursesByParentCourseAndTypeAndState(Integer parentOrgId, Integer typeId, Integer stateId, String searchString) {
        Query query = this.getSession().createQuery(GET_COUNT_COURSES_BY_PARENT_TYPE_STATE);
        query.setInteger("parentOrgId", parentOrgId.intValue());
        query.setInteger("typeId", typeId.intValue());
        query.setInteger("stateId", stateId.intValue());
        searchString = searchString == null ? "" : searchString;
        query.setString("searchString", searchString);
        return ((Number)query.uniqueResult()).intValue();
    }
}

