/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.lamsfoundation.lams.util.ExcelCell;
import org.lamsfoundation.lams.util.FileUtil;

public class ExcelUtil {
    private static CellStyle defaultStyle;
    private static CellStyle boldStyle;
    private static CellStyle greenColor;
    private static CellStyle blueColor;
    private static CellStyle redColor;
    private static CellStyle yellowColor;
    private static CellStyle borderStyleLeftThin;
    private static CellStyle borderStyleLeftThick;
    private static CellStyle borderStyleRightThick;
    private static CellStyle borderStyleLeftThinBoldFont;
    private static CellStyle borderStyleLeftThickBoldFont;
    private static CellStyle borderStyleRightThickBoldFont;
    private static CellStyle borderStyleBottomThin;
    private static CellStyle borderStyleBottomThinBoldFont;
    public static final String DEFAULT_FONT_NAME = "Calibri-Regular";

    public static void createExcel(OutputStream out, LinkedHashMap<String, ExcelCell[][]> dataToExport, String dateHeader, boolean displaySheetTitle) throws IOException {
        SXSSFWorkbook workbook = new SXSSFWorkbook(100);
        Font defaultFont = workbook.createFont();
        defaultFont.setFontName(DEFAULT_FONT_NAME);
        defaultStyle = workbook.createCellStyle();
        defaultStyle.setFont(defaultFont);
        boldStyle = workbook.createCellStyle();
        Font boldFont = workbook.createFont();
        boldFont.setBoldweight((short)700);
        boldFont.setFontName(DEFAULT_FONT_NAME);
        boldStyle.setFont(boldFont);
        blueColor = workbook.createCellStyle();
        blueColor.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        blueColor.setFillPattern((short)1);
        blueColor.setFont(defaultFont);
        redColor = workbook.createCellStyle();
        redColor.setFillForegroundColor(IndexedColors.RED.getIndex());
        redColor.setFillPattern((short)1);
        redColor.setFont(defaultFont);
        greenColor = workbook.createCellStyle();
        greenColor.setFillForegroundColor(IndexedColors.LIME.getIndex());
        greenColor.setFillPattern((short)1);
        Font whiteFont = workbook.createFont();
        whiteFont.setColor(IndexedColors.WHITE.getIndex());
        whiteFont.setFontName(DEFAULT_FONT_NAME);
        greenColor.setFont(whiteFont);
        yellowColor = workbook.createCellStyle();
        yellowColor.setFillForegroundColor(IndexedColors.GOLD.getIndex());
        yellowColor.setFillPattern((short)1);
        yellowColor.setFont(defaultFont);
        borderStyleLeftThin = workbook.createCellStyle();
        borderStyleLeftThin.setBorderLeft((short)1);
        borderStyleLeftThin.setFont(defaultFont);
        borderStyleLeftThick = workbook.createCellStyle();
        borderStyleLeftThick.setBorderLeft((short)5);
        borderStyleLeftThick.setFont(defaultFont);
        borderStyleRightThick = workbook.createCellStyle();
        borderStyleRightThick.setBorderRight((short)5);
        borderStyleRightThick.setFont(defaultFont);
        borderStyleLeftThinBoldFont = workbook.createCellStyle();
        borderStyleLeftThinBoldFont.setBorderLeft((short)1);
        borderStyleLeftThinBoldFont.setFont(boldFont);
        borderStyleLeftThickBoldFont = workbook.createCellStyle();
        borderStyleLeftThickBoldFont.setBorderLeft((short)5);
        borderStyleLeftThickBoldFont.setFont(boldFont);
        borderStyleRightThickBoldFont = workbook.createCellStyle();
        borderStyleRightThickBoldFont.setBorderRight((short)5);
        borderStyleRightThickBoldFont.setFont(boldFont);
        borderStyleBottomThin = workbook.createCellStyle();
        borderStyleBottomThin.setBorderBottom((short)1);
        borderStyleBottomThin.setFont(defaultFont);
        borderStyleBottomThinBoldFont = workbook.createCellStyle();
        borderStyleBottomThinBoldFont.setBorderBottom((short)1);
        borderStyleBottomThinBoldFont.setFont(boldFont);
        int i = 0;
        for (String sheetName : dataToExport.keySet()) {
            if (dataToExport.get(sheetName) == null) continue;
            String sheetTitle = displaySheetTitle ? sheetName : null;
            ExcelUtil.createSheet((Workbook)workbook, sheetName, sheetTitle, i, dateHeader, dataToExport.get(sheetName));
            ++i;
        }
        workbook.write(out);
        out.close();
    }

    public static void createSheet(Workbook workbook, String sheetName, String sheetTitle, int sheetIndex, String dateHeader, ExcelCell[][] data) throws IOException {
        Row row;
        sheetName = WorkbookUtil.createSafeSheetName((String)sheetName);
        while (workbook.getSheet(sheetName) != null) {
            sheetName = sheetName + " ";
        }
        Sheet sheet = workbook.createSheet(sheetName);
        if (!StringUtils.isBlank((String)sheetTitle)) {
            row = sheet.createRow(0);
            ExcelUtil.createCell(new ExcelCell((Object)sheetTitle, true), 0, row, workbook);
        }
        if (!StringUtils.isBlank((String)dateHeader)) {
            row = sheet.createRow(1);
            ExcelUtil.createCell(new ExcelCell((Object)dateHeader, false), 0, row, workbook);
            ExcelUtil.createCell(new ExcelCell((Object)FileUtil.EXPORT_TO_SPREADSHEET_TITLE_DATE_FORMAT.format(new Date()), false), 1, row, workbook);
        }
        if (data != null) {
            int maxColumnSize = 0;
            for (int rowIndex = 0; rowIndex < data.length; ++rowIndex) {
                int rowIndexOffset = StringUtils.isBlank((String)sheetTitle) && StringUtils.isBlank((String)dateHeader) ? 0 : 4;
                Row row2 = sheet.createRow(rowIndex + rowIndexOffset);
                int columnSize = data[rowIndex].length;
                for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
                    ExcelCell excelCell = data[rowIndex][columnIndex];
                    ExcelUtil.createCell(excelCell, columnIndex, row2, workbook);
                }
                if (columnSize <= maxColumnSize) continue;
                maxColumnSize = columnSize;
            }
            for (int i = 0; i < maxColumnSize; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    public static void createCell(ExcelCell excelCell, int cellnum, Row row, Workbook workbook) {
        if (excelCell != null) {
            Cell cell = row.createCell(cellnum);
            if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Date) {
                cell.setCellValue(FileUtil.EXPORT_TO_SPREADSHEET_CELL_DATE_FORMAT.format(excelCell.getCellValue()));
            } else if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Double) {
                cell.setCellValue(((Double)excelCell.getCellValue()).doubleValue());
            } else if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Long) {
                cell.setCellValue(((Long)excelCell.getCellValue()).doubleValue());
            } else if (excelCell.getCellValue() != null && excelCell.getCellValue() instanceof Integer) {
                cell.setCellValue(((Integer)excelCell.getCellValue()).doubleValue());
            } else if (excelCell.getCellValue() != null) {
                cell.setCellValue(excelCell.getCellValue().toString());
            }
            cell.setCellStyle(defaultStyle);
            if (excelCell.isBold().booleanValue()) {
                cell.setCellStyle(boldStyle);
            }
            if (excelCell.getColor() != null) {
                switch (excelCell.getColor()) {
                    case BLUE: {
                        cell.setCellStyle(blueColor);
                        break;
                    }
                    case GREEN: {
                        cell.setCellStyle(greenColor);
                        break;
                    }
                    case RED: {
                        cell.setCellStyle(redColor);
                        break;
                    }
                    case YELLOW: {
                        cell.setCellStyle(yellowColor);
                        break;
                    }
                }
            }
            if (excelCell.getBorderStyle() != 0) {
                switch (excelCell.getBorderStyle()) {
                    case 1: {
                        if (excelCell.isBold().booleanValue()) {
                            cell.setCellStyle(borderStyleLeftThinBoldFont);
                            break;
                        }
                        cell.setCellStyle(borderStyleLeftThin);
                        break;
                    }
                    case 4: {
                        if (excelCell.isBold().booleanValue()) {
                            cell.setCellStyle(borderStyleLeftThickBoldFont);
                            break;
                        }
                        cell.setCellStyle(borderStyleLeftThick);
                        break;
                    }
                    case 2: {
                        if (excelCell.isBold().booleanValue()) {
                            cell.setCellStyle(borderStyleRightThickBoldFont);
                            break;
                        }
                        cell.setCellStyle(borderStyleRightThick);
                        break;
                    }
                    case 3: {
                        if (excelCell.isBold().booleanValue()) {
                            cell.setCellStyle(borderStyleBottomThinBoldFont);
                            break;
                        }
                        cell.setCellStyle(borderStyleBottomThin);
                        break;
                    }
                }
            }
            if (excelCell.getAlignment() != 0) {
                switch (excelCell.getAlignment()) {
                    case 1: {
                        CellUtil.setCellStyleProperty((Cell)cell, (Workbook)workbook, (String)"alignment", (Object)0);
                        break;
                    }
                    case 2: {
                        CellUtil.setCellStyleProperty((Cell)cell, (Workbook)workbook, (String)"alignment", (Object)1);
                        break;
                    }
                    case 3: {
                        CellUtil.setCellStyleProperty((Cell)cell, (Workbook)workbook, (String)"alignment", (Object)2);
                        break;
                    }
                    case 4: {
                        CellUtil.setCellStyleProperty((Cell)cell, (Workbook)workbook, (String)"alignment", (Object)3);
                        break;
                    }
                }
            }
        }
    }
}

