/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.imgscalr;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.CircularByteBuffer;
import org.lamsfoundation.lams.util.imgscalr.Scalr;

public class ResizePictureUtil {
    private static Logger log = Logger.getLogger(ResizePictureUtil.class);

    public static InputStream resize(InputStream is, int largestDimension) throws IOException {
        try {
            BufferedImage image = ImageIO.read(is);
            return ResizePictureUtil.resize(image, largestDimension);
        }
        catch (IOException e) {
            log.error((Object)e.getStackTrace());
            return null;
        }
    }

    public static InputStream resize(BufferedImage image, int largestDimension) throws IOException {
        try {
            BufferedImage outImage = Scalr.resize(image, Scalr.Method.QUALITY, largestDimension, new BufferedImageOp[0]);
            CircularByteBuffer cbb = new CircularByteBuffer(-1);
            ImageIO.write((RenderedImage)outImage, "PNG", cbb.getOutputStream());
            cbb.getOutputStream().close();
            return cbb.getInputStream();
        }
        catch (IOException e) {
            log.error((Object)e.getStackTrace());
            return null;
        }
    }
}

