/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;

public class MessageService {
    private MessageSourceAccessor messageAccessor;

    public void setMessageSource(MessageSource messageSource) {
        this.messageAccessor = new MessageSourceAccessor(messageSource);
    }

    public String getMessage(String key) {
        String message;
        try {
            message = this.messageAccessor.getMessage(key, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            message = "??" + key + "??";
        }
        return message;
    }

    public String getMessage(String key, String defaultMessage) {
        String message = defaultMessage;
        try {
            message = this.messageAccessor.getMessage(key, defaultMessage, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            message = defaultMessage;
        }
        return message;
    }

    public String getMessage(String key, Object[] args) {
        String message;
        try {
            message = this.messageAccessor.getMessage(key, args, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            message = "??" + key + "??";
        }
        return message;
    }

    public String getMessage(String key, Object[] args, String defaultMessage) {
        String message = defaultMessage;
        try {
            message = this.messageAccessor.getMessage(key, args, defaultMessage, LocaleContextHolder.getLocale());
        }
        catch (NoSuchMessageException e) {
            message = defaultMessage;
        }
        return message;
    }
}

