/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.audit;

import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.session.SessionManager;

public class AuditService
implements IAuditService {
    static Logger logger = Logger.getLogger((String)AuditService.class.getName());
    private final String AUDIT_CHANGE_I18N_KEY = "audit.change.entry";
    private final String AUDIT_HIDE_I18N_KEY = "audit.hide.entry";
    private final String AUDIT_SHOW_I18N_KEY = "audit.show.entry";
    protected MessageService messageService;

    private String getUserString() {
        UserDTO user;
        HttpSession ss = SessionManager.getSession();
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null) {
            return user.getLogin() + "(" + user.getUserID() + "): ";
        }
        return "User unknown (session does not contain user details): ";
    }

    public void log(String moduleName, String message) {
        logger.info((Object)(this.getUserString() + moduleName + ": " + message));
    }

    public void logChange(String moduleName, Long originalUserId, String originalUserLogin, String originalText, String newText) {
        Object[] args = new String[]{originalUserLogin + "(" + originalUserId + ")", originalText, newText};
        String message = this.messageService.getMessage("audit.change.entry", args);
        this.log(moduleName, message);
    }

    public void logHideEntry(String moduleName, Long originalUserId, String originalUserLogin, String hiddenItem) {
        Object[] args = new String[3];
        args[0] = originalUserLogin + "(" + originalUserId + ")";
        args[1] = hiddenItem;
        String message = this.messageService.getMessage("audit.hide.entry", args);
        this.log(moduleName, message);
    }

    public void logShowEntry(String moduleName, Long originalUserId, String originalUserLogin, String hiddenItem) {
        Object[] args = new String[3];
        args[0] = originalUserLogin + "(" + originalUserId + ")";
        args[1] = hiddenItem;
        String message = this.messageService.getMessage("audit.show.entry", args);
        this.log(moduleName, message);
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

