/*
 * Decompiled with CFR 0.152.
 */
package com.webct.platform.sdkext.authmoduledata;

import com.webct.platform.framework.jndi.jndiUtils;
import com.webct.platform.sdkext.authmoduledata.LearningContextVO;
import com.webct.platform.sdkext.authmoduledata.VistaDataException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class LearningContextService {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$webct$platform$sdkext$authmoduledata$LearningContextService == null ? (class$com$webct$platform$sdkext$authmoduledata$LearningContextService = LearningContextService.class$("com.webct.platform.sdkext.authmoduledata.LearningContextService")) : class$com$webct$platform$sdkext$authmoduledata$LearningContextService));
    private static LearningContextService instance = null;
    private static DataSource datasource = null;
    private static final String GET_LC_DATA_SQL = "select lc.id,       lc.glcid,        lc.name,        lc.source_name,        lc.source_id,        lct.ims_typelevel,        lc.parent_id,       lc.type_code,       lc.orgname,        lc.orgtype,        lc.orgunit,        lc.adminperiod,        lc.startdate_time,        lc.start_restrict,        lc.enddate_time,        lc.end_restrict  from learning_context lc,       lc_type lct where lc.id = ?  and lct.type_code = lc.type_code";
    private static final String GET_LC_PATH = "select path from rpt_learning_context  where learning_context_id = ? ";
    private static final String getTemplateIdSQL = "SELECT template_id FROM co_lc_assignment WHERE learning_context_id = ?";
    private static final String getLCChildren = "SELECT rlc.learning_context_id FROM rpt_learning_context rlc WHERE rlc.parent_learning_context_id = ?";
    static /* synthetic */ Class class$com$webct$platform$sdkext$authmoduledata$LearningContextService;

    private LearningContextService() {
    }

    public static LearningContextService getInstance() {
        if (instance == null) {
            instance = new LearningContextService();
        }
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LearningContextVO getLCInfo(Long lcId) throws VistaDataException {
        Connection conn = null;
        LearningContextVO lc = null;
        try {
            try {
                conn = this.getConnection();
                lc = this.getLCInfo(conn, lcId);
                lc.setPath(this.getLCPath(conn, lcId));
            }
            catch (NamingException e) {
                String error = "Error connecting to Vista";
                LOG.error((Object)error, (Throwable)e);
                throw new VistaDataException(error);
            }
            catch (SQLException e) {
                String error = "Error retrieving learning context information";
                LOG.error((Object)error, (Throwable)e);
                throw new VistaDataException(error, e);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            try {
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        if (conn == null) return lc;
        conn.close();
        return lc;
    }

    /*
     * Loose catch block
     */
    public List getLCChildren(long lcId) throws VistaDataException {
        Serializable child;
        ArrayList children = new ArrayList();
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        conn = this.getConnection();
        stmt = conn.prepareStatement(getLCChildren);
        stmt.setLong(1, lcId);
        rs = stmt.executeQuery();
        while (rs.next()) {
            child = new Long(rs.getLong(1));
            children.add(child);
        }
        child = children;
        Object var10_8 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return child;
        catch (Exception e) {
            try {
                String error = "Error obtaining learning context children";
                LOG.error((Object)error, (Throwable)e);
                throw new VistaDataException(error, e);
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ignored) {}
                throw throwable;
            }
        }
    }

    private Connection getConnection() throws NamingException, SQLException {
        if (datasource == null) {
            InitialContext ctx = jndiUtils.getInitialContext();
            datasource = (DataSource)ctx.lookup("WebCTDataSource");
        }
        return datasource.getConnection();
    }

    /*
     * Loose catch block
     */
    private LearningContextVO getLCInfo(Connection connection, Long lcId) throws VistaDataException {
        LearningContextVO learningContextVO;
        block17: {
            ResultSet rs;
            PreparedStatement stmt;
            block15: {
                learningContextVO = null;
                stmt = null;
                rs = null;
                Object institutionGlcId = null;
                Object institutionTitle = null;
                stmt = connection.prepareStatement(GET_LC_DATA_SQL);
                stmt.setLong(1, lcId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block15;
                learningContextVO = new LearningContextVO();
                learningContextVO.setLcId(rs.getLong(1));
                learningContextVO.setGlcId(rs.getString(2));
                learningContextVO.setName(rs.getString(3));
                learningContextVO.setImsSource(rs.getString(4));
                learningContextVO.setImsId(rs.getString(5));
                learningContextVO.setTypeLevel(rs.getInt(6));
                learningContextVO.setParentLcId(rs.getLong(7));
                learningContextVO.setTitle(rs.getString(8));
                learningContextVO.setOrganizationName(rs.getString(9));
                learningContextVO.setOrganizationType(rs.getString(10));
                learningContextVO.setOrganizationUnit(rs.getString(11));
                learningContextVO.setOrganizationUnit(rs.getString(12));
                learningContextVO.setStartDate(rs.getString(13));
                learningContextVO.setStartDateRestricted(rs.getInt(14));
                learningContextVO.setEndDate(rs.getString(15));
                learningContextVO.setEndDateRestricted(rs.getInt(16));
            }
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block17;
            }
            catch (Exception ignored) {}
            break block17;
            {
                catch (Exception e) {
                    String error = "Error obtaining learning context info";
                    LOG.error((Object)error, (Throwable)e);
                    throw new VistaDataException(error, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (learningContextVO.isSection()) {
            learningContextVO.setTemplateId(this.getTemplateId(lcId));
        }
        return learningContextVO;
    }

    /*
     * Loose catch block
     */
    private String getLCPath(Connection connection, Long lcId) throws VistaDataException {
        String lcPath;
        block16: {
            ResultSet rs;
            PreparedStatement stmt;
            block14: {
                lcPath = null;
                stmt = null;
                rs = null;
                stmt = connection.prepareStatement(GET_LC_PATH);
                stmt.setLong(1, lcId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block14;
                lcPath = rs.getString(1);
            }
            Object var9_6 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block16;
            }
            catch (Exception ignored) {}
            break block16;
            {
                catch (Exception e) {
                    String error = "Error obtaining learning context path";
                    LOG.error((Object)error, (Throwable)e);
                    throw new VistaDataException(error, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return lcPath;
    }

    /*
     * Loose catch block
     */
    String getTemplateId(Long lcId) throws VistaDataException {
        String templateId;
        block22: {
            ResultSet rs;
            PreparedStatement stmt;
            Connection conn;
            block19: {
                templateId = null;
                conn = null;
                stmt = null;
                rs = null;
                conn = this.getConnection();
                stmt = conn.prepareStatement(getTemplateIdSQL);
                stmt.setLong(1, lcId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block19;
                templateId = rs.getString(1);
            }
            Object var9_6 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block22;
            }
            catch (Exception ignored) {}
            break block22;
            {
                catch (Exception e) {
                    String error = "Error retrieving templateId for lcId(" + lcId + ")";
                    LOG.error((Object)error, (Throwable)e);
                    throw new VistaDataException(error, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return templateId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

