/*
 * Decompiled with CFR 0.152.
 */
package com.webct.platform.sdkext.authmoduledata;

public class LearningContextVO {
    public static final int TYPELEVEL_SERVER = 10;
    public static final int TYPELEVEL_DOMAIN = 15;
    public static final int TYPELEVEL_INSTITUTION = 20;
    public static final int TYPELEVEL_DIVISION = 25;
    public static final int TYPELEVEL_GROUP = 30;
    public static final int TYPELEVEL_COURSE = 80;
    public static final int TYPELEVEL_SECTION = 90;
    public static final int TYPELEVEL_LEARNING_GROUP = 95;
    public static final int TYPELEVEL_ALL = 99;
    private String administrativePeriod;
    private String endDate;
    private int endDateRestricted;
    private String fullDescription;
    private String glcId;
    private String imsId;
    private String imsSource;
    private long lcId = -1L;
    private String longDescription;
    private String name;
    private String organizationName;
    private String organizationType;
    private String organizationUnit;
    private long parentLcId = -1L;
    private String path;
    private String startDate;
    private int startDateRestricted;
    private String templateId;
    private String title;
    private int typeLevel = 0;

    public LearningContextVO() {
    }

    public LearningContextVO(String administrativePeriod, String endDate, int endDateRestricted, String fullDescription, String glcId, String imsId, String imsSource, long lcId, String longDescription, String name, String organizationName, String organizationType, String organizationUnit, long parentLcId, String path, String startDate, int startDateRestricted, String templateId, String title, int typeLevel) {
        this.administrativePeriod = administrativePeriod;
        this.endDate = endDate;
        this.endDateRestricted = endDateRestricted;
        this.fullDescription = fullDescription;
        this.glcId = glcId;
        this.imsId = imsId;
        this.imsSource = imsSource;
        this.lcId = lcId;
        this.longDescription = longDescription;
        this.name = name;
        this.organizationName = organizationName;
        this.organizationType = organizationType;
        this.organizationUnit = organizationUnit;
        this.parentLcId = parentLcId;
        this.path = path;
        this.startDate = startDate;
        this.startDateRestricted = startDateRestricted;
        this.templateId = templateId;
        this.title = title;
        this.typeLevel = typeLevel;
    }

    public String getAdministrativePeriod() {
        return this.administrativePeriod;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public int getEndDateRestricted() {
        return this.endDateRestricted;
    }

    public String getFullDescription() {
        return this.fullDescription;
    }

    public String getGlcId() {
        return this.glcId;
    }

    public String getImsId() {
        return this.imsId;
    }

    public String getImsSource() {
        return this.imsSource;
    }

    public long getLcId() {
        return this.lcId;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getOrganizationType() {
        return this.organizationType;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public long getParentLcId() {
        return this.parentLcId;
    }

    public String getPath() {
        return this.path;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public int getStartDateRestricted() {
        return this.startDateRestricted;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTypeLabel() {
        String label = null;
        switch (this.typeLevel) {
            case 10: {
                label = "SERVER";
                break;
            }
            case 15: {
                label = "DOMAIN";
                break;
            }
            case 20: {
                label = "INSTITUTION";
                break;
            }
            case 25: {
                label = "DIVISION";
                break;
            }
            case 30: {
                label = "GROUP";
                break;
            }
            case 80: {
                label = "COURSE";
                break;
            }
            case 90: {
                label = "SECTION";
                break;
            }
            case 95: {
                label = "LEARNING_GROUP";
                break;
            }
            default: {
                label = "UNKNOWN";
            }
        }
        return label;
    }

    public int getTypeLevel() {
        return this.typeLevel;
    }

    public boolean isServer() {
        return this.typeLevel == 10;
    }

    public boolean isDomain() {
        return this.typeLevel == 15;
    }

    public boolean isInstitution() {
        return this.typeLevel == 20;
    }

    public boolean isDivision() {
        return this.typeLevel == 25;
    }

    public boolean isGroup() {
        return this.typeLevel == 30;
    }

    public boolean isCourse() {
        return this.typeLevel == 80;
    }

    public boolean isSection() {
        return this.typeLevel == 90;
    }

    public boolean isStartDateRestricted() {
        return this.startDateRestricted == 1;
    }

    public boolean isEndDateRestricted() {
        return this.endDateRestricted == 1;
    }

    void setAdministrativePeriod(String value) {
        this.administrativePeriod = value;
    }

    void setEndDate(String value) {
        this.endDate = value;
    }

    void setEndDateRestricted(int value) {
        this.endDateRestricted = value;
    }

    void setFullDescription(String value) {
        this.fullDescription = value;
    }

    void setGlcId(String value) {
        this.glcId = value;
    }

    void setImsId(String value) {
        this.imsId = value;
    }

    void setImsSource(String value) {
        this.imsSource = value;
    }

    void setLcId(long value) {
        this.lcId = value;
    }

    void setLongDescription(String value) {
        this.longDescription = value;
    }

    void setName(String value) {
        this.name = value;
    }

    void setOrganizationName(String value) {
        this.organizationName = value;
    }

    void setOrganizationType(String value) {
        this.organizationType = value;
    }

    void setOrganizationUnit(String value) {
        this.organizationUnit = value;
    }

    void setParentLcId(long value) {
        this.parentLcId = value;
    }

    void setPath(String value) {
        this.path = value;
    }

    void setStartDate(String value) {
        this.startDate = value;
    }

    void setStartDateRestricted(int value) {
        this.startDateRestricted = value;
    }

    void setTemplateId(String value) {
        this.templateId = value;
    }

    void setTitle(String value) {
        this.title = value;
    }

    void setTypeLevel(int value) {
        this.typeLevel = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Learning context:");
        sb.append("\n - LC ID: " + this.lcId);
        sb.append("\n - Parent LC ID: " + this.parentLcId);
        sb.append("\n - GLC ID: " + this.glcId);
        sb.append("\n - Name: " + this.name);
        sb.append("\n - Title: " + this.title);
        sb.append("\n - Long Description: " + this.longDescription);
        sb.append("\n - Full Description: " + this.fullDescription);
        sb.append("\n - Organization Name: " + this.organizationName);
        sb.append("\n - Organization Type: " + this.organizationType);
        sb.append("\n - Organization Unit: " + this.organizationUnit);
        sb.append("\n - Administrative Period: " + this.administrativePeriod);
        sb.append("\n - Start Date: " + this.startDate);
        sb.append("\n - Start Date Restricted: " + this.startDateRestricted);
        sb.append("\n - End Date: " + this.endDate);
        sb.append("\n - End Date Restricted: " + this.endDateRestricted);
        sb.append("\n - IMS Source: " + this.imsSource);
        sb.append("\n - IMS Id: " + this.imsId);
        sb.append("\n - TypeLevel: " + this.typeLevel);
        sb.append("\n - TypeLabel: " + this.getTypeLabel());
        sb.append("\n - Path: " + this.path);
        sb.append("\n - Template Id: " + this.templateId);
        sb.append("\n - Is section: " + this.isSection());
        return sb.toString();
    }
}

