/*
 * Decompiled with CFR 0.152.
 */
package com.webct.platform.sdkext.authmoduledata;

import com.webct.platform.framework.dataaccess.sql.common.DBType;
import com.webct.platform.framework.dataaccess.sql.common.VistaDataSourceProvider;
import com.webct.platform.framework.jndi.jndiUtils;
import com.webct.platform.sdkext.authmoduledata.LearningContextVO;
import com.webct.platform.sdkext.authmoduledata.UserRole;
import com.webct.platform.sdkext.authmoduledata.UserVO;
import com.webct.platform.sdkext.authmoduledata.VistaDataException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class UserService {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$webct$platform$sdkext$authmoduledata$UserService == null ? (class$com$webct$platform$sdkext$authmoduledata$UserService = UserService.class$("com.webct.platform.sdkext.authmoduledata.UserService")) : class$com$webct$platform$sdkext$authmoduledata$UserService));
    private static UserService instance = null;
    private static DataSource datasource = null;
    private final String jndiName = "WebCTPKDataSourceJNDIName";
    private static final String GET_USER_DATA_SQL = "SELECT DISTINCT p.name_n_given, p.name_n_family, p.name_n_other, p.name_n_prefix, p.name_n_suffix, p.sourcedid_source, m.status_flag,  p.demouser, p.learning_context_id,  p.email,  p.remote_userid,  p.id  FROM person p, member m  WHERE p.id = m.person_id  AND p.webct_id = ?  AND m.learning_context_id = ? ";
    private static final String GET_USER_DATA_SQL2 = "SELECT DISTINCT p.name_n_given, p.name_n_family, p.name_n_other, p.name_n_prefix, p.name_n_suffix, p.sourcedid_source, p.demouser, p.learning_context_id,  p.email,  p.remote_userid,  p.id  FROM person p  WHERE p.webct_id = ? ";
    private static final String GET_USER_ROLE_SQL = "SELECT rpt_member.role FROM rpt_member, rpt_person WHERE rpt_member.person_id = rpt_person.person_id AND rpt_person.user_id = ? AND rpt_member.learning_context_id = ?";
    private static final String GET_SECTION_USERS_SQL = "SELECT DISTINCT p.user_id FROM rpt_member m, rpt_person p WHERE p.person_id = m.person_id AND m.learning_context_id = ?";
    private static final String GET_COURSE_LIST_SQL = "SELECT DISTINCT m.learning_context_id,        lc.glcid,        lc.name,        lc.source_name,        lc.source_id,        lct.ims_typelevel,        reporting_interface_pkg.getLcPath(lc.id) path,        lc.parent_id,        lc.type_code,        lc.orgname,        lc.orgtype,        lc.orgunit,        lc.adminperiod,        lc.startdate_time,        lc.start_restrict,        lc.enddate_time,        lc.end_restrict FROM rpt_member m, rpt_person p, learning_context lc, lc_type lct WHERE m.person_id = p.person_id AND p.user_id = ? AND lc.id = m.learning_context_id AND lc.TYPE_CODE = lct.TYPE_CODE AND lct.IMS_TYPELEVEL = ? ";
    private static final String GET_COURSE_LIST_SQL_SERVER = "SELECT DISTINCT m.learning_context_id,        lc.glcid,        lc.name,        lc.source_name,        lc.source_id,        lct.ims_typelevel,        dbo.reporting_interface_pkg$GetLcPath(lc.id) path,        lc.parent_id,        lc.type_code,        lc.orgname,        lc.orgtype,        lc.orgunit,        lc.adminperiod,        lc.startdate_time,        lc.start_restrict,        lc.enddate_time,        lc.end_restrict FROM rpt_member m, rpt_person p, learning_context lc, lc_type lct WHERE m.person_id = p.person_id AND p.user_id = ? AND lc.id = m.learning_context_id AND lc.TYPE_CODE = lct.TYPE_CODE AND lct.IMS_TYPELEVEL = ? ";
    private static final String GET_COURSE_LIST_ALL_SQL = "SELECT DISTINCT m.learning_context_id,        lc.glcid,        lc.name,        lc.source_name,        lc.source_id,        lct.ims_typelevel,        reporting_interface_pkg.getLcPath(lc.id) path,        lc.parent_id,        lc.type_code,        lc.orgname,        lc.orgtype,        lc.orgunit,        lc.adminperiod,        lc.startdate_time,        lc.start_restrict,        lc.enddate_time,        lc.end_restrict FROM rpt_member m, rpt_person p, learning_context lc, lc_type lct WHERE m.person_id = p.person_id AND p.user_id = ? AND lc.id = m.learning_context_id AND lc.type_code = lct.type_code ";
    private static final String GET_COURSE_LIST_ALL_SQL_SERVER = "SELECT DISTINCT m.learning_context_id,        lc.glcid,        lc.name,        lc.source_name,        lc.source_id,        lct.ims_typelevel,        dbo.reporting_interface_pkg$GetLcPath(lc.id) path,        lc.parent_id,        lc.type_code,        lc.orgname,        lc.orgtype,        lc.orgunit,        lc.adminperiod,        lc.startdate_time,        lc.start_restrict,        lc.enddate_time,        lc.end_restrict FROM rpt_member m, rpt_person p, learning_context lc, lc_type lct WHERE m.person_id = p.person_id AND p.user_id = ? AND lc.id = m.learning_context_id AND lc.type_code = lct.type_code ";
    static /* synthetic */ Class class$com$webct$platform$sdkext$authmoduledata$UserService;

    private UserService() {
    }

    public static UserService getInstance() {
        if (instance == null) {
            instance = new UserService();
        }
        return instance;
    }

    /*
     * Loose catch block
     */
    public UserVO getUser(String userId, Long currentLCId) throws VistaDataException {
        UserVO user;
        block24: {
            ResultSet rs;
            PreparedStatement stmt;
            Connection conn;
            block21: {
                user = null;
                conn = null;
                stmt = null;
                rs = null;
                if (currentLCId < 0L) {
                    throw new VistaDataException("Learning Context ID " + currentLCId + " invalid.");
                }
                conn = this.getConnection();
                stmt = conn.prepareStatement(GET_USER_DATA_SQL);
                stmt.setString(1, userId);
                stmt.setLong(2, currentLCId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block21;
                List userRoles = this.getUserRoles(userId, currentLCId);
                user = new UserVO();
                user.setUserId(userId);
                user.setFirstName(rs.getString(1));
                user.setLastName(rs.getString(2));
                user.setOtherName(rs.getString(3));
                user.setNamePrefix(rs.getString(4));
                user.setNameSuffix(rs.getString(5));
                user.setSourceName(rs.getString(6));
                user.setSourceId(rs.getString(11));
                user.setStatus(rs.getInt(7));
                user.setDemoUser(rs.getInt(8));
                user.setInstitutionId(rs.getLong(9));
                user.setUserPrimaryKey(rs.getString(11));
                user.setPersonId(rs.getLong(12));
                user.setEmail(rs.getString(10));
                user.setUserRoles(userRoles);
            }
            Object var9_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block24;
            }
            catch (Exception ignored) {}
            break block24;
            {
                catch (Exception e) {
                    LOG.error((Object)"UserService: error obtaining user information", (Throwable)e);
                    throw new VistaDataException("UserService: error obtaining user information", e);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (user == null) {
            user = this.getUser(userId);
        }
        return user;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getMembers(Long lcId) throws VistaDataException {
        List rosterList = null;
        Connection conn = null;
        try {
            try {
                conn = this.getConnection();
                rosterList = this.getMembers(conn, lcId);
            }
            catch (Exception e) {
                String error = "Error obtaining user data";
                LOG.error((Object)error, (Throwable)e);
                throw new VistaDataException(error, e);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            try {
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        if (conn == null) return rosterList;
        conn.close();
        return rosterList;
    }

    /*
     * Loose catch block
     */
    public List getLearningContexts(String userId, int typeLevel) throws VistaDataException {
        ArrayList<LearningContextVO> lcVOs;
        block31: {
            lcVOs = new ArrayList<LearningContextVO>();
            LearningContextVO learningContextVO = null;
            ResultSet rs = null;
            Connection conn = null;
            Statement stmt = null;
            DBType dbType = VistaDataSourceProvider.getInstance().getDataSource(null, null).getDBType();
            conn = this.getConnection();
            if (dbType.isOracle()) {
                if (typeLevel == 99) {
                    stmt = conn.prepareStatement(GET_COURSE_LIST_ALL_SQL);
                    stmt.setString(1, userId);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        learningContextVO = new LearningContextVO();
                        learningContextVO.setLcId(rs.getLong(1));
                        learningContextVO.setGlcId(rs.getString(2));
                        learningContextVO.setName(rs.getString(3));
                        learningContextVO.setImsSource(rs.getString(4));
                        learningContextVO.setImsId(rs.getString(5));
                        learningContextVO.setTypeLevel(rs.getInt(6));
                        learningContextVO.setPath(rs.getString(7));
                        learningContextVO.setParentLcId(rs.getLong(8));
                        learningContextVO.setTitle(rs.getString(9));
                        learningContextVO.setOrganizationName(rs.getString(10));
                        learningContextVO.setOrganizationType(rs.getString(11));
                        learningContextVO.setOrganizationUnit(rs.getString(12));
                        learningContextVO.setOrganizationUnit(rs.getString(13));
                        learningContextVO.setStartDate(rs.getString(14));
                        learningContextVO.setStartDateRestricted(rs.getInt(15));
                        learningContextVO.setEndDate(rs.getString(16));
                        learningContextVO.setEndDateRestricted(rs.getInt(17));
                        lcVOs.add(learningContextVO);
                    }
                } else {
                    stmt = conn.prepareStatement(GET_COURSE_LIST_SQL);
                    stmt.setString(1, userId);
                    stmt.setInt(2, typeLevel);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        learningContextVO = new LearningContextVO();
                        learningContextVO.setLcId(rs.getLong(1));
                        learningContextVO.setGlcId(rs.getString(2));
                        learningContextVO.setName(rs.getString(3));
                        learningContextVO.setImsSource(rs.getString(4));
                        learningContextVO.setImsId(rs.getString(5));
                        learningContextVO.setTypeLevel(rs.getInt(6));
                        learningContextVO.setPath(rs.getString(7));
                        learningContextVO.setParentLcId(rs.getLong(8));
                        learningContextVO.setTitle(rs.getString(9));
                        learningContextVO.setOrganizationName(rs.getString(10));
                        learningContextVO.setOrganizationType(rs.getString(11));
                        learningContextVO.setOrganizationUnit(rs.getString(12));
                        learningContextVO.setOrganizationUnit(rs.getString(13));
                        learningContextVO.setStartDate(rs.getString(14));
                        learningContextVO.setStartDateRestricted(rs.getInt(15));
                        learningContextVO.setEndDate(rs.getString(16));
                        learningContextVO.setEndDateRestricted(rs.getInt(17));
                        lcVOs.add(learningContextVO);
                    }
                }
            } else if (typeLevel == 99) {
                stmt = conn.prepareStatement(GET_COURSE_LIST_ALL_SQL_SERVER);
                stmt.setString(1, userId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    learningContextVO = new LearningContextVO();
                    learningContextVO.setLcId(rs.getLong(1));
                    learningContextVO.setGlcId(rs.getString(2));
                    learningContextVO.setName(rs.getString(3));
                    learningContextVO.setImsSource(rs.getString(4));
                    learningContextVO.setImsId(rs.getString(5));
                    learningContextVO.setTypeLevel(rs.getInt(6));
                    learningContextVO.setPath(rs.getString(7));
                    learningContextVO.setParentLcId(rs.getLong(8));
                    learningContextVO.setTitle(rs.getString(9));
                    learningContextVO.setOrganizationName(rs.getString(10));
                    learningContextVO.setOrganizationType(rs.getString(11));
                    learningContextVO.setOrganizationUnit(rs.getString(12));
                    learningContextVO.setOrganizationUnit(rs.getString(13));
                    learningContextVO.setStartDate(rs.getString(14));
                    learningContextVO.setStartDateRestricted(rs.getInt(15));
                    learningContextVO.setEndDate(rs.getString(16));
                    learningContextVO.setEndDateRestricted(rs.getInt(17));
                    lcVOs.add(learningContextVO);
                }
            } else {
                stmt = conn.prepareStatement(GET_COURSE_LIST_SQL_SERVER);
                stmt.setString(1, userId);
                stmt.setInt(2, typeLevel);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    learningContextVO = new LearningContextVO();
                    learningContextVO.setLcId(rs.getLong(1));
                    learningContextVO.setGlcId(rs.getString(2));
                    learningContextVO.setName(rs.getString(3));
                    learningContextVO.setImsSource(rs.getString(4));
                    learningContextVO.setImsId(rs.getString(5));
                    learningContextVO.setTypeLevel(rs.getInt(6));
                    learningContextVO.setPath(rs.getString(7));
                    learningContextVO.setParentLcId(rs.getLong(8));
                    learningContextVO.setTitle(rs.getString(9));
                    learningContextVO.setOrganizationName(rs.getString(10));
                    learningContextVO.setOrganizationType(rs.getString(11));
                    learningContextVO.setOrganizationUnit(rs.getString(12));
                    learningContextVO.setOrganizationUnit(rs.getString(13));
                    learningContextVO.setStartDate(rs.getString(14));
                    learningContextVO.setStartDateRestricted(rs.getInt(15));
                    learningContextVO.setEndDate(rs.getString(16));
                    learningContextVO.setEndDateRestricted(rs.getInt(17));
                    lcVOs.add(learningContextVO);
                }
            }
            Object var11_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block31;
            }
            catch (Exception ignored) {}
            break block31;
            {
                catch (Exception e) {
                    LOG.error((Object)"UserService: error obtaining lcId List", (Throwable)e);
                    throw new VistaDataException("UserService: error obtaining course list", e);
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return lcVOs;
    }

    /*
     * Loose catch block
     */
    public List getUserRoles(String userId, Long lcId) throws VistaDataException {
        ArrayList<UserRole> roles = new ArrayList<UserRole>();
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        conn = this.getConnection();
        stmt = conn.prepareStatement(GET_USER_ROLE_SQL);
        stmt.setString(1, userId);
        stmt.setLong(2, lcId);
        rs = stmt.executeQuery();
        while (rs.next()) {
            roles.add(UserRole.forName(rs.getString(1)));
        }
        ArrayList<UserRole> arrayList = roles;
        Object var9_9 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return arrayList;
        catch (Exception e) {
            try {
                LOG.error((Object)"UserService: error obtaining userRole", (Throwable)e);
                throw new VistaDataException("UserService: error obtaining userRole", e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ignored) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private UserVO getUser(String userId) throws VistaDataException {
        UserVO user;
        block22: {
            ResultSet rs;
            PreparedStatement stmt;
            Connection conn;
            block19: {
                user = null;
                conn = null;
                stmt = null;
                rs = null;
                conn = this.getConnection();
                stmt = conn.prepareStatement(GET_USER_DATA_SQL2);
                stmt.setString(1, userId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block19;
                user = new UserVO();
                user.setUserId(userId);
                user.setFirstName(rs.getString(1));
                user.setLastName(rs.getString(2));
                user.setOtherName(rs.getString(3));
                user.setNamePrefix(rs.getString(4));
                user.setNameSuffix(rs.getString(5));
                user.setSourceName(rs.getString(6));
                user.setSourceId(rs.getString(10));
                user.setDemoUser(rs.getInt(7));
                user.setInstitutionId(rs.getLong(8));
                user.setUserPrimaryKey(rs.getString(10));
                user.setPersonId(rs.getLong(11));
                user.setEmail(rs.getString(9));
            }
            Object var8_6 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block22;
            }
            catch (Exception ignored) {}
            break block22;
            {
                catch (Exception e) {
                    LOG.error((Object)"UserService: error obtaining user information from person", (Throwable)e);
                    throw new VistaDataException("UserService: error obtaining user information from person", e);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return user;
    }

    /*
     * Loose catch block
     */
    private List getMembers(Connection conn, Long lcId) throws VistaDataException {
        ArrayList<UserVO> userList;
        block16: {
            userList = new ArrayList<UserVO>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            stmt = conn.prepareStatement(GET_SECTION_USERS_SQL);
            stmt.setLong(1, lcId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                UserVO user = this.getUser(rs.getString(1), lcId);
                userList.add(user);
            }
            Object var9_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block16;
            }
            catch (Exception ignored) {}
            break block16;
            {
                catch (Exception e) {
                    String error = "Error obtaining user data from database";
                    LOG.error((Object)error, (Throwable)e);
                    throw new VistaDataException(error, e);
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return userList;
    }

    private Connection getConnection() throws NamingException, SQLException {
        if (datasource == null) {
            InitialContext ctx = jndiUtils.getInitialContext();
            datasource = (DataSource)ctx.lookup("WebCTDataSource");
        }
        return datasource.getConnection();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

