/*
 * Decompiled with CFR 0.152.
 */
package com.webct.platform.sdkext.authmoduledata;

import com.webct.platform.sdkext.authmoduledata.UserRole;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UserVO {
    private int demoUser;
    private String firstName;
    private long institutionLCId;
    private long personId;
    private String lastName;
    private String namePrefix;
    private String nameSuffix;
    private String otherName;
    private String sourceId;
    private String sourceName;
    private int status;
    private String userId;
    private String userPrimaryKey;
    private List userRoles;
    private String passwordHash;
    private String email;

    public UserVO() {
        this.userRoles = new ArrayList();
    }

    public UserVO(int demoUser, String firstName, long institutionId, long personId, String lastName, String namePrefix, String nameSuffix, String otherName, String sourceId, String sourceName, int status, String userId, String passwordHash, String email, String userPrimaryKey, List userRoles) {
        this.demoUser = demoUser;
        this.firstName = firstName;
        this.institutionLCId = institutionId;
        this.personId = personId;
        this.lastName = lastName;
        this.namePrefix = namePrefix;
        this.nameSuffix = nameSuffix;
        this.otherName = otherName;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.status = status;
        this.userId = userId;
        this.passwordHash = passwordHash;
        this.email = email;
        this.userPrimaryKey = userPrimaryKey;
        this.userRoles = new ArrayList();
        this.userRoles.addAll(userRoles);
    }

    public int getDemoUser() {
        return this.demoUser;
    }

    public String getFirstname() {
        return this.firstName;
    }

    public long getInstitutionLCId() {
        return this.institutionLCId;
    }

    public long getPersonId() {
        return this.personId;
    }

    public String getLastname() {
        return this.lastName;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public String getOtherName() {
        return this.otherName;
    }

    public String getsourceId() {
        return this.sourceId;
    }

    public String getsourceName() {
        return this.sourceName;
    }

    public int getStatus() {
        return this.status;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPasswordHash() {
        return null;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUserPrimaryKey() {
        return this.userPrimaryKey;
    }

    public List getUserRoles() {
        return this.userRoles;
    }

    public boolean isUserInRole(String roleName) {
        boolean isUserInRole = false;
        UserRole role = UserRole.forName(roleName);
        Iterator userRolesIter = this.userRoles.iterator();
        while (userRolesIter.hasNext()) {
            UserRole userRole = (UserRole)userRolesIter.next();
            if (!role.equals(userRole)) continue;
            isUserInRole = true;
            break;
        }
        return isUserInRole;
    }

    public boolean isUserInRole(UserRole role) {
        boolean isUserInRole = false;
        Iterator userRolesIter = this.userRoles.iterator();
        while (userRolesIter.hasNext()) {
            UserRole userRole = (UserRole)userRolesIter.next();
            if (!role.equals(userRole)) continue;
            isUserInRole = true;
            break;
        }
        return isUserInRole;
    }

    public boolean isDemoUser() {
        return this.demoUser == 1;
    }

    public boolean isAuditor() {
        return this.userRoles.contains(UserRole.AUDITOR_ROLE);
    }

    public boolean isCourseDesigner() {
        return this.userRoles.contains(UserRole.COURSE_DESIGNER_ROLE);
    }

    public boolean isCourseInstructor() {
        return this.userRoles.contains(UserRole.COURSE_INSTRUCTOR_ROLE);
    }

    public boolean isDesignerInstructor() {
        return this.userRoles.contains(UserRole.DESIGNER_INSTRUCTOR_ROLE);
    }

    public boolean isDomainAdmin() {
        return this.userRoles.contains(UserRole.DOMAIN_ADMIN_ROLE);
    }

    public boolean isDomainDesigner() {
        return this.userRoles.contains(UserRole.DOMAIN_DESIGNER_ROLE);
    }

    public boolean isGroupAdmin() {
        return this.userRoles.contains(UserRole.GROUP_ADMIN_ROLE);
    }

    public boolean isGroupDesigner() {
        return this.userRoles.contains(UserRole.GROUP_DESIGNER_ROLE);
    }

    public boolean isInstitutionalAdmin() {
        return this.userRoles.contains(UserRole.INSTITUTIONAL_ADMIN_ROLE);
    }

    public boolean isInstitutionalDesigner() {
        return this.userRoles.contains(UserRole.INSTITUTIONAL_DESIGNER_ROLE);
    }

    public boolean isSectionInstructor() {
        return this.userRoles.contains(UserRole.SECTION_INSTRUCTOR_ROLE);
    }

    public boolean isSectionDesigner() {
        return this.userRoles.contains(UserRole.SECTION_DESIGNER_ROLE);
    }

    public boolean isStudent() {
        return this.userRoles.contains(UserRole.STUDENT_ROLE);
    }

    public boolean isTA() {
        return this.userRoles.contains(UserRole.TA_ROLE);
    }

    public boolean isMentor() {
        return this.userRoles.contains(UserRole.MENTOR_ROLE);
    }

    void setDemoUser(int value) {
        this.demoUser = value;
    }

    void setFirstName(String value) {
        this.firstName = value;
    }

    void setInstitutionId(long value) {
        this.institutionLCId = value;
    }

    void setPersonId(long value) {
        this.personId = value;
    }

    void setLastName(String value) {
        this.lastName = value;
    }

    void setNamePrefix(String value) {
        this.namePrefix = value;
    }

    void setNameSuffix(String value) {
        this.nameSuffix = value;
    }

    void setOtherName(String value) {
        this.otherName = value;
    }

    void setSourceId(String value) {
        this.sourceId = value;
    }

    void setSourceName(String value) {
        this.sourceName = value;
    }

    void setStatus(int value) {
        this.status = value;
    }

    void setUserId(String value) {
        this.userId = value;
    }

    void setPasswordHash(String value) {
        this.passwordHash = null;
    }

    void setEmail(String value) {
        this.email = value;
    }

    void setUserPrimaryKey(String value) {
        this.userPrimaryKey = value;
    }

    void setUserRoles(List value) {
        this.userRoles.clear();
        this.userRoles.addAll(value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("User:");
        sb.append("\n - User Id: " + this.userId);
        sb.append("\n - Person Id: " + this.personId);
        sb.append("\n - First Name: " + this.firstName);
        sb.append("\n - Last Name: " + this.lastName);
        sb.append("\n - Other Name: " + this.otherName);
        sb.append("\n - Name Prefix: " + this.namePrefix);
        sb.append("\n - Name Suffix: " + this.nameSuffix);
        sb.append("\n - Login Instituion Id: " + this.institutionLCId);
        sb.append("\n - Status: " + this.status);
        sb.append("\n - Source Name: " + this.sourceName);
        sb.append("\n - Source Id: " + this.sourceId);
        sb.append("\n - Email Address: " + this.email);
        sb.append("\n - User Primary Key: " + this.userPrimaryKey);
        sb.append("\n - Demo User: " + this.isDemoUser());
        sb.append("\n - Roles:");
        Iterator rolesIter = this.userRoles.iterator();
        while (rolesIter.hasNext()) {
            UserRole userRole = (UserRole)rolesIter.next();
            sb.append(" " + userRole);
        }
        return sb.toString();
    }
}

