/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.strategy.ConditionGateActivityStrategy;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.util.MessageService;

public class ConditionGateActivity
extends GateActivity
implements Serializable {
    public ConditionGateActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Boolean stopAfterActivity, Set inputActivities, Integer gateActivityLevelId, Set waitingLearners, SystemTool sysTool, Set branchActivityEntries) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, stopAfterActivity, inputActivities, gateActivityLevelId, waitingLearners, sysTool, branchActivityEntries);
        this.simpleActivityStrategy = new ConditionGateActivityStrategy(this);
    }

    public ConditionGateActivity() {
        this.simpleActivityStrategy = new ConditionGateActivityStrategy(this);
    }

    public ConditionGateActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Integer gateActivityLevelId, Set waitingLearners) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, gateActivityLevelId, waitingLearners);
        this.simpleActivityStrategy = new ConditionGateActivityStrategy(this);
    }

    public Activity createCopy(int uiidOffset) {
        ConditionGateActivity newConditionGateActivity = new ConditionGateActivity();
        this.copyToNewActivity(newConditionGateActivity, uiidOffset);
        newConditionGateActivity.setGateOpen(new Boolean(false));
        newConditionGateActivity.setGateActivityLevelId(this.getGateActivityLevelId());
        if (this.getBranchActivityEntries() != null && this.getBranchActivityEntries().size() > 0) {
            newConditionGateActivity.setBranchActivityEntries(new HashSet());
            for (BranchActivityEntry oldEntry : this.getBranchActivityEntries()) {
                BranchActivityEntry newEntry = new BranchActivityEntry(null, LearningDesign.addOffset(oldEntry.getEntryUIID(), uiidOffset), null, newConditionGateActivity, null, oldEntry.getGateOpenWhenConditionMet());
                if (oldEntry.getCondition() != null) {
                    BranchCondition newCondition = oldEntry.getCondition().clone(uiidOffset);
                    newEntry.setCondition(newCondition);
                }
                newConditionGateActivity.getBranchActivityEntries().add(newEntry);
            }
        }
        return newConditionGateActivity;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    public boolean isNull() {
        return false;
    }

    public Vector validateActivity(MessageService messageService) {
        Vector<ValidationErrorDTO> listOfValidationErrors = new Vector<ValidationErrorDTO>();
        if (this.getInputActivities() == null || this.getInputActivities().size() == 0) {
            listOfValidationErrors.add(new ValidationErrorDTO("CGI", messageService.getMessage("validation.error.conditionGateMustHaveAnInputToolActivity"), this.getActivityUIID()));
        }
        boolean conditionsExist = false;
        if (this.getBranchActivityEntries() != null) {
            for (BranchActivityEntry entry : this.getBranchActivityEntries()) {
                BranchCondition condition = entry.getCondition();
                if (condition == null) {
                    listOfValidationErrors.add(new ValidationErrorDTO("BCOND", messageService.getMessage("validation.error.toolBranchingConditionInvalid"), this.getActivityUIID()));
                    continue;
                }
                conditionsExist = true;
                if (condition.isValid()) continue;
                listOfValidationErrors.add(new ValidationErrorDTO("BCOND", messageService.getMessage("validation.error.toolBranchingConditionInvalid"), this.getActivityUIID()));
            }
        }
        if (!conditionsExist) {
            listOfValidationErrors.add(new ValidationErrorDTO("CGC", messageService.getMessage("validation.error.conditionGateMustHaveACondition"), this.getActivityUIID()));
        }
        return listOfValidationErrors;
    }
}

