/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.index.IndexLessonBean;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouper;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.exception.GroupingException;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonClassDAO;
import org.lamsfoundation.lams.lesson.dao.ILessonDAO;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.lesson.dto.LessonDetailsDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.service.LessonServiceException;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessonService
implements ILessonService {
    private static Logger log = Logger.getLogger(LessonService.class);
    private ILessonDAO lessonDAO;
    private ILessonClassDAO lessonClassDAO;
    private IGroupingDAO groupingDAO;
    private MessageService messageService;
    private IBaseDAO baseDAO;
    private ILearnerProgressDAO learnerProgressDAO;

    public void setLessonDAO(ILessonDAO lessonDAO) {
        this.lessonDAO = lessonDAO;
    }

    public void setLessonClassDAO(ILessonClassDAO lessonClassDAO) {
        this.lessonClassDAO = lessonClassDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public void setLearnerProgressDAO(ILearnerProgressDAO learnerProgressDAO) {
        this.learnerProgressDAO = learnerProgressDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    @Override
    public List getActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getActiveLearnerByLesson(lessonId);
    }

    @Override
    public List getActiveLessonLearnersByGroup(Long lessonId, Long groupId) {
        return this.lessonDAO.getActiveLearnerByLessonAndGroup(lessonId, groupId);
    }

    @Override
    public Integer getCountActiveLessonLearners(Long lessonId) {
        return this.lessonDAO.getCountActiveLearnerByLesson(lessonId);
    }

    @Override
    public LessonDetailsDTO getLessonDetails(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDetailsDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonDetails();
            Integer active = this.getCountActiveLessonLearners(lessonId);
            dto.setNumberStartedLearners(active != null ? active : new Integer(0));
        }
        return dto;
    }

    @Override
    public LessonDTO getLessonData(Long lessonId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        LessonDTO dto = null;
        if (lesson != null) {
            dto = lesson.getLessonData();
        }
        return dto;
    }

    @Override
    public Lesson getLesson(Long lessonId) {
        return this.lessonDAO.getLesson(lessonId);
    }

    @Override
    public void performGrouping(Long lessonId, GroupingActivity groupingActivity, User learner) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        if (grouping != null && grouping.isRandomGrouping()) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    if (grouping.getGroups().size() == 0) {
                        List usersInLesson = this.getActiveLessonLearners(lessonId);
                        grouper.doGrouping(grouping, (String)null, usersInLesson);
                    } else if (!grouping.doesLearnerExist(learner)) {
                        grouper.doGrouping(grouping, null, learner);
                    }
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performGrouping supports only grouping methods where the grouper decides the groups (currently only RandomGrouping). Called with a groupingActivity with the wrong grouper " + groupingActivity.getActivityId();
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void performGrouping(GroupingActivity groupingActivity, String groupName, List learners) throws LessonServiceException {
        Grouping grouping = groupingActivity.getCreateGrouping();
        this.performGrouping(grouping, groupName, learners);
    }

    @Override
    public void performGrouping(Grouping grouping, String groupName, List learners) throws LessonServiceException {
        Grouper grouper;
        if (grouping != null && (grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper()) != null) {
            grouper.setCommonMessageService(this.messageService);
            try {
                grouper.doGrouping(grouping, groupName, learners);
            }
            catch (GroupingException e) {
                throw new LessonServiceException(e);
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public void performGrouping(Grouping grouping, Long groupId, User learner) throws LessonServiceException {
        Grouper grouper;
        if (grouping != null && (grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper()) != null) {
            grouper.setCommonMessageService(this.messageService);
            try {
                ArrayList<User> learners = new ArrayList<User>(1);
                learners.add(learner);
                grouper.doGrouping(grouping, groupId, learners);
            }
            catch (GroupingException e) {
                throw new LessonServiceException(e);
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public void performGrouping(Grouping grouping, Long groupId, List learners) throws LessonServiceException {
        if (grouping != null) {
            Grouper grouper = grouping.getGrouper();
            if (grouper != null) {
                grouper.setCommonMessageService(this.messageService);
                try {
                    grouper.doGrouping(grouping, groupId, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
                this.groupingDAO.update(grouping);
            }
        } else {
            String error = "The method performChosenGrouping supports only grouping methods where the supplied list should be used as a single group (currently only ChosenGrouping). Called with a grouping with the wrong grouper " + grouping;
            log.error((Object)error);
            throw new LessonServiceException(error);
        }
    }

    @Override
    public void removeLearnersFromGroup(Grouping grouping, Long groupID, List<User> learners) throws LessonServiceException {
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.removeLearnersFromGroup(grouping, groupID, learners);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public Group createGroup(Grouping grouping, String name) throws LessonServiceException {
        Group newGroup = null;
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    newGroup = grouper.createGroup(grouping, name);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
        return newGroup;
    }

    @Override
    public void removeGroup(Grouping grouping, Long groupID) throws LessonServiceException {
        if (grouping != null) {
            Grouper grouper = (grouping = this.groupingDAO.getGroupingById(grouping.getGroupingId())).getGrouper();
            if (grouper != null) {
                try {
                    grouper.removeGroup(grouping, groupID);
                }
                catch (GroupingException e) {
                    throw new LessonServiceException(e);
                }
            }
            this.groupingDAO.update(grouping);
        }
    }

    @Override
    public boolean addLearner(Long lessonId, Integer userId) throws LessonServiceException {
        User user;
        boolean ret;
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        Group learnersGroup = lessonClass.getLearnersGroup();
        if (learnersGroup != null) {
            this.lessonDAO.initialize(learnersGroup);
        }
        if (ret = lessonClass.addLearner(user = (User)this.baseDAO.find(User.class, userId))) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        return ret;
    }

    @Override
    public void addLearners(Long lessonId, Integer[] userIds) throws LessonServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        Group learnersGroup = lessonClass.getLearnersGroup();
        if (learnersGroup != null) {
            this.lessonDAO.initialize(learnersGroup);
        }
        HashSet<User> users = new HashSet<User>();
        for (Integer userId : userIds) {
            User user = (User)this.baseDAO.find(User.class, userId);
            users.add(user);
        }
        this.addLearners(lesson, users);
    }

    @Override
    public void addLearners(Lesson lesson, Collection<User> users) throws LessonServiceException {
        LessonClass lessonClass = lesson.getLessonClass();
        int numAdded = lessonClass.addLearners(users);
        if (numAdded > 0) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + numAdded + " learners to lessonClass " + lessonClass.getGroupingId()));
        }
    }

    @Override
    public boolean addStaffMember(Long lessonId, Integer userId) {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add staff member to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add staff member to lesson.");
        }
        this.lessonDAO.initialize(lessonClass.getStaffGroup());
        User user = (User)this.baseDAO.find(User.class, userId);
        boolean ret = lessonClass.addStaffMember(user);
        if (ret) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        return ret;
    }

    @Override
    public void addStaffMembers(Long lessonId, Integer[] userIds) throws LessonServiceException {
        Lesson lesson = this.lessonDAO.getLesson(lessonId);
        if (lesson == null) {
            throw new LessonServiceException("Lesson " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        LessonClass lessonClass = lesson.getLessonClass();
        if (lessonClass == null) {
            throw new LessonServiceException("Lesson class for " + lessonId + " does not exist. Unable to add learner to lesson.");
        }
        this.lessonDAO.initialize(lessonClass.getStaffGroup());
        HashSet<User> users = new HashSet<User>();
        for (Integer userId : userIds) {
            User user = (User)this.baseDAO.find(User.class, userId);
            users.add(user);
        }
        this.addStaffMembers(lesson, users);
    }

    @Override
    public void addStaffMembers(Lesson lesson, Collection<User> users) throws LessonServiceException {
        LessonClass lessonClass = lesson.getLessonClass();
        int numAdded = lessonClass.addStaffMembers(users);
        if (numAdded > 0) {
            this.lessonClassDAO.updateLessonClass(lessonClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + numAdded + " staff members to lessonClass " + lessonClass.getGroupingId()));
        }
    }

    @Override
    public void removeProgressReferencesToActivity(Activity activity) throws LessonServiceException {
        if (activity != null) {
            log.debug((Object)("Processing learner progress for activity " + activity.getActivityId()));
            List progresses = this.learnerProgressDAO.getLearnerProgressReferringToActivity(activity);
            if (progresses != null && progresses.size() > 0) {
                for (LearnerProgress progress : progresses) {
                    if (this.removeActivityReference(activity, progress)) {
                        // empty if block
                    }
                    this.learnerProgressDAO.updateLearnerProgress(progress);
                }
            }
        }
    }

    private boolean removeActivityReference(Activity activity, LearnerProgress progress) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing learner progress learner " + progress.getUser().getUserId()));
        }
        boolean recordUpdated = false;
        boolean removed = progress.getAttemptedActivities().remove(activity);
        if (removed) {
            recordUpdated = true;
            log.debug((Object)"Removed activity from attempted activities");
        }
        if (removed = progress.getCompletedActivities().remove(activity)) {
            recordUpdated = true;
            log.debug((Object)"Removed activity from completed activities");
        }
        if (progress.getCurrentActivity() != null && progress.getCurrentActivity().equals(activity)) {
            progress.setCurrentActivity(null);
            recordUpdated = true;
            log.debug((Object)"Removed activity as current activity");
        }
        if (progress.getNextActivity() != null && progress.getNextActivity().equals(activity)) {
            progress.setNextActivity(null);
            recordUpdated = true;
            log.debug((Object)"Removed activity as next activity");
        }
        if (progress.getPreviousActivity() != null && progress.getPreviousActivity().equals(activity)) {
            progress.setPreviousActivity(null);
            recordUpdated = true;
            log.debug((Object)"Removed activity as previous activity");
        }
        return recordUpdated;
    }

    @Override
    public void performMarkLessonUncompleted(Long lessonId) throws LessonServiceException {
        int count = 0;
        if (lessonId != null) {
            log.debug((Object)("Setting learner progress to uncompleted for lesson " + lessonId));
            List progresses = this.learnerProgressDAO.getCompletedLearnerProgressForLesson(lessonId);
            if (progresses != null && progresses.size() > 0) {
                for (LearnerProgress progress : progresses) {
                    if (progress.getLessonComplete() == 1) {
                        progress.setLessonComplete((byte)0);
                    }
                    ++count;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reset completed flag for " + count + " learners for lesson " + lessonId));
        }
    }

    @Override
    public List<User> getLearnersHaveAttemptedActivity(Activity activity) throws LessonServiceException {
        return this.learnerProgressDAO.getLearnersHaveAttemptedActivity(activity);
    }

    @Override
    public List<User> getLearnersHaveCompletedActivity(Activity activity) throws LessonServiceException {
        return this.learnerProgressDAO.getLearnersHaveCompletedActivity(activity);
    }

    @Override
    public Integer getCountLearnersHaveAttemptedActivity(Activity activity) throws LessonServiceException {
        return this.learnerProgressDAO.getNumUsersAttemptedActivity(activity);
    }

    @Override
    public Integer getCountLearnersHaveCompletedActivity(Activity activity) throws LessonServiceException {
        return this.learnerProgressDAO.getNumUsersCompletedActivity(activity);
    }

    @Override
    public Map<Long, IndexLessonBean> getLessonsByOrgAndUserWithCompletedFlag(Integer userId, Integer orgId, boolean isStaff) {
        TreeMap<Long, IndexLessonBean> map = new TreeMap<Long, IndexLessonBean>();
        List list = this.lessonDAO.getLessonsByOrgAndUserWithCompletedFlag(userId, orgId, isStaff);
        if (list != null) {
            for (Object[] tuple : list) {
                Long lessonId = (Long)tuple[0];
                String lessonName = (String)tuple[1];
                String lessonDescription = (String)tuple[2];
                Integer lessonState = (Integer)tuple[3];
                Boolean lessonCompleted = (Boolean)tuple[4];
                IndexLessonBean bean = new IndexLessonBean(lessonId, lessonName, lessonDescription, lessonState, lessonCompleted == null ? false : lessonCompleted);
                map.put(new Long(lessonId), bean);
            }
        }
        return map;
    }

    @Override
    public List<Lesson> getLessonsByGroupAndUser(Integer userId, Integer organisationId) {
        TreeMap map = new TreeMap();
        List list = this.lessonDAO.getLessonsByGroupAndUser(userId, organisationId);
        return list;
    }

    @Override
    public LearnerProgress getUserProgressForLesson(Integer learnerId, Long lessonId) {
        return this.learnerProgressDAO.getLearnerProgressByLearner(learnerId, lessonId);
    }

    @Override
    public List getLessonsByOriginalLearningDesign(Long ldId, Integer orgId) {
        return this.lessonDAO.getLessonsByOriginalLearningDesign(ldId, orgId);
    }

    @Override
    public List<User> getMonitorsByToolSessionId(Long sessionId) {
        return this.lessonDAO.getMonitorsByToolSessionId(sessionId);
    }

    @Override
    public List<Lesson> getActiveLessonsForLearner(Integer learnerId, Integer organisationId) {
        return this.lessonDAO.getActiveLessonsForLearner(learnerId, organisationId);
    }
}

