/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dto;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganisationDTO {
    private Integer organisationID;
    private Integer parentID;
    private String name;
    private String description;
    private Vector<String> roleNames;
    private Vector<OrganisationDTO> nodes;
    private Integer organisationTypeId;

    public OrganisationDTO() {
    }

    public OrganisationDTO(Integer organisationID, Integer parentID, String name, String description, Integer organisationTypeId) {
        this.organisationID = organisationID;
        this.parentID = parentID;
        this.name = name;
        this.description = description;
        this.organisationTypeId = organisationTypeId;
        this.roleNames = new Vector();
        this.nodes = new Vector();
    }

    public OrganisationDTO(Organisation organisation) {
        this.organisationID = organisation.getOrganisationId();
        this.parentID = organisation.getParentOrganisation() == null ? new Integer(-1) : organisation.getParentOrganisation().getOrganisationId();
        this.name = organisation.getName();
        this.description = organisation.getDescription();
        this.organisationTypeId = organisation.getOrganisationType().getOrganisationTypeId();
        this.roleNames = new Vector();
        this.nodes = new Vector();
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public String getName() {
        return this.name != null ? this.name : "string_null_value";
    }

    public Integer getOrganisationID() {
        return this.organisationID != null ? this.organisationID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Integer getParentID() {
        return this.parentID != null ? this.parentID : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Integer getOrganisationTypeId() {
        return this.organisationTypeId;
    }

    public void addNode(OrganisationDTO organisation) {
        this.nodes.add(organisation);
    }

    public void addNodes(Collection<OrganisationDTO> list) {
        Iterator<OrganisationDTO> it = list.iterator();
        while (it.hasNext()) {
            this.addNode(it.next());
        }
    }

    public Vector<OrganisationDTO> getNodes() {
        return this.nodes;
    }

    public Vector<String> getRoleNames() {
        return this.roleNames;
    }

    public void addRoleName(String roleName) {
        this.roleNames.add(roleName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OrganisationDTO)) {
            return false;
        }
        OrganisationDTO castOther = (OrganisationDTO)other;
        return this.getOrganisationID() != null && this.getOrganisationID().equals(castOther.getOrganisationID());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getOrganisationID()).toHashCode();
    }
}

