/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlFileLoader {
    private static boolean validating = true;

    public static boolean isValidating() {
        return validating;
    }

    public static void setValidating(boolean validating) {
        XmlFileLoader.validating = validating;
    }

    public static Document getDocumentFromURL(URL url) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        InputStream is = null;
        is = url.openStream();
        return XmlFileLoader.getDocument(is, null);
    }

    public static Document getDocumentFromFilePathUsingResolver(String filePath, EntityResolver resolver) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        FileInputStream is = null;
        is = new FileInputStream(new File(filePath));
        return XmlFileLoader.getDocument(is, resolver);
    }

    public static Document getDocumentFromFilePath(String filePath) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        FileInputStream is = null;
        is = new FileInputStream(new File(filePath));
        return XmlFileLoader.getDocument(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document getDocument(InputStream is, EntityResolver resolver) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        try {
            InputSource is2 = new InputSource(is);
            Document document = XmlFileLoader.getDocument(is2, resolver);
            return document;
        }
        finally {
            is.close();
        }
    }

    private static Document getDocument(InputSource is, EntityResolver resolver) throws IOException, SAXException, SAXParseException, ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(validating);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        if (resolver != null) {
            docBuilder.setEntityResolver(resolver);
        }
        return docBuilder.parse(is);
    }
}

