/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.servlet;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.HttpUrlConnectionUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public abstract class AbstractExportPortfolioServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(AbstractExportPortfolioServlet.class);
    private static final String EXPORT_ERROR_MSG = "This activity does not support portfolio export";
    private static final String EXPORT_ERROR_FILENAME = "portfolioExportNotSupported.html";
    protected Long userID = null;
    protected Long toolSessionID = null;
    protected Long toolContentID = null;
    protected String mode = null;
    protected boolean isOffline = false;
    protected String activityTitle = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mainFileName = null;
        String directoryName = null;
        Cookie[] cookies = request.getCookies();
        directoryName = WebUtil.readStrParam(request, "directoryName");
        String absoluteDirectoryPath = FileUtil.TEMP_DIR + File.separator + directoryName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Directory name to store files is " + directoryName));
        }
        directoryName = this.checkDirectoryName(directoryName);
        if (!FileUtil.directoryExist(absoluteDirectoryPath)) {
            log.error((Object)("The directory supplied " + absoluteDirectoryPath + " does not exist."));
        }
        if (this.parametersAreValid(request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Export is conducted in mode: " + this.mode));
            }
            this.isOffline = WebUtil.readBooleanParam(request, "offline");
            mainFileName = this.isOffline ? this.doOfflineExport(request, response, absoluteDirectoryPath, cookies) : this.doExport(request, response, absoluteDirectoryPath, cookies);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The name of main html file is " + mainFileName));
            }
        } else {
            log.error((Object)"Cannot perform export for tool as some parameters are missing from the export url.");
            this.writeErrorMessageToFile(EXPORT_ERROR_MSG, directoryName, EXPORT_ERROR_FILENAME);
        }
        PrintWriter out = response.getWriter();
        out.println(mainFileName);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected abstract String doExport(HttpServletRequest var1, HttpServletResponse var2, String var3, Cookie[] var4);

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        String url = Configuration.get(ConfigurationKeys.SERVER_URL) + "/learning/exportPortfolio/offline.jsp";
        HttpSession sharedsession = SessionManager.getSession();
        if (sharedsession != null) {
            sharedsession.setAttribute("epActivityTitle", (Object)this.activityTitle);
            this.writeResponseToFile(url, directoryName, "index.html", cookies);
            sharedsession.removeAttribute("epActivityTitle");
        } else {
            this.writeResponseToFile(url, directoryName, "index.html", cookies);
        }
        return "index.html";
    }

    private String checkDirectoryName(String directoryName) {
        String validDirectoryName = FileUtil.trailingForwardSlashPresent(directoryName) ? FileUtil.removeTrailingForwardSlash(directoryName) : directoryName;
        return validDirectoryName;
    }

    protected int writeResponseToFile(String urlToConnectTo, String directoryToStoreFile, String filename, Cookie[] cookies) {
        int status = -1;
        try {
            status = HttpUrlConnectionUtil.writeResponseToFile(urlToConnectTo, directoryToStoreFile, filename, cookies);
            if (status != 1) {
                log.error((Object)"Error! The tools export servlet threw an exception");
                this.writeErrorMessageToFile(EXPORT_ERROR_MSG, directoryToStoreFile, EXPORT_ERROR_FILENAME);
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)("The URL given is invalid. Exception message is: " + e));
            this.writeErrorMessageToFile(EXPORT_ERROR_MSG, directoryToStoreFile, EXPORT_ERROR_FILENAME);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("The directory or file may not exist. Exception message is: " + e));
            this.writeErrorMessageToFile(EXPORT_ERROR_MSG, directoryToStoreFile, EXPORT_ERROR_FILENAME);
        }
        catch (IOException e) {
            log.error((Object)("A problem has occurred while writing file. Exception message is: " + e));
            this.writeErrorMessageToFile(EXPORT_ERROR_MSG, directoryToStoreFile, EXPORT_ERROR_FILENAME);
        }
        return status;
    }

    protected String appendParametersToLearnerExportURL(HttpServletRequest request, String url) {
        String finalURL = WebUtil.appendParameterToURL(url, "mode", WebUtil.readStrParam(request, "mode"));
        finalURL = WebUtil.appendParameterToURL(finalURL, "toolSessionID", WebUtil.readStrParam(request, "toolSessionID"));
        finalURL = WebUtil.appendParameterToURL(finalURL, "userID", WebUtil.readStrParam(request, "userID"));
        return finalURL;
    }

    protected String appendParametersToTeacherExportURL(HttpServletRequest request, String url) {
        String finalURL = WebUtil.appendParameterToURL(url, "mode", WebUtil.readStrParam(request, "mode"));
        finalURL = WebUtil.appendParameterToURL(finalURL, "toolContentID", WebUtil.readStrParam(request, "toolContentID"));
        return finalURL;
    }

    private void writeErrorMessageToFile(String errorMessage, String directoryToStoreFile, String filename) {
        try {
            String filepath = directoryToStoreFile + File.separator + filename;
            BufferedWriter fileout = new BufferedWriter(new FileWriter(filepath));
            fileout.write(errorMessage);
            fileout.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private boolean parametersAreValid(HttpServletRequest request) {
        boolean valid = true;
        this.mode = request.getParameter("mode");
        if (this.mode != null) {
            if (this.mode.equals(ToolAccessMode.LEARNER.toString())) {
                this.userID = new Long(request.getParameter("userID"));
                this.toolSessionID = new Long(request.getParameter("toolSessionID"));
                if (this.userID == null || this.toolSessionID == null) {
                    valid = false;
                }
            } else if (this.mode.equals(ToolAccessMode.TEACHER.toString())) {
                this.toolContentID = new Long(request.getParameter("toolContentID"));
                if (this.toolContentID == null) {
                    valid = false;
                }
            } else {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }
}

