/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.workspace.dto;

import java.util.Date;
import java.util.SortedSet;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.wddx.WDDXTAGS;
import org.lamsfoundation.lams.workspace.WorkspaceFolderContent;

public class FolderContentDTO {
    public static final String LESSON = "Lesson";
    public static final String DESIGN = "LearningDesign";
    public static final String FOLDER = "Folder";
    public static final String FILE = "File";
    public String name;
    public String description;
    public Date creationDateTime;
    public Date lastModifiedDateTime;
    public String resourceType;
    public Long resourceID;
    public Integer permissionCode;
    public Vector versionDetails;
    public Long licenseID;
    public String licenseText;
    public Boolean readOnly;

    public FolderContentDTO() {
    }

    public FolderContentDTO(String name, String description, Date creationDateTime, Date lastModifiedDateTime, String resourceType, Long resourceID, Integer permissionCode, Long licenseID) {
        this.name = name;
        this.description = description;
        this.creationDateTime = creationDateTime;
        this.lastModifiedDateTime = lastModifiedDateTime;
        this.resourceType = resourceType;
        this.resourceID = resourceID;
        this.permissionCode = permissionCode;
        this.licenseID = licenseID;
        this.versionDetails = null;
        this.readOnly = false;
    }

    public FolderContentDTO(LearningDesign design, Integer permissionCode) {
        this.name = design.getTitle();
        this.description = design.getDescription();
        this.creationDateTime = design.getCreateDateTime();
        this.lastModifiedDateTime = design.getLastModifiedDateTime();
        this.resourceType = DESIGN;
        this.resourceID = design.getLearningDesignId();
        this.permissionCode = permissionCode;
        this.licenseID = design.getLicense() != null ? design.getLicense().getLicenseID() : null;
        this.licenseText = design.getLicenseText();
        this.versionDetails = null;
        this.readOnly = design.getReadOnly();
    }

    public FolderContentDTO(WorkspaceFolder workspaceFolder, Integer permissionCode) {
        this.name = workspaceFolder.getName();
        this.description = FOLDER;
        this.creationDateTime = workspaceFolder.getCreationDate();
        this.lastModifiedDateTime = workspaceFolder.getLastModifiedDate();
        this.resourceType = FOLDER;
        this.resourceID = new Long(workspaceFolder.getWorkspaceFolderId().intValue());
        this.permissionCode = permissionCode;
        this.licenseID = null;
        this.versionDetails = null;
        this.readOnly = Boolean.FALSE;
    }

    public FolderContentDTO(Integer permissionCode, WorkspaceFolderContent workspaceFolderContent, SortedSet details) {
        this.name = workspaceFolderContent.getName();
        this.description = workspaceFolderContent.getDescription();
        this.creationDateTime = workspaceFolderContent.getCreateDate();
        this.lastModifiedDateTime = workspaceFolderContent.getLastModified();
        this.resourceID = workspaceFolderContent.getFolderContentID();
        this.permissionCode = permissionCode;
        this.resourceType = workspaceFolderContent.getContentTypeID().equals(WorkspaceFolderContent.CONTENT_TYPE_FILE) ? FILE : FOLDER;
        this.licenseID = null;
        this.versionDetails = new Vector();
        this.versionDetails.addAll(details);
        this.readOnly = Boolean.FALSE;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime != null ? this.creationDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getDescription() {
        return this.description != null ? this.description : "string_null_value";
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime != null ? this.lastModifiedDateTime : WDDXTAGS.DATE_NULL_VALUE;
    }

    public String getName() {
        return this.name != null ? this.name : "string_null_value";
    }

    public Integer getPermissionCode() {
        return this.permissionCode != null ? this.permissionCode : WDDXTAGS.NUMERIC_NULL_VALUE_INTEGER;
    }

    public Long getResourceID() {
        return this.resourceID != null ? this.resourceID : WDDXTAGS.NUMERIC_NULL_VALUE_LONG;
    }

    public String getResourceType() {
        return this.resourceType != null ? this.resourceType : "string_null_value";
    }

    public Vector getVersionDetails() {
        return this.versionDetails;
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public void setLicenseID(Long licenseID) {
        this.licenseID = licenseID;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }
}

