/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityDTOOrderComparator;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.NullActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.strategy.ComplexActivityStrategy;
import org.lamsfoundation.lams.lesson.LearnerProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComplexActivity
extends Activity
implements Serializable {
    protected ComplexActivityStrategy activityStrategy;
    private Set activities;

    public ComplexActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Set activities) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile);
        this.activities = activities;
    }

    public ComplexActivity() {
    }

    public ComplexActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, Set activities) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom);
        this.activities = activities;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    public Set getActivities() {
        if (this.activities == null) {
            this.setActivities(new TreeSet(new ActivityOrderComparator()));
        }
        return this.activities;
    }

    public void setActivities(Set activities) {
        this.activities = activities;
    }

    public void addActivity(Activity activity) {
        this.getActivities().add(activity);
    }

    public Activity getChildActivityById(long activityId) {
        for (Activity child : this.activities) {
            if (child.getActivityId() != activityId) continue;
            return child;
        }
        return new NullActivity();
    }

    public boolean areChildrenCompleted(LearnerProgress learnerProgress) {
        return this.activityStrategy.areChildrenCompleted(learnerProgress);
    }

    public Activity getNextActivityByParent(Activity currentChild) {
        return this.activityStrategy.getNextActivityByParent(this, currentChild);
    }

    @Override
    protected void getToolActivitiesInActivity(SortedSet toolActivities) {
        for (Activity child : this.getActivities()) {
            child.getToolActivitiesInActivity(toolActivities);
        }
    }

    @Override
    public Set<AuthoringActivityDTO> getAuthoringActivityDTOSet() {
        TreeSet<AuthoringActivityDTO> dtoSet = new TreeSet<AuthoringActivityDTO>(new ActivityDTOOrderComparator());
        dtoSet.add(new AuthoringActivityDTO(this));
        for (Activity child : this.getActivities()) {
            dtoSet.add(new AuthoringActivityDTO(child));
        }
        return dtoSet;
    }
}

