/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.themes.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.themes.dao.ICSSThemeDAO;
import org.lamsfoundation.lams.themes.dto.CSSThemeBriefDTO;
import org.lamsfoundation.lams.themes.dto.CSSThemeDTO;
import org.lamsfoundation.lams.themes.exception.ThemeException;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;

public class ThemeService
implements IThemeService {
    protected Logger log = Logger.getLogger(ThemeService.class);
    protected ICSSThemeDAO themeDAO;
    protected MessageService messageService;
    protected IUserManagementService userManagementService;
    private FlashMessage flashMessage;

    public ICSSThemeDAO getThemeDAO() {
        return this.themeDAO;
    }

    public void setThemeDAO(ICSSThemeDAO themeDAO) {
        this.themeDAO = themeDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public String storeTheme(String wddxPacket) throws Exception {
        Hashtable table = (Hashtable)WDDXProcessor.deserialize(wddxPacket);
        CSSThemeDTO themeDTO = new CSSThemeDTO(table);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Converted Theme packet. Packet was \n" + wddxPacket + "\nDTO is\n" + themeDTO));
        }
        CSSThemeVisualElement dbTheme = null;
        CSSThemeVisualElement storedTheme = null;
        if (themeDTO.getId() != null) {
            dbTheme = this.themeDAO.getThemeById(themeDTO.getId());
        }
        storedTheme = dbTheme == null ? themeDTO.createCSSThemeVisualElement() : themeDTO.updateCSSTheme(dbTheme);
        this.themeDAO.saveOrUpdateTheme(storedTheme);
        this.flashMessage = new FlashMessage("storeTheme", storedTheme.getId());
        return this.flashMessage.serializeMessage();
    }

    public String getTheme(Long themeId) throws IOException {
        CSSThemeVisualElement theme = this.themeDAO.getThemeById(themeId);
        if (theme == null) {
            this.flashMessage = FlashMessage.getNoSuchTheme("wddxPacket", themeId);
        } else {
            CSSThemeDTO dto = new CSSThemeDTO(theme);
            this.flashMessage = new FlashMessage("getTheme", dto);
        }
        return this.flashMessage.serializeMessage();
    }

    public String getThemes() throws IOException {
        List themes = this.themeDAO.getAllThemes();
        ArrayList<CSSThemeBriefDTO> themeList = new ArrayList<CSSThemeBriefDTO>();
        Iterator iterator = themes.iterator();
        while (iterator.hasNext()) {
            CSSThemeBriefDTO dto = new CSSThemeBriefDTO((CSSThemeVisualElement)iterator.next());
            themeList.add(dto);
        }
        this.flashMessage = new FlashMessage("getThemes", themeList);
        return this.flashMessage.serializeMessage();
    }

    private FlashMessage setTheme(Integer userId, Long themeId, String type) throws IOException, ThemeException, UserException {
        User user = (User)this.userManagementService.findById(User.class, userId);
        CSSThemeVisualElement theme = this.themeDAO.getThemeById(themeId);
        if (theme == null) {
            throw new ThemeException(this.messageService.getMessage("theme.service.setTheme.noSuchTheme"));
        }
        if (user == null) {
            throw new UserException(this.messageService.getMessage("theme.service.setTheme.noSuchUser"));
        }
        if (type == null) {
            user.setHtmlTheme(theme);
            user.setFlashTheme(theme);
        } else if (type.equals("flash")) {
            user.setFlashTheme(theme);
        } else if (type.equals("theme.service.setTheme.saved")) {
            user.setHtmlTheme(theme);
        }
        this.userManagementService.save(user);
        this.flashMessage = new FlashMessage("setTheme", this.messageService.getMessage("theme.service.setTheme.saved"));
        return this.flashMessage;
    }

    public FlashMessage setTheme(Integer userId, Long themeId) throws IOException, ThemeException, UserException {
        return this.setTheme(userId, themeId, null);
    }

    public FlashMessage setHtmlTheme(Integer userId, Long themeId) throws IOException, ThemeException, UserException {
        return this.setTheme(userId, themeId, "theme.service.setTheme.saved");
    }

    public FlashMessage setFlashTheme(Integer userId, Long themeId) throws IOException, ThemeException, UserException {
        return this.setTheme(userId, themeId, "flash");
    }
}

