/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.authoring.IObjectExtractor;
import org.lamsfoundation.lams.authoring.ObjectExtractorException;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.BranchingActivity;
import org.lamsfoundation.lams.learningdesign.ChosenGrouping;
import org.lamsfoundation.lams.learningdesign.Competence;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.ConditionGateActivity;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningDesignAnnotation;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.OptionsWithSequencesActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.PermissionGateActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ScheduleGateActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.SynchGateActivity;
import org.lamsfoundation.lams.learningdesign.SystemGateActivity;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.IBranchActivityEntryDAO;
import org.lamsfoundation.lams.learningdesign.dao.ICompetenceDAO;
import org.lamsfoundation.lams.learningdesign.dao.ICompetenceMappingDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupDAO;
import org.lamsfoundation.lams.learningdesign.dao.IGroupingDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILicenseDAO;
import org.lamsfoundation.lams.learningdesign.dao.ITransitionDAO;
import org.lamsfoundation.lams.lesson.LessonClass;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.JsonUtil;

public class ObjectExtractor
implements IObjectExtractor {
    public static final Integer DEFAULT_COORD = new Integer(10);
    protected IBaseDAO baseDAO = null;
    protected ILearningDesignDAO learningDesignDAO = null;
    protected IActivityDAO activityDAO = null;
    protected ICompetenceDAO competenceDAO = null;
    protected ICompetenceMappingDAO competenceMappingDAO = null;
    protected ITransitionDAO transitionDAO = null;
    protected ILearningLibraryDAO learningLibraryDAO = null;
    protected ILicenseDAO licenseDAO = null;
    protected IGroupingDAO groupingDAO = null;
    protected IToolDAO toolDAO = null;
    protected ISystemToolDAO systemToolDAO = null;
    protected IGroupDAO groupDAO = null;
    protected IToolSessionDAO toolSessionDAO = null;
    protected IBranchActivityEntryDAO branchActivityEntryDAO = null;
    protected ILamsCoreToolService lamsCoreToolService = null;
    private Integer mode = null;
    protected HashMap<Integer, Activity> newActivityMap = new HashMap();
    protected HashMap<Integer, List<ToolSession>> toolSessionMap = new HashMap();
    protected List<BranchActivityEntry> oldbranchActivityEntryList = new ArrayList<BranchActivityEntry>();
    protected HashMap<Integer, Activity> oldActivityMap = new HashMap();
    protected HashMap<Integer, Grouping> groupings = new HashMap();
    protected HashMap<Integer, Group> groups = new HashMap();
    protected HashMap<Integer, BranchActivityEntry> branchEntries = new HashMap();
    protected HashMap<Integer, ComplexActivity> defaultActivityMap = new HashMap();
    protected HashMap<Integer, Grouping> groupingsToDelete = new HashMap();
    protected LearningDesign learningDesign = null;
    protected Date modificationDate = null;
    protected HashMap<Long, SystemTool> systemTools = new HashMap();
    protected Logger log = Logger.getLogger(ObjectExtractor.class);

    public ObjectExtractor() {
        this.modificationDate = new Date();
    }

    public IActivityDAO getActivityDAO() {
        return this.activityDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public ICompetenceDAO getCompetenceDAO() {
        return this.competenceDAO;
    }

    public void setCompetenceDAO(ICompetenceDAO competenceDAO) {
        this.competenceDAO = competenceDAO;
    }

    public ICompetenceMappingDAO getCompetenceMappingDAO() {
        return this.competenceMappingDAO;
    }

    public void setCompetenceMappingDAO(ICompetenceMappingDAO competenceMappingDAO) {
        this.competenceMappingDAO = competenceMappingDAO;
    }

    public IGroupDAO getGroupDAO() {
        return this.groupDAO;
    }

    public void setGroupDAO(IGroupDAO groupDAO) {
        this.groupDAO = groupDAO;
    }

    public IGroupingDAO getGroupingDAO() {
        return this.groupingDAO;
    }

    public void setGroupingDAO(IGroupingDAO groupingDAO) {
        this.groupingDAO = groupingDAO;
    }

    public ILearningDesignDAO getLearningDesignDAO() {
        return this.learningDesignDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    public ILearningLibraryDAO getLearningLibraryDAO() {
        return this.learningLibraryDAO;
    }

    public void setLearningLibraryDAO(ILearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public ILicenseDAO getLicenseDAO() {
        return this.licenseDAO;
    }

    public void setLicenseDAO(ILicenseDAO licenseDAO) {
        this.licenseDAO = licenseDAO;
    }

    public IToolSessionDAO getToolSessionDAODAO() {
        return this.toolSessionDAO;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public HashMap<Integer, Activity> getNewActivityMap() {
        return this.newActivityMap;
    }

    public void setNewActivityMap(HashMap<Integer, Activity> newActivityMap) {
        this.newActivityMap = newActivityMap;
    }

    public IToolDAO getToolDAO() {
        return this.toolDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public ISystemToolDAO getSystemToolDAO() {
        return this.systemToolDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public ITransitionDAO getTransitionDAO() {
        return this.transitionDAO;
    }

    public void setTransitionDAO(ITransitionDAO transitionDAO) {
        this.transitionDAO = transitionDAO;
    }

    public IBaseDAO getBaseDAO() {
        return this.baseDAO;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public IBranchActivityEntryDAO getBranchActivityEntryDAO() {
        return this.branchActivityEntryDAO;
    }

    public void setBranchActivityEntryDAO(IBranchActivityEntryDAO branchActivityEntryDAO) {
        this.branchActivityEntryDAO = branchActivityEntryDAO;
    }

    public ILamsCoreToolService getLamsCoreToolService() {
        return this.lamsCoreToolService;
    }

    public void setLamsCoreToolService(ILamsCoreToolService lamsCoreToolService) {
        this.lamsCoreToolService = lamsCoreToolService;
    }

    @Override
    public LearningDesign extractSaveLearningDesign(JSONObject ldJSON, LearningDesign existingLearningDesign, WorkspaceFolder workspaceFolder, User user) throws ObjectExtractorException, ParseException, JSONException {
        this.learningDesign = existingLearningDesign != null ? existingLearningDesign : new LearningDesign();
        Integer copyTypeID = (Integer)JsonUtil.opt((JSONObject)ldJSON, (String)"copyTypeID");
        if (copyTypeID == null) {
            copyTypeID = 1;
        }
        if (this.learningDesign != null && this.learningDesign.getCopyTypeID() != null && !this.learningDesign.getCopyTypeID().equals(copyTypeID) && !this.learningDesign.getEditOverrideLock().booleanValue()) {
            throw new ObjectExtractorException("Unable to save learning design.  Cannot change copy type on existing design.");
        }
        if (!copyTypeID.equals(1) && !this.learningDesign.getEditOverrideLock().booleanValue()) {
            throw new ObjectExtractorException("Unable to save learning design.  Learning design is read-only");
        }
        this.learningDesign.setCopyTypeID(copyTypeID);
        this.learningDesign.setWorkspaceFolder(workspaceFolder);
        this.learningDesign.setUser(user);
        String contentFolderID = (String)JsonUtil.opt((JSONObject)ldJSON, (String)"contentFolderID");
        if (contentFolderID == null) {
            contentFolderID = FileUtil.generateUniqueContentFolderID();
            ldJSON.put("contentFolderID", (Object)contentFolderID);
        }
        this.learningDesign.setContentFolderID(contentFolderID);
        if (existingLearningDesign == null) {
            Integer originalUserID = (Integer)JsonUtil.opt((JSONObject)ldJSON, (String)"originalUserID");
            if (originalUserID == null) {
                this.learningDesign.setOriginalUser(user);
            } else {
                User originalUser = (User)this.getBaseDAO().find(User.class, (Serializable)originalUserID);
                this.learningDesign.setOriginalUser(originalUser);
            }
        } else {
            this.learningDesign.setOriginalUser(existingLearningDesign.getOriginalUser());
        }
        this.initialiseGroupings();
        this.intialiseBranchActivityMappings();
        this.initialiseToolSessionMap(this.learningDesign);
        this.learningDesign.setValidDesign((Boolean)JsonUtil.opt((JSONObject)ldJSON, (String)"validDesign", (Object)false));
        this.learningDesign.setLearningDesignUIID((Integer)JsonUtil.opt((JSONObject)ldJSON, (String)"learningDesignUIID"));
        this.learningDesign.setDescription((String)JsonUtil.opt((JSONObject)ldJSON, (String)"description"));
        this.learningDesign.setTitle((String)JsonUtil.opt((JSONObject)ldJSON, (String)"title"));
        this.learningDesign.setMaxID((Integer)JsonUtil.opt((JSONObject)ldJSON, (String)"maxID"));
        this.learningDesign.setReadOnly((Boolean)JsonUtil.opt((JSONObject)ldJSON, (String)"readOnly"));
        this.learningDesign.setEditOverrideLock((Boolean)JsonUtil.opt((JSONObject)ldJSON, (String)"editOverrideLock"));
        this.learningDesign.setDateReadOnly(DateUtil.convertFromString((String)((String)JsonUtil.opt((JSONObject)ldJSON, (String)"dateReadOnly"))));
        this.learningDesign.setHelpText((String)JsonUtil.opt((JSONObject)ldJSON, (String)"helpText"));
        String version = (String)JsonUtil.opt((JSONObject)ldJSON, (String)"version");
        if (version == null) {
            version = Configuration.get((String)ConfigurationKeys.SERVER_VERSION_NUMBER);
        }
        this.learningDesign.setDesignType((String)JsonUtil.opt((JSONObject)ldJSON, (String)"designType"));
        this.learningDesign.setVersion(version);
        this.learningDesign.setDuration(JsonUtil.optLong((JSONObject)ldJSON, (String)"duration"));
        this.mode = (Integer)JsonUtil.opt((JSONObject)ldJSON, (String)"saveMode");
        if (this.learningDesign.getCreateDateTime() == null) {
            this.learningDesign.setCreateDateTime(this.modificationDate);
        }
        this.learningDesign.setLastModifiedDateTime(this.modificationDate);
        Long licenseID = JsonUtil.optLong((JSONObject)ldJSON, (String)"licenseID");
        if (licenseID != null) {
            License license = this.licenseDAO.getLicenseByID(licenseID);
            this.learningDesign.setLicense(license);
        }
        this.learningDesign.setLicenseText((String)JsonUtil.opt((JSONObject)ldJSON, (String)"licenseText"));
        Long originalLearningDesignID = JsonUtil.optLong((JSONObject)ldJSON, (String)"originalLearningDesignID");
        if (originalLearningDesignID != null) {
            LearningDesign originalLearningDesign = this.learningDesignDAO.getLearningDesignById(originalLearningDesignID);
            this.learningDesign.setOriginalLearningDesign(originalLearningDesign);
        }
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
        this.parseGroupings((JSONArray)JsonUtil.opt((JSONObject)ldJSON, (String)"groupings"));
        this.parseActivities((JSONArray)JsonUtil.opt((JSONObject)ldJSON, (String)"activities"));
        this.parseActivitiesToMatchUpParentandInputActivities((JSONArray)JsonUtil.opt((JSONObject)ldJSON, (String)"activities"));
        this.parseTransitions((JSONArray)JsonUtil.opt((JSONObject)ldJSON, (String)"transitions"));
        this.parseBranchMappings((JSONArray)JsonUtil.opt((JSONObject)ldJSON, (String)"branchMappings"));
        this.parseAnnotations((JSONArray)JsonUtil.opt((JSONObject)ldJSON, (String)"annotations"));
        this.progressDefaultChildActivities();
        this.learningDesign.setFirstActivity(this.learningDesign.calculateFirstActivity());
        this.learningDesign.setFloatingActivity(this.learningDesign.calculateFloatingActivity());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
        this.deleteUnwantedGroupings();
        this.deleteUnwantedToolSessions(this.learningDesign);
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
        return this.learningDesign;
    }

    private void progressDefaultChildActivities() throws ObjectExtractorException {
        if (this.defaultActivityMap.size() > 0) {
            for (Integer defaultChildUIID : this.defaultActivityMap.keySet()) {
                Activity nextActivity2;
                ComplexActivity complex = this.defaultActivityMap.get(defaultChildUIID);
                Activity defaultActivity = this.newActivityMap.get(defaultChildUIID);
                if (defaultActivity == null) {
                    String msg = "Unable to find the default child activity (" + defaultChildUIID + ") for the activity (" + complex + ") referred to in First Child to Sequence map.";
                    throw new ObjectExtractorException(msg);
                }
                complex.setDefaultActivity(defaultActivity);
                if (!complex.isSequenceActivity()) continue;
                TreeSet unprocessedChildren = new TreeSet(new ActivityOrderComparator());
                unprocessedChildren.addAll(complex.getActivities());
                unprocessedChildren.remove(defaultActivity);
                defaultActivity.setOrderId(Integer.valueOf(1));
                int nextOrderId = 2;
                Activity activity = nextActivity2 = defaultActivity.getTransitionFrom() != null ? defaultActivity.getTransitionFrom().getToActivity() : null;
                while (nextActivity2 != null) {
                    boolean removed = unprocessedChildren.remove(nextActivity2);
                    if (!removed) {
                        this.log.error((Object)("Next activity should be a child of the current sequence, but it isn't. Could we have a loop in the transitions? Aborting the ordering of ids based on transitions. Sequence activity " + complex + " next activity " + nextActivity2));
                        break;
                    }
                    nextActivity2.setOrderId(Integer.valueOf(nextOrderId++));
                    nextActivity2 = nextActivity2.getTransitionFrom() != null ? nextActivity2.getTransitionFrom().getToActivity() : null;
                }
                if (unprocessedChildren.size() <= 0) continue;
                for (Activity nextActivity2 : unprocessedChildren) {
                    nextActivity2.setOrderId(Integer.valueOf(nextOrderId++));
                }
            }
        }
    }

    private void initialiseGroupings() {
        List dbGroupings = this.groupingDAO.getGroupingsByLearningDesign(this.learningDesign.getLearningDesignId());
        for (Grouping grouping : dbGroupings) {
            this.groupings.put(grouping.getGroupingUIID(), grouping);
            this.groupingsToDelete.put(grouping.getGroupingUIID(), grouping);
        }
    }

    private void intialiseBranchActivityMappings() {
        this.oldbranchActivityEntryList = this.branchActivityEntryDAO.getEntriesByLearningDesign(this.learningDesign.getLearningDesignId());
    }

    private void initialiseToolSessionMap(LearningDesign learningDesign) {
        if (learningDesign.getEditOverrideLock().booleanValue() && learningDesign.getEditOverrideUser() != null) {
            for (Activity activity : learningDesign.getActivities()) {
                this.oldActivityMap.put(activity.getActivityUIID(), activity);
                List toolSessions = this.toolSessionDAO.getToolSessionByActivity(activity);
                if (toolSessions == null || toolSessions.size() <= 0) continue;
                this.toolSessionMap.put(activity.getActivityUIID(), toolSessions);
            }
        }
    }

    private void deleteUnwantedGroupings() {
        for (Grouping grouping : this.groupingsToDelete.values()) {
            this.groupingDAO.delete((Object)grouping);
        }
    }

    private void deleteUnwantedToolSessions(LearningDesign learningDesign) throws ObjectExtractorException {
        if (learningDesign.getEditOverrideLock().booleanValue() && learningDesign.getEditOverrideUser() != null) {
            for (Integer uiid : this.toolSessionMap.keySet()) {
                List<ToolSession> toolSessions;
                if (this.newActivityMap.containsKey(uiid) || (toolSessions = this.toolSessionMap.get(uiid)) == null) continue;
                Activity activity = this.oldActivityMap.get(uiid);
                if (toolSessions.size() > 1) {
                    throw new ObjectExtractorException("More than one tool session exists for activity " + activity.getTitle() + " (" + uiid + ") but this shouldn't be possible. Cannot delete this tool session so editing is not allowed!");
                }
                if (toolSessions.size() != 1) continue;
                ToolSession toolSession = toolSessions.get(0);
                if (activity.isGroupingActivity()) {
                    throw new ObjectExtractorException("Activity " + activity.getTitle() + " (" + activity.getActivityUIID() + ") has a tool session but it is grouped. Cannot delete this tool session so editing is not allowed!");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Removing tool session for activity " + activity.getTitle() + " (" + activity.getActivityUIID() + ")"));
                }
                this.toolSessionDAO.removeToolSession(toolSession);
            }
        }
    }

    private void parseGroupings(JSONArray groupingsList) throws JSONException {
        if (groupingsList != null) {
            for (int groupingIndex = 0; groupingIndex < groupingsList.length(); ++groupingIndex) {
                JSONObject groupingDetails = groupingsList.getJSONObject(groupingIndex);
                if (groupingDetails == null) continue;
                Grouping grouping = this.extractGroupingObject(groupingDetails);
                this.groupingDAO.insertOrUpdate((Object)grouping);
                this.groupings.put(grouping.getGroupingUIID(), grouping);
            }
        }
    }

    public Grouping extractGroupingObject(JSONObject groupingDetails) throws JSONException {
        Integer groupingUIID = (Integer)JsonUtil.opt((JSONObject)groupingDetails, (String)"groupingUIID");
        Integer groupingTypeID = (Integer)JsonUtil.opt((JSONObject)groupingDetails, (String)"groupingTypeID");
        Grouping grouping = this.groupings.get(groupingUIID);
        if (grouping != null) {
            if (grouping.getGroupingTypeId().equals(groupingTypeID)) {
                this.groupingsToDelete.remove(groupingUIID);
            } else {
                this.groupings.remove(grouping.getGroupingUIID());
                grouping = null;
            }
        }
        if (grouping == null) {
            Object object = Grouping.getGroupingInstance((Integer)groupingTypeID);
            grouping = (Grouping)object;
            grouping.setGroupingUIID(groupingUIID);
        }
        if (grouping.isRandomGrouping()) {
            this.createRandomGrouping((RandomGrouping)grouping, groupingDetails);
        } else if (grouping.isChosenGrouping()) {
            this.createChosenGrouping((ChosenGrouping)grouping, groupingDetails);
        } else if (grouping.isLearnerChoiceGrouping()) {
            this.createLearnerChoiceGrouping((LearnerChoiceGrouping)grouping, groupingDetails);
        } else {
            this.createLessonClass((LessonClass)grouping, groupingDetails);
        }
        grouping.setMaxNumberOfGroups((Integer)JsonUtil.opt((JSONObject)groupingDetails, (String)"maxNumberOfGroups"));
        HashSet groupsToDelete = new HashSet(grouping.getGroups());
        JSONArray groupsList = (JSONArray)JsonUtil.opt((JSONObject)groupingDetails, (String)"groups");
        if (groupsList != null) {
            for (int groupIndex = 0; groupIndex < groupsList.length(); ++groupIndex) {
                JSONObject groupDetails = groupsList.getJSONObject(groupIndex);
                Group group = this.extractGroupObject(groupDetails, grouping);
                this.groups.put(group.getGroupUIID(), group);
                groupsToDelete.remove(group);
            }
        }
        if (groupsToDelete.size() > 0) {
            for (Group group : groupsToDelete) {
                if (group.getBranchActivities() != null) {
                    for (BranchActivityEntry entry : group.getBranchActivities()) {
                        entry.setGroup(null);
                    }
                    group.getBranchActivities().clear();
                }
                grouping.getGroups().remove(group);
            }
        }
        return grouping;
    }

    private Group extractGroupObject(JSONObject groupDetails, Grouping grouping) throws JSONException {
        Group group = null;
        Integer groupUIID = groupDetails.getInt("groupUIID");
        Long groupID = JsonUtil.optLong((JSONObject)groupDetails, (String)"groupID");
        if (grouping.getGroups() != null && grouping.getGroups().size() > 0) {
            Group uiid_match = null;
            Group id_match = null;
            Iterator iter = grouping.getGroups().iterator();
            while (uiid_match == null && iter.hasNext()) {
                Group possibleGroup = (Group)iter.next();
                if (groupUIID.equals(possibleGroup.getGroupUIID())) {
                    uiid_match = possibleGroup;
                }
                if (groupID == null || !groupID.equals(possibleGroup.getGroupId())) continue;
                id_match = possibleGroup;
            }
            Group group2 = group = uiid_match != null ? uiid_match : id_match;
        }
        if (group == null) {
            group = new Group();
            grouping.getGroups().add(group);
        }
        group.setGroupName((String)JsonUtil.opt((JSONObject)groupDetails, (String)"groupName"));
        group.setGrouping(grouping);
        group.setGroupUIID(groupUIID);
        group.setOrderId(((Integer)JsonUtil.opt((JSONObject)groupDetails, (String)"orderID", (Object)0)).intValue());
        return group;
    }

    private void createRandomGrouping(RandomGrouping randomGrouping, JSONObject groupingDetails) throws JSONException {
        Integer numLearnersPerGroup = (Integer)JsonUtil.opt((JSONObject)groupingDetails, (String)"learnersPerGroup");
        if (numLearnersPerGroup != null && numLearnersPerGroup > 0) {
            randomGrouping.setLearnersPerGroup(numLearnersPerGroup);
            randomGrouping.setNumberOfGroups(null);
        } else {
            Integer numGroups = (Integer)JsonUtil.opt((JSONObject)groupingDetails, (String)"numberOfGroups");
            if (numGroups != null && numGroups > 0) {
                randomGrouping.setNumberOfGroups(numGroups);
            } else {
                randomGrouping.setNumberOfGroups(null);
            }
            randomGrouping.setLearnersPerGroup(null);
        }
    }

    private void createChosenGrouping(ChosenGrouping chosenGrouping, JSONObject groupingDetails) {
    }

    private void parseActivities(JSONArray activitiesList) throws ObjectExtractorException, JSONException {
        if (activitiesList != null) {
            for (int activityIndex = 0; activityIndex < activitiesList.length(); ++activityIndex) {
                JSONObject activityDetails = activitiesList.getJSONObject(activityIndex);
                Activity activity = this.extractActivityObject(activityDetails);
                this.activityDAO.insertOrUpdate((Object)activity);
                if (activity.isToolActivity()) {
                    this.extractEvaluationObject(activityDetails, (ToolActivity)activity);
                }
                this.newActivityMap.put(activity.getActivityUIID(), activity);
            }
        }
        this.learningDesign.getActivities().clear();
        this.learningDesign.getActivities().addAll(this.newActivityMap.values());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
    }

    private void extractEvaluationObject(JSONObject activityDetails, ToolActivity toolActivity) throws ObjectExtractorException, JSONException {
        HashSet<ActivityEvaluation> activityEvaluations = toolActivity.getActivityEvaluations();
        ActivityEvaluation activityEvaluation = activityEvaluations != null && activityEvaluations.size() >= 1 ? (ActivityEvaluation)activityEvaluations.iterator().next() : new ActivityEvaluation();
        String toolOutputDefinition = (String)JsonUtil.opt((JSONObject)activityDetails, (String)"gradebookToolOutputDefinitionName");
        if (!StringUtils.isBlank((String)toolOutputDefinition)) {
            activityEvaluations = new HashSet<ActivityEvaluation>();
            activityEvaluation.setActivity((Activity)toolActivity);
            activityEvaluation.setToolOutputDefinition(toolOutputDefinition);
            activityEvaluations.add(activityEvaluation);
            toolActivity.setActivityEvaluations(activityEvaluations);
            this.baseDAO.insertOrUpdate((Object)activityEvaluation);
            toolActivity.setActivityEvaluations(activityEvaluations);
            this.activityDAO.insertOrUpdate((Object)toolActivity);
        } else if (activityEvaluation.getUid() != null) {
            toolActivity.setActivityEvaluations(new HashSet());
            this.activityDAO.insertOrUpdate((Object)toolActivity);
            this.baseDAO.delete((Object)activityEvaluation);
        }
    }

    private void parseCompetences(JSONArray competenceList) throws ObjectExtractorException, JSONException {
        Set existingCompetences = this.learningDesign.getCompetences();
        if (competenceList != null) {
            for (int competenceIndex = 0; competenceIndex < competenceList.length(); ++competenceIndex) {
                JSONObject competeneJSON = competenceList.getJSONObject(competenceIndex);
                String title = competeneJSON.getString("title");
                String description = competeneJSON.getString("description");
                if (this.getComptenceFromSet(existingCompetences, title) != null) {
                    Competence updateCompetence = this.getComptenceFromSet(existingCompetences, title);
                    updateCompetence.setDescription(description);
                    this.competenceDAO.saveOrUpdate(updateCompetence);
                    continue;
                }
                Competence newCompetence = new Competence();
                newCompetence.setTitle(title);
                newCompetence.setDescription(description);
                newCompetence.setLearningDesign(this.learningDesign);
                this.competenceDAO.saveOrUpdate(newCompetence);
            }
            HashSet<Competence> removeCompetences = new HashSet<Competence>();
            if (existingCompetences != null) {
                if (competenceList != null && competenceList.length() > 0) {
                    for (Competence existingCompetence : existingCompetences) {
                        boolean remove = true;
                        for (int competenceIndex = 0; competenceIndex < competenceList.length(); ++competenceIndex) {
                            if (!existingCompetence.getTitle().equals(competenceList.getJSONObject(competenceIndex).getString("title"))) continue;
                            remove = false;
                            break;
                        }
                        if (!remove) continue;
                        removeCompetences.add(existingCompetence);
                    }
                } else {
                    removeCompetences.addAll(existingCompetences);
                }
                this.learningDesign.getCompetences().removeAll(removeCompetences);
            }
        }
    }

    private void parseAnnotations(JSONArray annotationList) throws ObjectExtractorException, JSONException {
        if (annotationList == null) {
            return;
        }
        HashSet existingAnnotations = this.learningDesign.getAnnotations();
        if (existingAnnotations == null) {
            existingAnnotations = new HashSet();
            this.learningDesign.setAnnotations(existingAnnotations);
        }
        HashSet<LearningDesignAnnotation> updatedAnnotations = new HashSet<LearningDesignAnnotation>();
        for (int annotationIndex = 0; annotationIndex < annotationList.length(); ++annotationIndex) {
            JSONObject annotationJSON = annotationList.getJSONObject(annotationIndex);
            boolean found = false;
            LearningDesignAnnotation annotation = null;
            for (LearningDesignAnnotation existingAnnotation : existingAnnotations) {
                if (!existingAnnotation.getAnnotationUIID().equals(annotationJSON.getInt("annotationUIID"))) continue;
                annotation = existingAnnotation;
                found = true;
                break;
            }
            if (annotation == null) {
                annotation = new LearningDesignAnnotation();
            }
            annotation.setLearningDesignId(this.learningDesign.getLearningDesignId());
            annotation.setAnnotationUIID(Integer.valueOf(annotationJSON.getInt("annotationUIID")));
            annotation.setTitle((String)JsonUtil.opt((JSONObject)annotationJSON, (String)"title"));
            annotation.setXcoord((Integer)JsonUtil.opt((JSONObject)annotationJSON, (String)"xCoord"));
            annotation.setYcoord((Integer)JsonUtil.opt((JSONObject)annotationJSON, (String)"yCoord"));
            annotation.setEndXcoord((Integer)JsonUtil.opt((JSONObject)annotationJSON, (String)"endXCoord"));
            annotation.setEndYcoord((Integer)JsonUtil.opt((JSONObject)annotationJSON, (String)"endYCoord"));
            annotation.setColor((String)JsonUtil.opt((JSONObject)annotationJSON, (String)"color"));
            if (found) {
                this.baseDAO.update((Object)annotation);
            } else {
                this.baseDAO.insert((Object)annotation);
            }
            updatedAnnotations.add(annotation);
        }
        this.learningDesign.getAnnotations().clear();
        this.learningDesign.getAnnotations().addAll(updatedAnnotations);
    }

    private Competence getComptenceFromSet(Set<Competence> competences, String title) {
        if (competences != null) {
            for (Competence competence : competences) {
                if (!competence.getTitle().equals(title)) continue;
                return competence;
            }
        }
        return null;
    }

    private void parseActivitiesToMatchUpParentandInputActivities(JSONArray activitiesList) throws ObjectExtractorException, JSONException {
        if (activitiesList != null) {
            for (int activityIndex = 0; activityIndex < activitiesList.length(); ++activityIndex) {
                JSONObject activityDetails = activitiesList.getJSONObject(activityIndex);
                Integer activityUUID = activityDetails.getInt("activityUIID");
                Activity existingActivity = this.newActivityMap.get(activityUUID);
                Integer parentUIID = (Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"parentUIID");
                if (parentUIID != null) {
                    Activity parentActivity = this.newActivityMap.get(parentUIID);
                    if (parentActivity == null) {
                        throw new ObjectExtractorException("Parent activity " + parentUIID + " missing for activity " + existingActivity.getTitle() + ": " + existingActivity.getActivityUIID());
                    }
                    existingActivity.setParentActivity(parentActivity);
                    existingActivity.setParentUIID(parentUIID);
                    if (parentActivity.isComplexActivity()) {
                        ((ComplexActivity)parentActivity).addActivity(existingActivity);
                        this.activityDAO.update((Object)parentActivity);
                    }
                } else {
                    existingActivity.setParentActivity(null);
                    existingActivity.setParentUIID(null);
                    existingActivity.setOrderId(null);
                }
                existingActivity.getInputActivities().clear();
                Integer inputActivityUIID = (Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"toolActivityUIID");
                if (inputActivityUIID != null) {
                    Activity inputActivity = this.newActivityMap.get(inputActivityUIID);
                    if (inputActivity == null) {
                        throw new ObjectExtractorException("Input activity " + inputActivityUIID + " missing for activity " + existingActivity.getTitle() + ": " + existingActivity.getActivityUIID());
                    }
                    existingActivity.getInputActivities().add(inputActivity);
                }
                this.activityDAO.update((Object)existingActivity);
            }
        }
    }

    private void parseTransitions(JSONArray transitionsList) throws JSONException {
        HashMap<Integer, Transition> newMap = new HashMap<Integer, Transition>();
        if (transitionsList != null) {
            for (int transitionIndex = 0; transitionIndex < transitionsList.length(); ++transitionIndex) {
                JSONObject transitionDetails = transitionsList.getJSONObject(transitionIndex);
                Transition transition = this.extractTransitionObject(transitionDetails);
                if (transition == null) continue;
                this.transitionDAO.insertOrUpdate((Object)transition);
                newMap.put(transition.getTransitionUIID(), transition);
            }
        }
        for (Transition element : this.learningDesign.getTransitions()) {
            Integer uiID = element.getTransitionUIID();
            Transition match = (Transition)newMap.get(uiID);
            if (match != null) continue;
            this.cleanupTransition(element);
        }
        this.learningDesign.getTransitions().clear();
        this.learningDesign.getTransitions().addAll(newMap.values());
        this.learningDesignDAO.insertOrUpdate((Object)this.learningDesign);
    }

    public Activity extractActivityObject(JSONObject activityDetails) throws ObjectExtractorException, JSONException {
        Integer activityUIID = (Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"activityUIID");
        Integer activityTypeID = (Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"activityTypeID");
        Activity activity = null;
        Activity existingActivity = this.activityDAO.getActivityByUIID(activityUIID, this.learningDesign);
        if (existingActivity != null && !existingActivity.getActivityTypeId().equals(activityTypeID)) {
            existingActivity = null;
        }
        activity = existingActivity != null ? existingActivity : Activity.getActivityInstance((int)activityTypeID);
        this.processActivityType(activity, activityDetails);
        activity.setActivityTypeId(activityTypeID);
        activity.setActivityUIID(activityUIID);
        activity.setDescription((String)JsonUtil.opt((JSONObject)activityDetails, (String)"description"));
        activity.setTitle((String)JsonUtil.opt((JSONObject)activityDetails, (String)"activityTitle"));
        activity.setHelpText((String)JsonUtil.opt((JSONObject)activityDetails, (String)"helpText"));
        activity.setXcoord(this.getCoord(activityDetails, "xCoord"));
        activity.setYcoord(this.getCoord(activityDetails, "yCoord"));
        Integer groupingUIID = (Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"groupingUIID");
        if (groupingUIID == null) {
            this.clearGrouping(activity);
        } else {
            Grouping grouping = this.groupings.get(groupingUIID);
            if (grouping != null) {
                this.setGrouping(activity, grouping, groupingUIID);
            } else {
                this.log.warn((Object)("Unable to find matching grouping for groupingUIID " + groupingUIID + ". Activity UUID " + activityUIID + " will not be grouped."));
                this.clearGrouping(activity);
            }
        }
        activity.setOrderId((Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"orderID"));
        activity.setLearningDesign(this.learningDesign);
        Long learningLibraryID = JsonUtil.optLong((JSONObject)activityDetails, (String)"learningLibraryID");
        if (learningLibraryID != null) {
            LearningLibrary library = this.learningLibraryDAO.getLearningLibraryById(learningLibraryID);
            activity.setLearningLibrary(library);
        }
        if (activity.getCreateDateTime() == null) {
            activity.setCreateDateTime(this.modificationDate);
        }
        activity.setActivityCategoryID((Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"activityCategoryID"));
        activity.setLibraryActivityUiImage((String)JsonUtil.opt((JSONObject)activityDetails, (String)"libraryActivityUIImage"));
        activity.setGroupingSupportType((Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"groupingSupportType"));
        activity.setStopAfterActivity((Boolean)JsonUtil.opt((JSONObject)activityDetails, (String)"stopAfterActivity", (Object)false));
        return activity;
    }

    private Integer getCoord(JSONObject details, String tag) throws JSONException {
        Number number = (Number)JsonUtil.opt((JSONObject)details, (String)tag);
        Integer coord = number == null ? null : Integer.valueOf(number.intValue());
        return coord == null || coord >= 0 ? coord : DEFAULT_COORD;
    }

    private void clearGrouping(Activity activity) {
        activity.setGrouping(null);
        activity.setGroupingUIID(null);
        activity.setApplyGrouping(Boolean.valueOf(false));
    }

    private void setGrouping(Activity activity, Grouping grouping, Integer groupingUIID) {
        activity.setGrouping(grouping);
        activity.setGroupingUIID(groupingUIID);
        activity.setApplyGrouping(Boolean.valueOf(true));
    }

    private void processActivityType(Activity activity, JSONObject activityDetails) throws ObjectExtractorException, JSONException {
        if (activity.isGroupingActivity()) {
            this.buildGroupingActivity((GroupingActivity)activity, activityDetails);
        } else if (activity.isToolActivity()) {
            this.buildToolActivity((ToolActivity)activity, activityDetails);
        } else if (activity.isGateActivity()) {
            this.buildGateActivity(activity, activityDetails);
        } else {
            this.buildComplexActivity((ComplexActivity)activity, activityDetails);
        }
    }

    private void buildComplexActivity(ComplexActivity activity, JSONObject activityDetails) throws ObjectExtractorException, JSONException {
        activity.getActivities().clear();
        activity.setDefaultActivity(null);
        Integer defaultActivityMapUIID = (Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"defaultActivityUIID");
        if (defaultActivityMapUIID != null) {
            this.defaultActivityMap.put(defaultActivityMapUIID, activity);
        }
        if (activity instanceof OptionsWithSequencesActivity) {
            this.buildOptionsWithSequencesActivity((OptionsWithSequencesActivity)activity, activityDetails);
        } else if (activity instanceof OptionsActivity) {
            this.buildOptionsActivity((OptionsActivity)activity, activityDetails);
        } else if (activity instanceof ParallelActivity) {
            this.buildParallelActivity((ParallelActivity)activity);
        } else if (activity instanceof BranchingActivity) {
            this.buildBranchingActivity((BranchingActivity)activity, activityDetails);
        } else if (activity instanceof FloatingActivity) {
            this.buildFloatingActivity((FloatingActivity)activity, activityDetails);
        } else {
            this.buildSequenceActivity((SequenceActivity)activity);
        }
    }

    private void buildFloatingActivity(FloatingActivity floatingActivity, JSONObject activityDetails) throws ObjectExtractorException, JSONException {
        floatingActivity.setMaxNumberOfActivities((Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"maxActivities"));
        SystemTool systemTool = this.getSystemTool(SystemTool.FLOATING_ACTIVITIES);
        floatingActivity.setSystemTool(systemTool);
    }

    private void buildBranchingActivity(BranchingActivity branchingActivity, JSONObject activityDetails) throws ObjectExtractorException, JSONException {
        if (branchingActivity.isChosenBranchingActivity()) {
            branchingActivity.setSystemTool(this.getSystemTool(SystemTool.TEACHER_CHOSEN_BRANCHING));
        } else if (branchingActivity.isGroupBranchingActivity()) {
            branchingActivity.setSystemTool(this.getSystemTool(SystemTool.GROUP_BASED_BRANCHING));
        } else if (branchingActivity.isToolBranchingActivity()) {
            branchingActivity.setSystemTool(this.getSystemTool(SystemTool.TOOL_BASED_BRANCHING));
        }
        branchingActivity.setStartXcoord(this.getCoord(activityDetails, "startXCoord"));
        branchingActivity.setStartYcoord(this.getCoord(activityDetails, "startYCoord"));
        branchingActivity.setEndXcoord(this.getCoord(activityDetails, "endXCoord"));
        branchingActivity.setEndYcoord(this.getCoord(activityDetails, "endYCoord"));
    }

    private void buildGroupingActivity(GroupingActivity groupingActivity, JSONObject activityDetails) throws ObjectExtractorException, JSONException {
        Integer createGroupingUIID = (Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"createGroupingUIID");
        Grouping grouping = this.groupings.get(createGroupingUIID);
        if (grouping != null) {
            groupingActivity.setCreateGrouping(grouping);
            groupingActivity.setCreateGroupingUIID(createGroupingUIID);
        }
        SystemTool systemTool = this.getSystemTool(SystemTool.GROUPING);
        groupingActivity.setSystemTool(systemTool);
    }

    private void buildOptionsActivity(OptionsActivity optionsActivity, JSONObject activityDetails) throws JSONException {
        optionsActivity.setMaxNumberOfOptions((Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"maxOptions"));
        optionsActivity.setMinNumberOfOptions((Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"minOptions"));
        optionsActivity.setOptionsInstructions((String)JsonUtil.opt((JSONObject)activityDetails, (String)"optionsInstructions"));
    }

    private void buildOptionsWithSequencesActivity(OptionsWithSequencesActivity optionsActivity, JSONObject activityDetails) throws JSONException {
        this.buildOptionsActivity((OptionsActivity)optionsActivity, activityDetails);
        optionsActivity.setStartXcoord(this.getCoord(activityDetails, "startXCoord"));
        optionsActivity.setStartYcoord(this.getCoord(activityDetails, "startYCoord"));
        optionsActivity.setEndXcoord(this.getCoord(activityDetails, "endXCoord"));
        optionsActivity.setEndYcoord(this.getCoord(activityDetails, "endYCoord"));
    }

    private void buildParallelActivity(ParallelActivity activity) {
    }

    private void buildSequenceActivity(SequenceActivity activity) {
        activity.setSystemTool(this.getSystemTool(SystemTool.SEQUENCE));
    }

    private void buildToolActivity(ToolActivity toolActivity, JSONObject activityDetails) throws JSONException {
        Tool tool = this.toolDAO.getToolByID(JsonUtil.optLong((JSONObject)activityDetails, (String)"toolID"));
        toolActivity.setTool(tool);
        Long toolContentId = JsonUtil.optLong((JSONObject)activityDetails, (String)"toolContentID");
        if (toolContentId == null || toolContentId.equals(tool.getDefaultToolContentId())) {
            toolContentId = toolActivity.getToolContentId() == null || toolActivity.getToolContentId().equals(tool.getDefaultToolContentId()) ? this.getLamsCoreToolService().notifyToolToCopyContent(toolActivity, null) : toolActivity.getToolContentId();
        }
        toolActivity.setToolContentId(toolContentId);
    }

    private void buildGateActivity(Object activity, JSONObject activityDetails) throws JSONException {
        if (activity instanceof SynchGateActivity) {
            this.buildSynchGateActivity((SynchGateActivity)activity);
        } else if (activity instanceof PermissionGateActivity) {
            this.buildPermissionGateActivity((PermissionGateActivity)activity);
        } else if (activity instanceof SystemGateActivity) {
            this.buildSystemGateActivity((SystemGateActivity)activity);
        } else if (activity instanceof ConditionGateActivity) {
            this.buildConditionGateActivity((ConditionGateActivity)activity);
        } else {
            this.buildScheduleGateActivity((ScheduleGateActivity)activity, activityDetails);
        }
        GateActivity gateActivity = (GateActivity)activity;
        gateActivity.setGateActivityLevelId((Integer)JsonUtil.opt((JSONObject)activityDetails, (String)"gateActivityLevelID"));
        gateActivity.setGateOpen((Boolean)JsonUtil.opt((JSONObject)activityDetails, (String)"gateOpen"));
    }

    private void buildSynchGateActivity(SynchGateActivity activity) {
        activity.setSystemTool(this.getSystemTool(SystemTool.SYNC_GATE));
    }

    private void buildPermissionGateActivity(PermissionGateActivity activity) {
        activity.setSystemTool(this.getSystemTool(SystemTool.PERMISSION_GATE));
    }

    private void buildSystemGateActivity(SystemGateActivity activity) {
        activity.setSystemTool(this.getSystemTool(SystemTool.SYSTEM_GATE));
    }

    private void buildScheduleGateActivity(ScheduleGateActivity activity, JSONObject activityDetails) throws JSONException {
        activity.setGateStartTimeOffset(JsonUtil.optLong((JSONObject)activityDetails, (String)"gateStartTimeOffset"));
        activity.setGateEndTimeOffset(JsonUtil.optLong((JSONObject)activityDetails, (String)"gateEndTimeOffset"));
        activity.setGateActivityCompletionBased((Boolean)JsonUtil.opt((JSONObject)activityDetails, (String)"gateActivityCompletionBased"));
        SystemTool systemTool = this.getSystemTool(SystemTool.SCHEDULE_GATE);
        activity.setSystemTool(systemTool);
    }

    private void createLessonClass(LessonClass lessonClass, JSONObject groupingDetails) throws JSONException {
        Group group;
        Long groupId = JsonUtil.optLong((JSONObject)groupingDetails, (String)"staffGroupID");
        if (groupId != null && (group = this.groupDAO.getGroupById(groupId)) != null) {
            lessonClass.setStaffGroup(group);
        }
    }

    private Transition extractTransitionObject(JSONObject transitionDetails) throws JSONException {
        Activity fromActivity;
        Integer transitionUUID = transitionDetails.getInt("transitionUIID");
        Integer toUIID = transitionDetails.getInt("toUIID");
        Integer fromUIID = transitionDetails.getInt("fromUIID");
        Integer transitionType = transitionDetails.getInt("transitionType");
        Transition transition = null;
        Transition existingTransition = this.findTransition(transitionUUID, toUIID, fromUIID, transitionType);
        transition = existingTransition == null ? new Transition() : existingTransition;
        transition.setTransitionUIID(transitionUUID);
        Activity toActivity = this.newActivityMap.get(toUIID);
        if (toActivity != null) {
            transition.setToActivity(toActivity);
            transition.setToUIID(toUIID);
            if (transition.isProgressTransition()) {
                toActivity.setTransitionTo(transition);
            }
        } else {
            transition.setToActivity(null);
            transition.setToUIID(null);
        }
        if ((fromActivity = this.newActivityMap.get(fromUIID)) != null) {
            transition.setFromActivity(fromActivity);
            transition.setFromUIID(fromUIID);
            if (transition.isProgressTransition()) {
                fromActivity.setTransitionFrom(transition);
            }
        } else {
            transition.setFromActivity(null);
            transition.setFromUIID(null);
        }
        transition.setDescription((String)JsonUtil.opt((JSONObject)transitionDetails, (String)"description"));
        transition.setTitle((String)JsonUtil.opt((JSONObject)transitionDetails, (String)"title"));
        if (transition.getCreateDateTime() == null) {
            transition.setCreateDateTime(this.modificationDate);
        }
        if (transition.getToActivity() != null && transition.getFromActivity() != null) {
            transition.setLearningDesign(this.learningDesign);
            return transition;
        }
        this.cleanupTransition(transition);
        transition.setLearningDesign(null);
        return null;
    }

    private void cleanupTransition(Transition transition) {
        if (transition.getFromActivity() != null && transition.equals((Object)transition.getFromActivity().getTransitionFrom())) {
            transition.getFromActivity().setTransitionFrom(null);
        }
        if (transition.getToActivity() != null && transition.equals((Object)transition.getToActivity().getTransitionTo())) {
            transition.getToActivity().setTransitionTo(null);
        }
    }

    private Transition findTransition(Integer transitionUUID, Integer toUIID, Integer fromUIID, Integer transitionType) {
        Transition existingTransition = null;
        Set transitions = this.learningDesign.getTransitions();
        Iterator iter = transitions.iterator();
        while (existingTransition == null && iter.hasNext()) {
            Transition element = (Transition)iter.next();
            if (!element.getTransitionType().equals(transitionType)) continue;
            if (transitionUUID != null && transitionUUID.equals(element.getTransitionUIID())) {
                existingTransition = element;
                continue;
            }
            if (toUIID == null || !toUIID.equals(element.getToUIID()) || fromUIID == null || !fromUIID.equals(element.getFromUIID())) continue;
            existingTransition = element;
        }
        return existingTransition;
    }

    @Override
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Override
    public Integer getMode() {
        return this.mode;
    }

    private void parseBranchMappings(JSONArray branchMappingsList) throws JSONException, ObjectExtractorException {
        if (branchMappingsList != null) {
            for (int branchMappingIndex = 0; branchMappingIndex < branchMappingsList.length(); ++branchMappingIndex) {
                this.extractBranchActivityEntry(branchMappingsList.getJSONObject(branchMappingIndex));
            }
        }
        for (BranchActivityEntry oldEntry : this.oldbranchActivityEntryList) {
            SequenceActivity sequenceActivity = oldEntry.getBranchSequenceActivity();
            if (sequenceActivity == null) {
                oldEntry.getBranchingActivity().getBranchActivityEntries().remove(oldEntry);
            } else {
                sequenceActivity.getBranchEntries().remove(oldEntry);
            }
            Group group = oldEntry.getGroup();
            if (group != null) {
                group.getBranchActivities().remove(oldEntry);
            }
            this.activityDAO.delete((Object)oldEntry);
        }
    }

    private BranchActivityEntry extractBranchActivityEntry(JSONObject details) throws JSONException, ObjectExtractorException {
        Long entryId = JsonUtil.optLong((JSONObject)details, (String)"entryID");
        Integer entryUIID = details.getInt("entryUIID");
        Integer sequenceActivityUIID = (Integer)JsonUtil.opt((JSONObject)details, (String)"sequenceActivityUIID");
        Boolean gateOpenWhenConditionMet = (Boolean)JsonUtil.opt((JSONObject)details, (String)"gateOpenWhenConditionMet");
        Integer branchingActivityUIID = null;
        branchingActivityUIID = gateOpenWhenConditionMet != null ? Integer.valueOf(details.getInt("gateActivityUIID")) : Integer.valueOf(details.getInt("branchingActivityUIID"));
        Activity branchingActivity = this.newActivityMap.get(branchingActivityUIID);
        if (branchingActivity == null) {
            throw new ObjectExtractorException("Branching Activity listed in the branch mapping list is missing. Mapping entry UUID " + entryUIID + " branchingActivityUIID " + branchingActivityUIID);
        }
        if (!branchingActivity.isBranchingActivity() && !branchingActivity.isConditionGate()) {
            throw new ObjectExtractorException("Activity listed in the branch mapping list is not a branching activity nor a condition gate. Mapping entry UUID " + entryUIID + " branchingActivityUIID " + branchingActivityUIID);
        }
        SequenceActivity sequenceActivity = null;
        if (!branchingActivity.isConditionGate()) {
            Activity activity = this.newActivityMap.get(sequenceActivityUIID);
            if (activity == null) {
                throw new ObjectExtractorException("Sequence Activity listed in the branch mapping list is missing. Mapping entry UUID " + entryUIID + " sequenceActivityUIID " + sequenceActivityUIID);
            }
            if (!activity.isSequenceActivity()) {
                throw new ObjectExtractorException("Activity listed in the branch mapping list is not a sequence activity. Mapping entry UUID " + entryUIID + " sequenceActivityUIID " + sequenceActivityUIID);
            }
            sequenceActivity = (SequenceActivity)activity;
        }
        BranchActivityEntry uiid_match = null;
        BranchActivityEntry id_match = null;
        Iterator iter = null;
        if (sequenceActivity == null) {
            ConditionGateActivity conditionGateActitivity = (ConditionGateActivity)branchingActivity;
            if (conditionGateActitivity.getBranchActivityEntries() != null) {
                iter = conditionGateActitivity.getBranchActivityEntries().iterator();
            }
        } else if (sequenceActivity.getBranchEntries() != null) {
            iter = sequenceActivity.getBranchEntries().iterator();
        }
        if (iter != null) {
            while (uiid_match == null && iter.hasNext()) {
                BranchActivityEntry possibleEntry = (BranchActivityEntry)iter.next();
                if (entryUIID.equals(possibleEntry.getEntryUIID())) {
                    uiid_match = possibleEntry;
                }
                if (entryId == null || !entryId.equals(possibleEntry.getEntryId())) continue;
                id_match = possibleEntry;
            }
        }
        BranchActivityEntry entry = uiid_match != null ? uiid_match : id_match;
        this.oldbranchActivityEntryList.remove(entry);
        BranchCondition condition = this.extractCondition(details.optJSONObject("condition"), entry);
        Integer groupUIID = (Integer)JsonUtil.opt((JSONObject)details, (String)"groupUIID");
        Group group = null;
        if (groupUIID != null && (group = this.groups.get(groupUIID)) == null) {
            throw new ObjectExtractorException("Group listed in the branch mapping list is missing. Mapping entry UUID " + entryUIID + " groupUIID " + groupUIID);
        }
        if (condition == null && group == null) {
            throw new ObjectExtractorException("Branch mapping has neither a group or a condition. Not a valid mapping. " + details);
        }
        if (entry == null) {
            entry = condition != null ? condition.allocateBranchToCondition(entryUIID, sequenceActivity, branchingActivity, gateOpenWhenConditionMet) : group.allocateBranchToGroup(entryUIID, sequenceActivity, (BranchingActivity)branchingActivity);
        } else {
            entry.setEntryUIID(entryUIID);
            entry.setBranchSequenceActivity(sequenceActivity);
            entry.setBranchingActivity(branchingActivity);
            entry.setGateOpenWhenConditionMet(gateOpenWhenConditionMet);
        }
        Group existingGroup = entry.getGroup();
        if (existingGroup != null && !existingGroup.getGroupId().equals(group.getGroupId())) {
            existingGroup.getBranchActivities().remove(entry);
        }
        entry.setGroup(group);
        if (group != null) {
            if (group.getBranchActivities() == null) {
                group.setBranchActivities(new HashSet());
            }
            group.getBranchActivities().add(entry);
        }
        entry.setCondition(condition);
        if (branchingActivity.isConditionGate()) {
            ConditionGateActivity conditionGateActitivity = (ConditionGateActivity)branchingActivity;
            if (conditionGateActitivity.getBranchActivityEntries() == null) {
                conditionGateActitivity.setBranchActivityEntries(new HashSet());
            }
            conditionGateActitivity.getBranchActivityEntries().add(entry);
        } else {
            if (sequenceActivity.getBranchEntries() == null) {
                sequenceActivity.setBranchEntries(new HashSet());
            }
            sequenceActivity.getBranchEntries().add(entry);
            this.activityDAO.update((Object)sequenceActivity);
        }
        if (group != null) {
            this.groupingDAO.update((Object)group);
        }
        return entry;
    }

    private BranchCondition extractCondition(JSONObject conditionDetails, BranchActivityEntry entry) throws JSONException {
        BranchCondition condition = null;
        if (conditionDetails != null) {
            Long conditionID = JsonUtil.optLong((JSONObject)conditionDetails, (String)"conditionID");
            if (entry != null) {
                condition = entry.getCondition();
            }
            if (condition != null && conditionID != null && !condition.getConditionId().equals(conditionID)) {
                this.log.warn((Object)("Unexpected behaviour: condition supplied in JSON packet has a different ID to matching branch activity entry in the database. Dropping old database condition. Old db condition " + condition + " new entry in JSON " + conditionDetails));
                condition = null;
            }
            Integer conditionUIID = conditionDetails.getInt("conditionUIID");
            String conditionType = conditionDetails.getString("type");
            if ("OUTPUT_COMPLEX".equals(conditionType) || "OUTPUT_STRING".equals(conditionType)) {
                Long newConditionID = condition == null ? conditionDetails.getLong("conditionID") : condition.getConditionId().longValue();
                BranchCondition originalCondition = this.branchActivityEntryDAO.getConditionByID(newConditionID);
                if (originalCondition == null) {
                    this.log.error((Object)("Could not find condition with given ID: " + conditionID));
                } else {
                    condition = condition == null ? (BranchCondition)originalCondition.clone() : originalCondition;
                    condition.setConditionUIID(conditionUIID);
                }
            } else if (condition == null) {
                condition = new BranchCondition(null, conditionUIID, Integer.valueOf(conditionDetails.getInt("orderID")), conditionDetails.getString("name"), conditionDetails.getString("displayName"), conditionDetails.getString("type"), (String)JsonUtil.opt((JSONObject)conditionDetails, (String)"startValue"), (String)JsonUtil.opt((JSONObject)conditionDetails, (String)"endValue"), (String)JsonUtil.opt((JSONObject)conditionDetails, (String)"exactMatchValue"));
            } else {
                condition.setConditionUIID(conditionUIID);
                condition.setDisplayName(conditionDetails.getString("displayName"));
                condition.setEndValue((String)JsonUtil.opt((JSONObject)conditionDetails, (String)"endValue"));
                condition.setExactMatchValue((String)JsonUtil.opt((JSONObject)conditionDetails, (String)"exactMatchValue"));
                condition.setName(conditionDetails.getString("name"));
                condition.setOrderId(Integer.valueOf(conditionDetails.getInt("orderID")));
                condition.setStartValue((String)JsonUtil.opt((JSONObject)conditionDetails, (String)"startValue"));
                condition.setType(conditionDetails.getString("type"));
            }
        }
        return condition;
    }

    private SystemTool getSystemTool(Long systemToolId) {
        SystemTool tool = this.systemTools.get(systemToolId);
        if (tool == null) {
            tool = this.systemToolDAO.getSystemToolByID(systemToolId);
            if (tool != null) {
                this.systemTools.put(systemToolId, tool);
            } else {
                this.log.error((Object)("ObjectExtractor: Unable to find matching system tool for id " + systemToolId));
            }
        }
        return tool;
    }

    private void createLearnerChoiceGrouping(LearnerChoiceGrouping learnerChoiceGrouping, JSONObject groupingDetails) throws JSONException {
        Integer numLearnersPerGroup = (Integer)JsonUtil.opt((JSONObject)groupingDetails, (String)"learnersPerGroup");
        if (numLearnersPerGroup != null && numLearnersPerGroup > 0) {
            learnerChoiceGrouping.setLearnersPerGroup(numLearnersPerGroup);
            learnerChoiceGrouping.setNumberOfGroups(null);
            learnerChoiceGrouping.setEqualNumberOfLearnersPerGroup(null);
        } else {
            Integer numGroups = (Integer)JsonUtil.opt((JSONObject)groupingDetails, (String)"numberOfGroups");
            if (numGroups != null && numGroups > 0) {
                learnerChoiceGrouping.setNumberOfGroups(numGroups);
            } else {
                learnerChoiceGrouping.setNumberOfGroups(null);
            }
            learnerChoiceGrouping.setLearnersPerGroup(null);
            Boolean equalNumberOfLearnersPerGroup = (Boolean)JsonUtil.opt((JSONObject)groupingDetails, (String)"equalNumberOfLearnersPerGroup");
            if (equalNumberOfLearnersPerGroup != null) {
                learnerChoiceGrouping.setEqualNumberOfLearnersPerGroup(equalNumberOfLearnersPerGroup);
            }
        }
        learnerChoiceGrouping.setViewStudentsBeforeSelection((Boolean)JsonUtil.opt((JSONObject)groupingDetails, (String)"viewStudentsBeforeSelection"));
    }

    private void buildConditionGateActivity(ConditionGateActivity activity) {
        activity.setSystemTool(this.getSystemTool(SystemTool.CONDITION_GATE));
    }
}

