/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.authoring.ObjectExtractorException;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningDesignAccess;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.LearningLibraryGroup;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.dto.ToolOutputDefinitionDTO;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserException;
import org.lamsfoundation.lams.usermanagement.exception.WorkspaceFolderException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthoringAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(AuthoringAction.class);
    private static IMonitoringService monitoringService;
    private static IUserManagementService userManagementService;
    private static ILamsToolService toolService;
    private static IAuthoringService authoringService;
    private static ILearningDesignService learningDesignService;
    private static ISecurityService securityService;
    private static IIntegrationService integrationService;
    private static int LEARNING_DESIGN_ACCESS_ENTRIES_LIMIT;

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    private String getUserLanguage() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getLocaleLanguage() : "";
    }

    public ActionForward openAuthoring(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException {
        request.setAttribute("contentFolderID", (Object)FileUtil.generateUniqueContentFolderID());
        request.setAttribute("tools", (Object)this.getLearningDesignService().getToolDTOs(true, true, request.getRemoteUser()));
        List groups = this.getLearningDesignService().getLearningLibraryGroups();
        JSONArray groupsJSON = new JSONArray();
        for (LearningLibraryGroup group : groups) {
            JSONObject groupJSON = new JSONObject();
            groupJSON.put("name", (Object)group.getName());
            for (LearningLibrary learningLibrary : group.getLearningLibraries()) {
                groupJSON.append("learningLibraries", (Object)learningLibrary.getLearningLibraryId());
            }
            groupsJSON.put((Object)groupJSON);
        }
        request.setAttribute("learningLibraryGroups", (Object)groupsJSON.toString());
        List<LearningDesignAccess> accessList = this.getAuthoringService().updateLearningDesignAccessByUser(this.getUserId());
        accessList = accessList.subList(0, Math.min(accessList.size(), LEARNING_DESIGN_ACCESS_ENTRIES_LIMIT - 1));
        Gson gson = new GsonBuilder().create();
        request.setAttribute("access", (Object)gson.toJson(accessList));
        request.setAttribute("licenses", this.getAuthoringService().getAvailableLicenses());
        return mapping.findForward("openAutoring");
    }

    public ActionForward generateSVG(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("tools", (Object)this.getLearningDesignService().getToolDTOs(true, true, request.getRemoteUser()));
        return mapping.findForward("svgGenerator");
    }

    public ActionForward getToolOutputDefinitions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, JSONException {
        IAuthoringService authoringService = this.getAuthoringService();
        Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        Integer definitionType = 1;
        List<ToolOutputDefinitionDTO> defnDTOList = authoringService.getToolOutputDefinitions(toolContentID, definitionType);
        Gson gson = new GsonBuilder().create();
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(gson.toJson(defnDTOList));
        return null;
    }

    public ActionForward openLearningDesign(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, JSONException {
        long learningDesignID = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID");
        LearningDesignDTO learningDesignDTO = this.getLearningDesignService().getLearningDesignDTO(Long.valueOf(learningDesignID), this.getUserLanguage());
        for (AuthoringActivityDTO activity : learningDesignDTO.getActivities()) {
            if (activity.getLearningLibraryID() != null) continue;
            this.getLearningDesignService().fillLearningLibraryID(activity);
        }
        Integer userId = this.getUserId();
        this.getAuthoringService().storeLearningDesignAccess(learningDesignID, userId);
        response.setContentType("application/json;charset=utf-8");
        JSONObject responseJSON = new JSONObject();
        Gson gson = new GsonBuilder().create();
        responseJSON.put("ld", (Object)new JSONObject(gson.toJson((Object)learningDesignDTO)));
        List<LearningDesignAccess> accessList = this.getAuthoringService().updateLearningDesignAccessByUser(userId);
        accessList = accessList.subList(0, Math.min(accessList.size(), LEARNING_DESIGN_ACCESS_ENTRIES_LIMIT - 1));
        responseJSON.put("access", (Object)new JSONArray(gson.toJson(accessList)));
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    public ActionForward finishLearningDesignEdit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IAuthoringService authoringService = this.getAuthoringService();
        Long learningDesignID = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID", (boolean)false);
        boolean cancelled = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"cancelled", (boolean)false);
        authoringService.finishEditOnFly(learningDesignID, this.getUserId(), cancelled);
        return null;
    }

    public ActionForward copyToolContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            String customCSV = WebUtil.readStrParam((HttpServletRequest)request, (String)"customCSV", (boolean)true);
            long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID", (boolean)false);
            Long newToolContentID = authoringService.copyToolContent(toolContentID, customCSV);
            response.setContentType("text/plain;charset=utf-8");
            response.getWriter().write(newToolContentID.toString());
        }
        catch (Exception e) {
            response.sendError(500);
        }
        return null;
    }

    public ActionForward createToolContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, JSONException {
        IAuthoringService authoringService = this.getAuthoringService();
        Long toolID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolID");
        Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID", (boolean)true);
        if (toolContentID == null) {
            toolContentID = authoringService.insertToolContentID(toolID);
        }
        if (toolContentID != null) {
            String authorUrl;
            String contentFolderID = request.getParameter("contentFolderID");
            if (StringUtils.isBlank((String)contentFolderID)) {
                contentFolderID = FileUtil.generateUniqueContentFolderID();
            }
            if ((authorUrl = authoringService.getToolAuthorUrl(toolID, toolContentID, contentFolderID)) != null) {
                JSONObject responseJSON = new JSONObject();
                responseJSON.put("authorURL", (Object)authorUrl);
                responseJSON.put("toolContentID", (Object)toolContentID);
                responseJSON.put("contentFolderID", (Object)contentFolderID);
                response.setContentType("application/json;charset=utf-8");
                response.getWriter().write(responseJSON.toString());
            }
        }
        return null;
    }

    public ActionForward createSingleActivityLesson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebApplicationContext wac;
        ToolContentManager toolManager;
        String title;
        Long learningDesignID;
        IAuthoringService authoringService = this.getAuthoringService();
        Long toolID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolID");
        Long toolContentID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        Long learningLibraryID = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningLibraryID", (boolean)true);
        String contentFolderID = request.getParameter("contentFolderID");
        Integer organisationID = WebUtil.readIntParam((HttpServletRequest)request, (String)"organisationID", (boolean)true);
        if (organisationID == null) {
            String serverID = request.getParameter("sid");
            String courseID = request.getParameter("courseid");
            ExtServer extServer = this.getIntegrationService().getExtServer(serverID);
            ExtCourseClassMap orgMap = this.getIntegrationService().getExtCourseClassMap(extServer.getSid(), courseID);
            organisationID = orgMap.getOrganisation().getOrganisationId();
        }
        Integer userID = this.getUserId();
        if (!this.getSecurityService().isGroupMonitor(organisationID, userID, "create single activity lesson", false)) {
            response.sendError(403, "User is not a monitor in the organisation");
            return null;
        }
        IToolVO tool = this.getToolService().getToolByID(toolID);
        if (learningLibraryID == null) {
            learningLibraryID = tool.getLearningLibraryId();
        }
        if ((learningDesignID = authoringService.insertSingleActivityLearningDesign(title = (toolManager = (ToolContentManager)(wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext())).getBean(tool.getServiceName())).getToolContentTitle(toolContentID), toolID, toolContentID, learningLibraryID, contentFolderID, organisationID)) != null) {
            User user = (User)this.getUserManagementService().findById(User.class, (Serializable)userID);
            Lesson lesson = this.getMonitoringService().initializeLessonWithoutLDcopy(title, "", learningDesignID.longValue(), user, null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), null, null);
            Organisation organisation = this.getMonitoringService().getOrganisation(organisationID);
            LinkedList<User> staffList = new LinkedList<User>();
            staffList.add(user);
            LinkedList learnerList = new LinkedList();
            Vector learnerVector = this.getUserManagementService().getUsersFromOrganisationByRole(organisationID, "LEARNER", true);
            learnerList.addAll(learnerVector);
            this.getMonitoringService().createLessonClassForLesson(lesson.getLessonId().longValue(), organisation, organisation.getName() + " learners", learnerList, organisation.getName() + " staff", staffList, userID);
            this.getMonitoringService().startLesson(lesson.getLessonId().longValue(), userID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created a single activity lesson with ID: " + lesson.getLessonId()));
            }
            response.setContentType("text/plain;charset=utf-8");
            response.getWriter().write(learningDesignID.toString());
        }
        return null;
    }

    public ActionForward saveLearningDesign(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, UserException, WorkspaceFolderException, IOException, ObjectExtractorException, ParseException {
        Long learningDesignID;
        JSONObject ldJSON = new JSONObject(request.getParameter("ld"));
        LearningDesign learningDesign = this.getAuthoringService().saveLearningDesignDetails(ldJSON);
        JSONObject responseJSON = new JSONObject();
        if (learningDesign != null && (learningDesignID = learningDesign.getLearningDesignId()) != null) {
            responseJSON.put("learningDesignID", (Object)learningDesignID);
            Gson gson = new GsonBuilder().create();
            Vector<ValidationErrorDTO> validationDTOs = this.getAuthoringService().validateLearningDesign(learningDesignID);
            String validationJSON = gson.toJson(validationDTOs);
            responseJSON.put("validation", (Object)new JSONArray(validationJSON));
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(responseJSON.toString());
        return null;
    }

    public ActionForward getLearningDesignAccess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Integer userId = this.getUserId();
        List<LearningDesignAccess> accessList = this.getAuthoringService().updateLearningDesignAccessByUser(userId);
        accessList = accessList.subList(0, Math.min(accessList.size(), LEARNING_DESIGN_ACCESS_ENTRIES_LIMIT - 1));
        Gson gson = new GsonBuilder().create();
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().write(gson.toJson(accessList));
        return null;
    }

    public ActionForward saveLearningDesignImage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long learningDesignID = WebUtil.readLongParam((HttpServletRequest)request, (String)"learningDesignID");
        String image = request.getParameter("image");
        boolean saveSuccesful = AuthoringAction.saveLearningDesignImage(learningDesignID, image);
        if (!saveSuccesful) {
            response.sendError(500);
        }
        return null;
    }

    private static boolean saveLearningDesignImage(long learningDesignID, String image) {
        if (StringUtils.isBlank((String)image)) {
            log.error((Object)("No SVG code to save for LD: " + learningDesignID));
            return false;
        }
        File thumbnailDirectory = new File(IAuthoringService.LEARNING_DESIGN_IMAGES_FOLDER);
        if (!thumbnailDirectory.exists()) {
            thumbnailDirectory.mkdirs();
        }
        String absoluteFilePath = FileUtil.getFullPath((String)IAuthoringService.LEARNING_DESIGN_IMAGES_FOLDER, (String)(learningDesignID + ".svg"));
        try (FileOutputStream fos = new FileOutputStream(absoluteFilePath);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF8");){
            writer.write(image);
        }
        catch (IOException e) {
            log.error((Object)("Error while writing SVG thumbnail of LD " + learningDesignID + "."), (Throwable)e);
            return false;
        }
        return true;
    }

    private IMonitoringService getMonitoringService() {
        if (monitoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            monitoringService = (IMonitoringService)ctx.getBean("monitoringService");
        }
        return monitoringService;
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)wac.getBean("userManagementService");
        }
        return userManagementService;
    }

    public IAuthoringService getAuthoringService() {
        if (authoringService == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            authoringService = (IAuthoringService)wac.getBean("authoringService");
        }
        return authoringService;
    }

    public ILamsToolService getToolService() {
        if (toolService == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            toolService = (ILamsToolService)wac.getBean("lamsToolService");
        }
        return toolService;
    }

    private ILearningDesignService getLearningDesignService() {
        if (learningDesignService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learningDesignService = (ILearningDesignService)ctx.getBean("learningDesignService");
        }
        return learningDesignService;
    }

    private IIntegrationService getIntegrationService() {
        if (integrationService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            integrationService = (IIntegrationService)ctx.getBean("integrationService");
        }
        return integrationService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)ctx.getBean("securityService");
        }
        return securityService;
    }

    static {
        LEARNING_DESIGN_ACCESS_ENTRIES_LIMIT = 7;
    }
}

