/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.comments.web;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.comments.Comment;
import org.lamsfoundation.lams.comments.CommentLike;
import org.lamsfoundation.lams.comments.dto.CommentDTO;
import org.lamsfoundation.lams.comments.service.ICommentService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.tool.GroupedToolSession;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CommentAction
extends Action {
    private static Logger log = Logger.getLogger(CommentAction.class);
    private static IUserManagementService userService;
    private static ICommentService commentService;
    private static ILamsCoreToolService coreToolService;
    private static ISecurityService securityService;

    public final ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = mapping.getParameter();
        if (param.equals("init")) {
            return this.init(mapping, form, request, response);
        }
        if (param.equals("viewTopic")) {
            return this.viewTopic(mapping, form, request, response);
        }
        if (param.equals("viewTopicThread")) {
            return this.viewTopicThread(mapping, form, request, response);
        }
        if (param.equals("newComment")) {
            return this.newComment(mapping, form, request, response);
        }
        if (param.equals("newReplyTopic")) {
            return this.newReplyTopic(mapping, form, request, response);
        }
        if (param.equals("replyTopicInline")) {
            return this.replyTopicInline(mapping, form, request, response);
        }
        if (param.equals("editTopic")) {
            return this.editTopic(mapping, form, request, response);
        }
        if (param.equals("updateTopicInline")) {
            return this.updateTopicInline(mapping, form, request, response);
        }
        if (param.equals("like")) {
            return this.updateLikeCount(mapping, form, request, response, true);
        }
        if (param.equals("dislike")) {
            return this.updateLikeCount(mapping, form, request, response, false);
        }
        if (param.equals("hide")) {
            return this.hideComment(mapping, form, request, response, false);
        }
        if (param.equals("makeSticky")) {
            return this.makeSticky(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Integer sortBy;
        Integer pageSize;
        String externalSignature;
        int externalType;
        Long externalId;
        SessionMap sessionMap;
        String sessionMapID = request.getParameter("sessionMapID");
        if (sessionMapID != null) {
            sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
            externalId = (Long)sessionMap.get((Object)"externalID");
            externalType = (Integer)sessionMap.get((Object)"externalType");
            externalSignature = (String)sessionMap.get((Object)"externalSig");
            String mode = (String)sessionMap.get((Object)"mode");
            pageSize = (Integer)sessionMap.get((Object)"pageSize");
            sortBy = (Integer)sessionMap.get((Object)"sortBy");
        } else {
            sessionMap = new SessionMap();
            request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
            externalId = WebUtil.readLongParam((HttpServletRequest)request, (String)"externalID");
            externalType = WebUtil.readIntParam((HttpServletRequest)request, (String)"externalType");
            externalSignature = WebUtil.readStrParam((HttpServletRequest)request, (String)"externalSig");
            boolean likeAndDislike = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"likeAndDislike");
            boolean readOnly = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"readOnly");
            pageSize = WebUtil.readIntParam((HttpServletRequest)request, (String)"pageSize", (boolean)true);
            if (pageSize == null) {
                pageSize = 20;
            }
            if ((sortBy = WebUtil.readIntParam((HttpServletRequest)request, (String)"sortBy", (boolean)true)) == null) {
                sortBy = ICommentService.SORT_BY_DATE;
            }
            sessionMap.put((Object)"externalID", (Object)externalId);
            sessionMap.put((Object)"externalType", (Object)externalType);
            sessionMap.put((Object)"externalSig", (Object)externalSignature);
            sessionMap.put((Object)"likeAndDislike", (Object)likeAndDislike);
            sessionMap.put((Object)"readOnly", (Object)readOnly);
            sessionMap.put((Object)"pageSize", (Object)pageSize);
            sessionMap.put((Object)"sortBy", (Object)sortBy);
            String mode = request.getParameter("mode");
            sessionMap.put((Object)"mode", (Object)(mode != null ? mode : ToolAccessMode.LEARNER.toString()));
        }
        User user = this.getCurrentUser(request);
        if (externalType != 1) {
            this.throwException("Unknown comment type ", user.getLogin(), externalId, externalType, externalSignature);
        }
        Comment rootComment = this.getCommentService().createOrGetRoot(externalId, Integer.valueOf(externalType), externalSignature, user);
        sessionMap.put((Object)"rootUid", (Object)rootComment.getUid());
        return this.viewTopicImpl(mapping, form, request, response, (SessionMap<String, Object>)sessionMap, pageSize, sortBy, true);
    }

    private void throwException(String msg, String loginName, Long externalId, Integer externalType, String externalSignature) throws ServletException {
        String error = msg + " User " + loginName + " " + externalId + ":" + externalType + ":" + externalSignature;
        log.error((Object)error);
        throw new ServletException(error);
    }

    private void throwException(String msg, String loginName) throws ServletException {
        String error = msg + " User " + loginName;
        log.error((Object)error);
        throw new ServletException(error);
    }

    private boolean learnerInToolSession(Long toolSessionId, User user) {
        GroupedToolSession toolSession = (GroupedToolSession)this.getCoreToolService().getToolSessionById(toolSessionId);
        return toolSession.getSessionGroup().getUsers().contains(user);
    }

    private boolean monitorInToolSession(Long toolSessionId, User user, SessionMap<String, Object> sessionMap) {
        if (ToolAccessMode.TEACHER.equals((Object)WebUtil.getToolAccessMode((String)((String)sessionMap.get((Object)"mode"))))) {
            GroupedToolSession toolSession = (GroupedToolSession)this.getCoreToolService().getToolSessionById(toolSessionId);
            return this.getSecurityService().isLessonMonitor(toolSession.getLesson().getLessonId(), user.getUserId(), "Comment Monitoring Tasks", false);
        }
        return false;
    }

    private ActionForward viewTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Integer pageSize = WebUtil.readIntParam((HttpServletRequest)request, (String)"pageSize", (boolean)true);
        Integer sortBy = WebUtil.readIntParam((HttpServletRequest)request, (String)"sortBy", (boolean)true);
        Boolean sticky = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"sticky", (boolean)false);
        if (sortBy != null) {
            sessionMap.put((Object)"sortBy", (Object)sortBy);
        }
        return this.viewTopicImpl(mapping, form, request, response, (SessionMap<String, Object>)sessionMap, pageSize, sortBy, sticky);
    }

    private ActionForward viewTopicImpl(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, SessionMap<String, Object> sessionMap, Integer pageSize, Integer sortBy, boolean includeSticky) {
        Long externalId = (Long)sessionMap.get((Object)"externalID");
        Integer externalType = (Integer)sessionMap.get((Object)"externalType");
        String externalSignature = (String)sessionMap.get((Object)"externalSig");
        commentService = this.getCommentService();
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Long lastMsgSeqId = WebUtil.readLongParam((HttpServletRequest)request, (String)"pageLastId", (boolean)true);
        String currentLikeCount = WebUtil.readStrParam((HttpServletRequest)request, (String)"likeCount", (boolean)true);
        if (pageSize == null) {
            pageSize = (Integer)sessionMap.get((Object)"pageSize");
        }
        if (sortBy == null) {
            sortBy = (Integer)sessionMap.get((Object)"sortBy");
        }
        List msgDtoList = commentService.getTopicThread(externalId, externalType, externalSignature, lastMsgSeqId, pageSize, sortBy, currentLikeCount, user.getUserID());
        this.updateMessageFlag(msgDtoList, user.getUserID());
        request.setAttribute("commentThread", (Object)msgDtoList);
        if (includeSticky) {
            List stickyList = commentService.getTopicStickyThread(externalId, externalType, externalSignature, sortBy, currentLikeCount, user.getUserID());
            this.updateMessageFlag(stickyList, user.getUserID());
            request.setAttribute("sticky", (Object)stickyList);
        }
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        return mapping.findForward(includeSticky ? "successAll" : "success");
    }

    private SessionMap<String, Object> getSessionMap(HttpServletRequest request) {
        String sessionMapId = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        return (SessionMap)request.getSession().getAttribute(sessionMapId);
    }

    private ActionForward viewTopicThread(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        commentService = this.getCommentService();
        Long highlightMessageUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"commentUid", (boolean)true);
        SessionMap<String, Object> sessionMap = this.getSessionMap(request);
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        Long threadId = WebUtil.readLongParam((HttpServletRequest)request, (String)"threadUid", (boolean)true);
        Integer sortBy = WebUtil.readIntParam((HttpServletRequest)request, (String)"sortBy", (boolean)true);
        if (sortBy != null) {
            sessionMap.put((Object)"sortBy", (Object)sortBy);
        }
        List msgDtoList = commentService.getThread(threadId, sortBy, user.getUserID());
        this.updateMessageFlag(msgDtoList, user.getUserID());
        request.setAttribute("commentThread", (Object)msgDtoList);
        if (highlightMessageUid != null) {
            request.setAttribute("commentUid", (Object)highlightMessageUid);
        }
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        request.setAttribute("noMorePages", (Object)true);
        return mapping.findForward("success");
    }

    private void updateMessageFlag(List<CommentDTO> msgDtoList, Integer currUserId) {
        for (CommentDTO dto : msgDtoList) {
            Comment comment = dto.getComment();
            if (comment.getCreatedBy() != null && currUserId.equals(comment.getCreatedBy().getUserId())) {
                dto.setIsAuthor(true);
                continue;
            }
            dto.setIsAuthor(false);
        }
    }

    private ActionForward newComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws InterruptedException, JSONException, IOException, ServletException {
        JSONObject JSONObject2;
        SessionMap<String, Object> sessionMap = this.getSessionMap(request);
        Long externalId = (Long)sessionMap.get((Object)"externalID");
        Integer externalType = (Integer)sessionMap.get((Object)"externalType");
        String externalSignature = (String)sessionMap.get((Object)"externalSig");
        String commentText = request.getParameter("body");
        if (commentText != null) {
            commentText = commentText.trim();
        }
        if (!this.validateText(commentText)) {
            JSONObject2 = this.getFailedValidationJSON();
        } else {
            boolean isMonitor;
            commentService = this.getCommentService();
            User user = this.getCurrentUser(request);
            ToolAccessMode mode = WebUtil.getToolAccessMode((String)((String)sessionMap.get((Object)"mode")));
            boolean bl = isMonitor = ToolAccessMode.TEACHER.equals((Object)mode) && this.monitorInToolSession(externalId, user, sessionMap);
            if (!isMonitor && !this.learnerInToolSession(externalId, user)) {
                this.throwException("New comment: User does not have the rights to access the comments. ", user.getLogin(), externalId, externalType, externalSignature);
            }
            Comment rootSeq = commentService.getRoot(externalId, externalType, externalSignature);
            Comment newComment = commentService.createReply(rootSeq, commentText, user, isMonitor);
            JSONObject2 = new JSONObject();
            JSONObject2.put("commentUid", (Object)newComment.getUid());
            JSONObject2.put("threadUid", (Object)newComment.getThreadComment().getUid());
            JSONObject2.put("sessionMapID", (Object)sessionMap.getSessionID());
            JSONObject2.put("parentUid", (Object)newComment.getParent().getUid());
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(JSONObject2);
        return null;
    }

    private ActionForward newReplyTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("sessionMapID", (Object)request.getParameter("sessionMapID"));
        request.setAttribute("parentUid", (Object)request.getParameter("parentUid"));
        return mapping.findForward("success");
    }

    private ActionForward replyTopicInline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws InterruptedException, JSONException, IOException, ServletException {
        JSONObject JSONObject2;
        SessionMap<String, Object> sessionMap = this.getSessionMap(request);
        Long externalId = (Long)sessionMap.get((Object)"externalID");
        Integer externalType = (Integer)sessionMap.get((Object)"externalType");
        String externalSignature = (String)sessionMap.get((Object)"externalSig");
        Long parentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"parentUid");
        String commentText = WebUtil.readStrParam((HttpServletRequest)request, (String)"body", (boolean)true);
        if (commentText != null) {
            commentText = commentText.trim();
        }
        if (!this.validateText(commentText)) {
            JSONObject2 = this.getFailedValidationJSON();
        } else {
            boolean isMonitor;
            User user = this.getCurrentUser(request);
            ToolAccessMode mode = WebUtil.getToolAccessMode((String)((String)sessionMap.get((Object)"mode")));
            boolean bl = isMonitor = ToolAccessMode.TEACHER.equals((Object)mode) && this.monitorInToolSession(externalId, user, sessionMap);
            if (!isMonitor && !this.learnerInToolSession(externalId, user)) {
                this.throwException("New comment: User does not have the rights to access the comments. ", user.getLogin(), externalId, externalType, externalSignature);
            }
            Comment newComment = commentService.createReply(parentId, commentText.trim(), user, isMonitor);
            JSONObject2 = new JSONObject();
            JSONObject2.put("commentUid", (Object)newComment.getUid());
            JSONObject2.put("threadUid", (Object)newComment.getThreadComment().getUid());
            JSONObject2.put("sessionMapID", (Object)sessionMap.getSessionID());
            JSONObject2.put("parentUid", (Object)newComment.getParent().getUid());
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(JSONObject2);
        return null;
    }

    private boolean validateText(String commentText) {
        return commentText != null && commentText.length() > 0 && commentText.length() < 5000;
    }

    private JSONObject getFailedValidationJSON() throws JSONException {
        MessageService msgService = this.getCommentService().getMessageService();
        JSONObject JSONObject2 = new JSONObject();
        JSONObject2.put("errMessage", (Object)msgService.getMessage("label.comment.body.validation"));
        return JSONObject2;
    }

    public ActionForward editTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long commentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"commentUid");
        CommentDTO comment = this.getCommentService().getComment(commentId);
        SessionMap<String, Object> sessionMap = this.getSessionMap(request);
        sessionMap.put((Object)"commentUid", (Object)commentId);
        request.setAttribute("commentUid", (Object)commentId);
        request.setAttribute("comment", (Object)comment);
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        return mapping.findForward("success");
    }

    public ActionForward updateTopicInline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException, ServletException {
        JSONObject JSONObject2;
        commentService = this.getCommentService();
        SessionMap<String, Object> sessionMap = this.getSessionMap(request);
        Long commentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"commentUid");
        Long externalId = (Long)sessionMap.get((Object)"externalID");
        Integer externalType = (Integer)sessionMap.get((Object)"externalType");
        String externalSignature = (String)sessionMap.get((Object)"externalSig");
        String commentText = request.getParameter("body");
        if (commentText != null) {
            commentText = commentText.trim();
        }
        if (!this.validateText(commentText)) {
            JSONObject2 = this.getFailedValidationJSON();
        } else {
            CommentDTO originalComment = commentService.getComment(commentId);
            User user = this.getCurrentUser(request);
            if (!originalComment.getComment().getCreatedBy().equals((Object)user) && !this.monitorInToolSession(externalId, user, sessionMap)) {
                this.throwException("Update comment: User does not have the rights to update the comment " + commentId + ". ", user.getLogin(), externalId, externalType, externalSignature);
            }
            Comment updatedComment = commentService.updateComment(commentId, commentText, user, ToolAccessMode.TEACHER.equals((Object)WebUtil.getToolAccessMode((String)((String)sessionMap.get((Object)"mode")))));
            JSONObject2 = new JSONObject();
            JSONObject2.put("commentUid", (Object)commentId);
            JSONObject2.put("sessionMapID", (Object)sessionMap.getSessionID());
            JSONObject2.put("threadUid", (Object)updatedComment.getThreadComment().getUid());
            JSONObject2.put("parentUid", (Object)updatedComment.getParent().getUid());
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(JSONObject2);
        return null;
    }

    private ActionForward updateLikeCount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean isLike) throws InterruptedException, JSONException, IOException, ServletException {
        SessionMap<String, Object> sessionMap = this.getSessionMap(request);
        Long messageUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"commentUid");
        Long externalId = (Long)sessionMap.get((Object)"externalID");
        commentService = this.getCommentService();
        User user = this.getCurrentUser(request);
        if (!this.learnerInToolSession(externalId, user)) {
            this.throwException("Update comment: User does not have the rights to like/dislike the comment " + messageUid + ". ", user.getLogin(), externalId, (Integer)sessionMap.get((Object)"externalType"), (String)sessionMap.get((Object)"externalSig"));
        }
        boolean added = commentService.addLike(messageUid, user, Integer.valueOf(isLike ? CommentLike.LIKE : CommentLike.DISLIKE));
        JSONObject JSONObject2 = new JSONObject();
        JSONObject2.put("commentUid", (Object)messageUid);
        JSONObject2.put("status", added);
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(JSONObject2);
        return null;
    }

    private ActionForward hideComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean isLike) throws InterruptedException, JSONException, IOException, ServletException {
        SessionMap<String, Object> sessionMap = this.getSessionMap(request);
        Long commentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"commentUid");
        Long externalId = (Long)sessionMap.get((Object)"externalID");
        boolean status = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"hideFlag");
        commentService = this.getCommentService();
        User user = this.getCurrentUser(request);
        if (!this.monitorInToolSession(externalId, user, sessionMap)) {
            this.throwException("Update comment: User does not have the rights to hide the comment " + commentId + ". ", user.getLogin(), externalId, (Integer)sessionMap.get((Object)"externalType"), (String)sessionMap.get((Object)"externalSig"));
        }
        Comment updatedComment = commentService.hideComment(commentId, user, status);
        JSONObject JSONObject2 = new JSONObject();
        JSONObject2.put("commentUid", (Object)updatedComment.getUid());
        JSONObject2.put("sessionMapID", (Object)sessionMap.getSessionID());
        JSONObject2.put("threadUid", (Object)updatedComment.getThreadComment().getUid());
        JSONObject2.put("parentUid", (Object)updatedComment.getParent().getUid());
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(JSONObject2);
        return null;
    }

    public ActionForward makeSticky(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws JSONException, IOException, ServletException {
        commentService = this.getCommentService();
        SessionMap<String, Object> sessionMap = this.getSessionMap(request);
        Long commentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"commentUid");
        Boolean sticky = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"sticky");
        Long externalId = (Long)sessionMap.get((Object)"externalID");
        CommentDTO originalComment = commentService.getComment(commentId);
        User user = this.getCurrentUser(request);
        if (!this.monitorInToolSession(externalId, user, sessionMap)) {
            this.throwException("Make comment sticky: User does not have the rights to make the comment stick to the top of the list " + commentId + ". ", user.getLogin());
        }
        if (originalComment.getComment().getCommentLevel() != 1) {
            this.throwException("Make comment sticky: Comment much be level 1 to stick to the top of the list " + commentId + " level " + originalComment.getLevel() + ". ", user.getLogin());
        }
        Comment updatedComment = commentService.updateSticky(commentId, sticky);
        JSONObject JSONObject2 = new JSONObject();
        JSONObject2.put("commentUid", (Object)commentId);
        JSONObject2.put("sessionMapID", (Object)sessionMap.getSessionID());
        JSONObject2.put("threadUid", (Object)updatedComment.getThreadComment().getUid());
        JSONObject2.put("parentUid", (Object)updatedComment.getParent().getUid());
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(JSONObject2);
        return null;
    }

    private User getCurrentUser(HttpServletRequest request) {
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        return this.getUserService().getUserByLogin(user.getLogin());
    }

    private IUserManagementService getUserService() {
        if (userService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userService;
    }

    private ICommentService getCommentService() {
        if (commentService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            commentService = (ICommentService)ctx.getBean("commentService");
        }
        return commentService;
    }

    private ILamsCoreToolService getCoreToolService() {
        if (coreToolService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            coreToolService = (ILamsCoreToolService)ctx.getBean("lamsCoreToolService");
        }
        return coreToolService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)ctx.getBean("securityService");
        }
        return securityService;
    }
}

