/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class RestServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(RestServlet.class);
    private static IToolDAO toolDAO;
    private static ILamsCoreToolService lamsCoreToolService;
    private static IIntegrationService integrationService;
    private static IAuthoringService authoringService;
    private static IUserManagementService userManagementService;

    private UserDTO authenticate(JSONObject authenticationJSON) {
        User user = null;
        try {
            String serverName = authenticationJSON.getString("sid");
            ExtServer extServer = this.getIntegrationService().getExtServer(serverName);
            String userName = authenticationJSON.getString("uid");
            String method = authenticationJSON.getString("method").toLowerCase();
            String timestamp = authenticationJSON.getString("ts");
            String hash = authenticationJSON.getString("hash");
            Authenticator.authenticateLoginRequest((ExtServer)extServer, (String)timestamp, (String)userName, (String)method, null, (String)hash);
            ExtUserUseridMap userMap = this.getIntegrationService().getExtUserUseridMap(extServer, userName);
            user = userMap.getUser();
            user = (User)this.getUserManagementService().findById(User.class, (Serializable)user.getUserId());
            return user.getUserDTO();
        }
        catch (JSONException e) {
            log.error((Object)"Error while reading authentication JSON", (Throwable)e);
        }
        catch (AuthenticationException e) {
            log.error((Object)"The user was not authenticated", (Throwable)e);
        }
        catch (UserInfoFetchException e) {
            log.error((Object)"Could not fetch new user information from integration server", (Throwable)e);
        }
        catch (UserInfoValidationException e) {
            log.error((Object)"User data is not valid", (Throwable)e);
        }
        return null;
    }

    private IIntegrationService getIntegrationService() {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        }
        return integrationService;
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean createNewSession;
        String requestBody = IOUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
        JSONObject requestJSON = null;
        JSONObject authenticationJSON = null;
        try {
            requestJSON = new JSONObject(requestBody);
            authenticationJSON = requestJSON.getJSONObject("auth");
        }
        catch (JSONException e) {
            throw new IOException("Error while parsing REST request JSON", e);
        }
        UserDTO userDTO = this.authenticate(authenticationJSON);
        if (userDTO == null) {
            response.sendError(403, "The user is not authenticated");
            return;
        }
        requestJSON.remove("auth");
        UserDTO existingUserDTO = null;
        HttpSession session = SessionManager.getSession();
        boolean bl = createNewSession = session == null;
        if (createNewSession) {
            SessionManager.startSession((HttpServletRequest)request);
        } else {
            existingUserDTO = (UserDTO)session.getAttribute("user");
        }
        session = SessionManager.getSession();
        session.setAttribute("user", (Object)userDTO);
        try {
            this.doPostInternal(requestJSON, userDTO, response);
        }
        catch (Exception e) {
            throw new ServletException("Error while processing REST request", (Throwable)e);
        }
        finally {
            if (createNewSession) {
                SessionManager.endSession();
            } else {
                session.setAttribute("user", (Object)existingUserDTO);
            }
        }
    }

    protected abstract void doPostInternal(JSONObject var1, UserDTO var2, HttpServletResponse var3) throws Exception;

    protected final IAuthoringService getAuthoringService() {
        if (authoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            authoringService = (IAuthoringService)ctx.getBean("authoringService");
        }
        return authoringService;
    }

    protected ILamsCoreToolService getLamsCoreToolService() {
        if (lamsCoreToolService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            lamsCoreToolService = (ILamsCoreToolService)ctx.getBean("lamsCoreToolService");
        }
        return lamsCoreToolService;
    }

    protected IToolDAO getToolDAO() {
        if (toolDAO == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            toolDAO = (IToolDAO)ctx.getBean("toolDAO");
        }
        return toolDAO;
    }

    protected final IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }
}

