/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.index.IndexLessonBean;
import org.lamsfoundation.lams.index.IndexLinkBean;
import org.lamsfoundation.lams.index.IndexOrgBean;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.LessonService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.IndexUtils;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DisplayGroupAction
extends Action {
    private static IUserManagementService service;
    private static LessonService lessonService;
    private static ILearningDesignService learningDesignService;
    private static ISecurityService securityService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)false);
        Organisation org = null;
        if (orgId != null) {
            org = (Organisation)this.getService().findById(Organisation.class, (Serializable)orgId);
        }
        if (org != null) {
            User user = this.getUser(request.getRemoteUser());
            if (!this.getSecurityService().hasOrgRole(orgId, user.getUserId(), new String[]{"GROUP MANAGER", "LEARNER", "MONITOR", "AUTHOR"}, "display group", false)) {
                response.sendError(403, "The user is not a part of the organisation");
                return null;
            }
            boolean allowSorting = false;
            ArrayList<Integer> roles = new ArrayList<Integer>();
            List userOrganisationRoles = this.getService().getUserOrganisationRoles(orgId, request.getRemoteUser());
            for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                Integer roleId = userOrganisationRole.getRole().getRoleId();
                roles.add(roleId);
                if (!roleId.equals(Role.ROLE_GROUP_MANAGER) && !roleId.equals(Role.ROLE_MONITOR)) continue;
                allowSorting = true;
            }
            IndexOrgBean iob = this.createOrgBean(org, roles, request.getRemoteUser(), request.isUserInRole("SYSADMIN"));
            request.setAttribute("orgBean", (Object)iob);
            request.setAttribute("allowSorting", (Object)allowSorting);
            iob.setAllowSorting(Boolean.valueOf(allowSorting && iob.getAllowSorting() != false));
            if (org.getEnableSingleActivityLessons().booleanValue() && (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR))) {
                request.setAttribute("tools", (Object)this.getLearningDesignService().getToolDTOs(false, false, request.getRemoteUser()));
            }
            boolean isFavorite = service.isOrganisationFavorite(orgId, user.getUserId());
            iob.setFavorite(isFavorite);
        }
        return mapping.findForward("group");
    }

    private IndexOrgBean createOrgBean(Organisation org, List<Integer> roles, String username, boolean isSysAdmin) throws SQLException, NamingException {
        String link;
        IndexOrgBean orgBean = new IndexOrgBean(org.getOrganisationId(), org.getName(), org.getOrganisationType().getOrganisationTypeId());
        ArrayList<IndexLinkBean> links = new ArrayList<IndexLinkBean>();
        ArrayList<IndexLinkBean> moreLinks = new ArrayList<IndexLinkBean>();
        if (isSysAdmin && orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
            moreLinks.add(new IndexLinkBean("index.classman", "javascript:openOrgManagement(" + org.getOrganisationId() + ")", "fa fa-fw fa-users", null));
        }
        if (org.getEnableGradebookForLearners().booleanValue() && roles.contains(Role.ROLE_LEARNER)) {
            link = "javascript:showGradebookLearnerDialog(" + org.getOrganisationId() + ")";
            links.add(new IndexLinkBean("index.coursegradebook.learner", link, "fa fa-fw fa-list-ol", null));
        }
        if (roles.contains(Role.ROLE_GROUP_ADMIN) || roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR)) {
            String name;
            if (orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
                if (!isSysAdmin && (roles.contains(Role.ROLE_GROUP_ADMIN) || roles.contains(Role.ROLE_GROUP_MANAGER))) {
                    moreLinks.add(new IndexLinkBean("index.classman", "javascript:openOrgManagement(" + org.getOrganisationId() + ")", "fa fa-fw fa-ellipsis-v", null));
                }
                if (roles.contains(Role.ROLE_GROUP_ADMIN) || roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_AUTHOR) || roles.contains(Role.ROLE_MONITOR)) {
                    moreLinks.add(new IndexLinkBean("index.orggroup", "javascript:showOrgGroupingDialog(" + org.getOrganisationId() + ")", "fa fa-fw fa-users", null));
                }
                if (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR)) {
                    name = org.getEnableSingleActivityLessons() != false ? "index.addlesson.single" : "index.addlesson";
                    links.add(new IndexLinkBean(name, "javascript:showAddLessonDialog(" + org.getOrganisationId() + ")", "fa fa-fw fa-plus", null));
                }
                moreLinks.add(new IndexLinkBean("index.searchlesson", "javascript:showSearchLessonDialog(" + org.getOrganisationId() + ")", "fa fa-fw fa-search", "index.searchlesson.tooltip"));
                if (org.getEnableCourseNotifications().booleanValue() && (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR))) {
                    moreLinks.add(new IndexLinkBean("index.emailnotifications", "javascript:showNotificationsDialog(" + org.getOrganisationId() + ",null)", "fa fa-fw fa-bullhorn", "index.emailnotifications.tooltip"));
                }
                if (org.getEnableGradebookForMonitors().booleanValue() && (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_GROUP_ADMIN))) {
                    link = "javascript:showGradebookCourseDialog(" + org.getOrganisationId() + ")";
                    moreLinks.add(new IndexLinkBean("index.coursegradebook", link, "fa fa-fw fa-list-ol", "index.coursegradebook.tooltip"));
                }
            } else {
                if (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR)) {
                    name = org.getParentOrganisation().getEnableSingleActivityLessons() != false ? "index.addlesson.single" : "index.addlesson";
                    links.add(new IndexLinkBean(name, "javascript:showAddLessonDialog(" + org.getOrganisationId() + ")", "fa fa-fw fa-plus", null));
                }
                if (org.getParentOrganisation().getEnableGradebookForMonitors().booleanValue() && (roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_GROUP_ADMIN))) {
                    link = "javascript:showGradebookCourseDialog(" + org.getOrganisationId() + ")";
                    moreLinks.add(new IndexLinkBean("index.coursegradebook.subgroup", link, "fa fa-fw fa-list-ol", null));
                }
            }
        }
        orgBean.setLinks(links);
        orgBean.setMoreLinks(moreLinks);
        orgBean = this.populateContentsOrgBean(orgBean, org, roles, username, isSysAdmin);
        return orgBean;
    }

    private IndexOrgBean populateContentsOrgBean(IndexOrgBean orgBean, Organisation org, List<Integer> roles, String username, boolean isSysAdmin) throws SQLException, NamingException {
        Map<Long, IndexLessonBean> map = this.populateLessonBeans(this.getUser(username).getUserId(), org.getOrganisationId(), roles);
        List<IndexLessonBean> lessonBeans = IndexUtils.sortLessonBeans(org.getOrderedLessonIds(), map);
        orgBean.setLessons(lessonBeans);
        if (!lessonBeans.isEmpty()) {
            orgBean.setAllowSorting(Boolean.valueOf(true));
        }
        if (orgBean.getType().equals(OrganisationType.COURSE_TYPE)) {
            Set children = org.getChildOrganisations();
            ArrayList<IndexOrgBean> childOrgBeans = new ArrayList<IndexOrgBean>();
            for (Organisation organisation : children) {
                if (!OrganisationState.ACTIVE.equals(organisation.getOrganisationState().getOrganisationStateId())) continue;
                ArrayList<Integer> classRoles = new ArrayList<Integer>();
                List userOrganisationRoles = this.getService().getUserOrganisationRoles(organisation.getOrganisationId(), username);
                if ((userOrganisationRoles == null || userOrganisationRoles.isEmpty()) && !isSysAdmin && !roles.contains(Role.ROLE_GROUP_ADMIN) && !roles.contains(Role.ROLE_GROUP_MANAGER)) continue;
                for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                    classRoles.add(userOrganisationRole.getRole().getRoleId());
                }
                if (roles.contains(Role.ROLE_GROUP_MANAGER)) {
                    classRoles.add(Role.ROLE_GROUP_MANAGER);
                }
                IndexOrgBean childOrgBean = this.createOrgBean(organisation, classRoles, username, isSysAdmin);
                childOrgBeans.add(childOrgBean);
                if (childOrgBean.getLessons() == null || childOrgBean.getLessons().isEmpty()) continue;
                orgBean.setAllowSorting(Boolean.valueOf(true));
            }
            Collections.sort(childOrgBeans);
            orgBean.setChildIndexOrgBeans(childOrgBeans);
        }
        return orgBean;
    }

    private Map<Long, IndexLessonBean> populateLessonBeans(Integer userId, Integer orgId, List<Integer> roles) throws SQLException, NamingException {
        Map map = this.getLessonService().getLessonsByOrgAndUserWithCompletedFlag(userId, orgId, Role.ROLE_LEARNER);
        Iterator lessonIter = map.entrySet().iterator();
        while (lessonIter.hasNext()) {
            Map.Entry entry = lessonIter.next();
            if (!((IndexLessonBean)entry.getValue()).isDependent() || lessonService.checkLessonReleaseConditions((Long)entry.getKey(), userId)) continue;
            lessonIter.remove();
        }
        for (IndexLessonBean bean : map.values()) {
            LinkedList lessonLinks = new LinkedList();
            String url = null;
            Integer lessonStateId = bean.getState();
            if (roles.contains(Role.ROLE_LEARNER) && (lessonStateId.equals(Lesson.STARTED_STATE) || lessonStateId.equals(Lesson.FINISHED_STATE))) {
                url = "javascript:openLearner(" + bean.getId() + ")";
            }
            if (lessonLinks.size() <= 0 && url == null) continue;
            bean.setUrl(url);
            bean.setLinks(lessonLinks);
        }
        Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)orgId);
        Organisation parent = org.getParentOrganisation();
        Integer userRole = roles.contains(Role.ROLE_GROUP_MANAGER) ? Role.ROLE_GROUP_MANAGER : Role.ROLE_MONITOR;
        Map staffMap = this.getLessonService().getLessonsByOrgAndUserWithCompletedFlag(userId, orgId, userRole);
        boolean isGroupManagerOrMonitor = roles.contains(Role.ROLE_GROUP_MANAGER) || roles.contains(Role.ROLE_MONITOR);
        for (IndexLessonBean bean : staffMap.values()) {
            LinkedList<IndexLinkBean> lessonLinks;
            if (map.containsKey(bean.getId())) {
                bean = (IndexLessonBean)map.get(bean.getId());
            }
            if ((lessonLinks = (LinkedList<IndexLinkBean>)bean.getLinks()) == null) {
                lessonLinks = new LinkedList<IndexLinkBean>();
            }
            if (isGroupManagerOrMonitor) {
                lessonLinks.addFirst(new IndexLinkBean("index.monitor", "javascript:showMonitorLessonDialog(" + bean.getId() + ")", "fa fa-fw fa-heartbeat", null));
            }
            if (isGroupManagerOrMonitor && bean.isEnableLessonNotifications()) {
                lessonLinks.addFirst(new IndexLinkBean("index.emailnotifications", "javascript:showNotificationsDialog(null," + bean.getId() + ")", "fa fa-fw fa-bullhorn", "index.emailnotifications.tooltip"));
            }
            if (isGroupManagerOrMonitor && (org.getEnableGradebookForMonitors().booleanValue() || parent != null && parent.getEnableGradebookForMonitors().booleanValue())) {
                String link = "javascript:showGradebookLessonDialog(" + bean.getId() + ")";
                lessonLinks.addFirst(new IndexLinkBean("index.coursegradebookmonitor", link, "fa fa-fw fa-check-square-o", null));
            }
            if (isGroupManagerOrMonitor) {
                String conditionsLink = "javascript:showConditionsDialog(" + bean.getId() + ")";
                lessonLinks.addFirst(new IndexLinkBean("index.conditions", conditionsLink, "fa fa-fw fa-code-fork", "index.conditions.tooltip"));
            }
            if (isGroupManagerOrMonitor) {
                String removeLessonLink = "javascript:removeLesson(" + bean.getId() + ")";
                lessonLinks.addFirst(new IndexLinkBean("index.remove.lesson", removeLessonLink, "fa fa-fw fa-trash-o", "index.remove.lesson.tooltip"));
            }
            if (lessonLinks.size() > 0) {
                bean.setLinks(lessonLinks);
            }
            map.put(bean.getId(), bean);
        }
        return map;
    }

    private User getUser(String login) {
        return (User)this.getService().findByProperty(User.class, "login", (Object)login).get(0);
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }

    private LessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (LessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private ILearningDesignService getLearningDesignService() {
        if (learningDesignService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learningDesignService = (ILearningDesignService)ctx.getBean("learningDesignService");
        }
        return learningDesignService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)ctx.getBean("securityService");
        }
        return securityService;
    }
}

