/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JLabel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.WebUtil;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class JlatexmathServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(JlatexmathServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String formulaParam = request.getParameter("formula");
        if (StringUtils.isBlank((String)formulaParam)) {
            return;
        }
        Integer fontSize = WebUtil.readIntParam((HttpServletRequest)request, (String)"fontSize", (boolean)true);
        if (fontSize == null) {
            fontSize = 20;
        }
        TeXFormula formula = null;
        try {
            formula = new TeXFormula(formulaParam);
        }
        catch (ParseException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)e.getMessage());
            }
            return;
        }
        TeXIcon icon = new TeXFormula.TeXIconBuilder(formula).setStyle(0).setSize((float)fontSize.intValue()).setWidth(2, 256.0f, 2).setIsMaxWidth(true).setInterLineSpacing(2, 20.0f).build();
        BufferedImage b = null;
        try {
            b = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        }
        catch (IllegalArgumentException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)e.getMessage());
            }
            return;
        }
        ((Graphics2D)b.getGraphics()).setComposite(AlphaComposite.getInstance(3, 0.5f));
        icon.paintIcon((Component)new JLabel(), b.getGraphics(), 0, 0);
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        ImageIO.write((RenderedImage)b, "png", (OutputStream)out);
        out.close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

