/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LAMSConnectorServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(LAMSConnectorServlet.class);
    private static String baseDir;
    private static boolean debug;
    private String realBaseDir;
    private String lamsContextPath;

    public void init() throws ServletException {
        baseDir = this.getInitParameter("baseDir");
        boolean bl = debug = new Boolean(this.getInitParameter("debug")) != false && log.isDebugEnabled();
        if (baseDir == null) {
            baseDir = "secure";
        }
        this.getConfigKeyValues();
        File baseFile = new File(this.realBaseDir);
        if (!baseFile.exists()) {
            baseFile.mkdir();
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String folderName;
        File folderToDelete;
        if (debug) {
            log.debug((Object)"Browse started");
        }
        this.getConfigKeyValues();
        String commandStr = request.getParameter("Command");
        String typeStr = request.getParameter("Type");
        String currentFolderStr = request.getParameter("CurrentFolder");
        String designFolder = request.getParameter("DesignFolder");
        String currentDirPath = this.realBaseDir + designFolder + typeStr + "/" + currentFolderStr;
        String validCurrentDirPath = currentDirPath.replace('/', File.separatorChar);
        String currentWebPath = this.lamsContextPath + "www/" + "secure" + designFolder + typeStr + "/" + currentFolderStr;
        File currentDir = new File(validCurrentDirPath);
        if (!currentDir.exists()) {
            currentDir.mkdirs();
        }
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e);
        }
        Node root = this.CreateCommonXml(document, commandStr, typeStr, currentFolderStr, currentWebPath);
        if (debug) {
            log.debug((Object)("Command = " + commandStr));
        }
        if (commandStr.equals("GetFolders")) {
            this.getFolders(currentDir, root, document);
        } else if (commandStr.equals("GetFoldersAndFiles")) {
            this.getFolders(currentDir, root, document);
            this.getFiles(currentDir, root, document);
        } else if (commandStr.equals("CreateFolder")) {
            String newFolderStr = request.getParameter("NewFolderName");
            File newFolder = new File(currentDir, newFolderStr);
            String retValue = "110";
            if (newFolder.exists()) {
                retValue = "101";
            } else {
                try {
                    boolean dirCreated = newFolder.mkdir();
                    retValue = dirCreated ? "0" : "102";
                }
                catch (SecurityException sex) {
                    retValue = "103";
                }
            }
            this.setCreateFolderResponse(retValue, root, document);
        } else if (commandStr.equals("DeleteFile")) {
            String fileName = request.getParameter("fileName");
            File fileToDelete = new File(currentDir, fileName);
            if (fileToDelete.isFile()) {
                fileToDelete.delete();
            }
        } else if (commandStr.equals("DeleteFolder") && (folderToDelete = new File(currentDir, folderName = request.getParameter("folderName"))).isDirectory()) {
            folderToDelete.delete();
        }
        document.getDocumentElement().normalize();
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            response.setContentType("text/xml; charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = response.getWriter();
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            out.flush();
            out.close();
            if (debug) {
                StreamResult dbgResult = new StreamResult(System.out);
                transformer.transform(source, dbgResult);
                log.debug((Object)"Browse finished");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (debug) {
            log.debug((Object)"Upload started");
        }
        String commandStr = request.getParameter("Command");
        String fileType = request.getParameter("Type");
        String currentFolderStr = request.getParameter("CurrentFolder");
        String designFolder = request.getParameter("DesignFolder");
        String currentDirPath = this.realBaseDir + designFolder + fileType + "/" + currentFolderStr;
        String validCurrentDirPath = currentDirPath.replace("/", File.separator);
        if (debug) {
            log.debug((Object)currentDirPath);
        }
        StringBuilder retVal = new StringBuilder();
        String newName = null;
        try {
            if (commandStr.equals("PaintUpload")) {
                newName = this.createNewPaint(validCurrentDirPath, request, retVal);
            } else {
                if (!commandStr.equals("FileUpload") || currentFolderStr.equals("/-1/")) {
                    throw new Exception("Illegal command.");
                }
                newName = this.createNewFile(validCurrentDirPath, request, retVal, fileType);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            retVal = new StringBuilder("203");
        }
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        PrintWriter out = response.getWriter();
        if (!commandStr.equals("PaintUpload")) {
            out.println("<script type=\"text/javascript\">");
            out.println("window.parent.frames['frmUpload'].OnUploadCompleted(" + retVal + ",'" + newName + "');");
            out.println("</script>");
        } else {
            String currentWebPath = this.lamsContextPath + "www/" + "secure" + designFolder + fileType + "/" + currentFolderStr;
            out.println(currentWebPath + newName);
        }
        out.flush();
        out.close();
        if (debug) {
            log.debug((Object)"Upload finished");
        }
    }

    private String createNewFile(String validCurrentDirPath, HttpServletRequest request, StringBuilder retVal, String fileType) throws FileUploadException, IOException, Exception {
        if (debug) {
            log.debug((Object)"File save started");
        }
        String newName = "";
        DiskFileUpload upload = new DiskFileUpload();
        List items = upload.parseRequest(request);
        HashMap<String, String> fields = new HashMap<String, String>();
        for (FileItem item : items) {
            if (item.isFormField()) {
                fields.put(item.getFieldName(), item.getString());
                continue;
            }
            fields.put(item.getFieldName(), (String)item);
        }
        FileItem uplFile = (FileItem)fields.get("NewFile");
        String fileNameLong = uplFile.getName();
        String[] pathParts = (fileNameLong = fileNameLong.replace('\\', '/')).split("/");
        String fileName = pathParts[pathParts.length - 1];
        if (FileUtil.isExtensionAllowed((String)fileType, (String)fileName)) {
            File pathToSave = new File(validCurrentDirPath, fileName);
            int counter = 1;
            while (pathToSave.exists()) {
                String ext = this.getExtension(fileName);
                String nameWithoutExt = LAMSConnectorServlet.getNameWithoutExtension(fileName);
                fileName = nameWithoutExt + "_" + counter + "." + ext;
                pathToSave = new File(validCurrentDirPath, fileName);
                ++counter;
            }
            uplFile.write(pathToSave);
            if (counter > 1) {
                retVal.append("201");
            } else {
                retVal.append("0");
            }
            if (debug) {
                log.debug((Object)"File save finished");
            }
        } else {
            if (debug) {
                log.debug((Object)("File extension is prohibited for upload " + fileName));
            }
            retVal.append("204");
        }
        return fileName;
    }

    private String createNewPaint(String validCurrentDirPath, HttpServletRequest request, StringBuilder retVal) throws IOException {
        if (debug) {
            log.debug((Object)"Paint save started");
        }
        String extension = "png";
        String nameWithoutExt = this.getUserID() + "_" + String.valueOf(new Date().getTime());
        String fileName = nameWithoutExt + "." + extension;
        File dir = new File(validCurrentDirPath);
        File pathToSave = new File(validCurrentDirPath, fileName);
        int counter = 1;
        while (pathToSave.exists()) {
            fileName = nameWithoutExt + "_" + counter + "." + extension;
            pathToSave = new File(validCurrentDirPath, fileName);
            ++counter;
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ServletInputStream is = request.getInputStream();
        FileOutputStream fileos = new FileOutputStream(pathToSave);
        byte[] bs = IOUtils.toByteArray((InputStream)is);
        fileos.write(bs);
        fileos.flush();
        fileos.close();
        if (counter > 1) {
            retVal.append("201");
        } else {
            retVal.append("0");
        }
        if (debug) {
            log.debug((Object)"Paint save finished");
        }
        return fileName;
    }

    private void setCreateFolderResponse(String retValue, Node root, Document doc) {
        Element myEl = doc.createElement("Error");
        myEl.setAttribute("number", retValue);
        root.appendChild(myEl);
    }

    private void getFolders(File dir, Node root, Document doc) {
        Element folders = doc.createElement("Folders");
        root.appendChild(folders);
        File[] fileList = dir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].isDirectory()) continue;
            Element myEl = doc.createElement("Folder");
            myEl.setAttribute("name", fileList[i].getName());
            folders.appendChild(myEl);
        }
    }

    private void getFiles(File dir, Node root, Document doc) {
        Element files = doc.createElement("Files");
        root.appendChild(files);
        File[] fileList = dir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            if (!fileList[i].isFile()) continue;
            Element myEl = doc.createElement("File");
            myEl.setAttribute("name", fileList[i].getName());
            myEl.setAttribute("size", "" + fileList[i].length() / 1024L);
            files.appendChild(myEl);
        }
    }

    private Node CreateCommonXml(Document doc, String commandStr, String typeStr, String currentPath, String currentUrl) {
        Element root = doc.createElement("Connector");
        doc.appendChild(root);
        root.setAttribute("command", commandStr);
        root.setAttribute("resourceType", typeStr);
        Element myEl = doc.createElement("CurrentFolder");
        myEl.setAttribute("path", currentPath);
        myEl.setAttribute("url", currentUrl);
        root.appendChild(myEl);
        return root;
    }

    private static String getNameWithoutExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    private String getExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    private void getConfigKeyValues() {
        this.realBaseDir = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR) + File.separator + "lams-www.war" + File.separator + baseDir;
        this.lamsContextPath = "/" + Configuration.get((String)ConfigurationKeys.SERVER_URL_CONTEXT_PATH) + "/";
    }

    private String getUserID() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID().toString() : "";
    }

    static {
        debug = false;
    }
}

