/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.UploadFileUtil;

public class LAMSUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 7839808388592495717L;
    private static final Logger log = Logger.getLogger(LAMSUploadServlet.class);

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ckeditorSetUrlFuncNum;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Upload started");
        }
        String currentFolderStr = request.getParameter("CurrentFolder");
        String newName = null;
        String fileUrl = null;
        String returnMessage = null;
        if (currentFolderStr.equals("/-1/")) {
            returnMessage = "Security error. You probably don't have enough permissions to upload. Please check your server.";
        } else {
            String fileType = request.getParameter("Type");
            DiskFileUpload upload = new DiskFileUpload();
            try {
                List items = upload.parseRequest(request);
                HashMap<String, String> fields = new HashMap<String, String>();
                for (FileItem item : items) {
                    if (item.isFormField()) {
                        fields.put(item.getFieldName(), item.getString());
                        continue;
                    }
                    fields.put(item.getFieldName(), (String)item);
                }
                FileItem uplFile = (FileItem)fields.get("NewFile");
                if (uplFile == null) {
                    uplFile = (FileItem)fields.get("upload");
                }
                String fileNameLong = uplFile.getName();
                String[] pathParts = (fileNameLong = fileNameLong.replace('\\', '/')).split("/");
                String fileName = pathParts[pathParts.length - 1];
                if (FileUtil.isExtensionAllowed((String)fileType, (String)fileName)) {
                    File uploadDir = UploadFileUtil.getUploadDir((String)currentFolderStr, (String)fileType);
                    newName = fileName = UploadFileUtil.getUploadFileName((File)uploadDir, (String)fileName);
                    File destinationFile = new File(uploadDir, fileName);
                    String currentWebPath = UploadFileUtil.getUploadWebPath((String)currentFolderStr, (String)fileType);
                    fileUrl = currentWebPath + '/' + fileName;
                    uplFile.write(destinationFile);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Uploaded file to " + destinationFile.getAbsolutePath()));
                    }
                } else {
                    returnMessage = "Invalid file type";
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                returnMessage = "Error while uploading file";
            }
        }
        if (returnMessage == null) {
            returnMessage = "File successfully uploaded: " + newName;
        }
        if ((ckeditorSetUrlFuncNum = request.getParameter("CKEditorFuncNum")) != null) {
            response.setContentType("text/html; charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            PrintWriter out = response.getWriter();
            out.println("<script type=\"text/javascript\">");
            out.println("this.parent.CKEDITOR.tools.callFunction(" + ckeditorSetUrlFuncNum + ",'" + fileUrl + "','" + returnMessage + "');");
            out.println("</script>");
            out.flush();
            out.close();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No CKEditor method found to run after completion, but upload finished with message: " + returnMessage));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Upload finished");
        }
    }
}

