/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LaunchLearnerUrlServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(LaunchLearnerUrlServlet.class);
    private static ILessonService lessonService;

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Lesson lesson;
        Long lessonId;
        String encodedLessonId = request.getPathInfo();
        if (StringUtils.isBlank((String)encodedLessonId) || encodedLessonId.length() < 2) {
            String lamsUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL);
            response.sendRedirect(lamsUrl);
            return;
        }
        encodedLessonId = encodedLessonId.substring(1);
        try {
            String decodedLessonId = WebUtil.decodeLessonId((String)encodedLessonId);
            lessonId = Long.valueOf(decodedLessonId);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Supplied lessonId: " + encodedLessonId + " has wrong format."));
            response.sendError(400, "Supplied lessonId: " + encodedLessonId + " has wrong format.");
            return;
        }
        Lesson lesson2 = lesson = lessonId != null ? this.getLessonService().getLesson(lessonId) : null;
        if (lesson != null) {
            // empty if block
        }
        request.setAttribute("name", (Object)lesson.getLessonName());
        request.setAttribute("description", (Object)lesson.getLessonDescription());
        request.setAttribute("status", (Object)lesson.getLessonStateId());
        request.setAttribute("lessonID", (Object)lessonId);
        request.getRequestDispatcher("/launchlearner.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private void displayMessage(HttpServletRequest request, HttpServletResponse response, String messageKey) throws ServletException, IOException {
        request.setAttribute("messageKey", (Object)messageKey);
        request.getRequestDispatcher("/.message").forward((ServletRequest)request, (ServletResponse)response);
    }
}

