/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.index.IndexLessonBean;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.GroupUser;
import org.lamsfoundation.lams.learningdesign.dao.IGroupUserDAO;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.lesson.util.LessonComparator;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LessonConditionsAction
extends DispatchAction {
    private static final Logger logger = Logger.getLogger(LessonConditionsAction.class);
    private static final String FORWARD_INDEX_LESSON_CONDITION = "indexLessonConditions";
    private static final String PARAM_PRECEDING_LESSONS = "precedingLessons";
    private static final String PARAM_PRECEDING_LESSON_ID = "precedingLessonId";
    private static final String PARAM_AVAILABLE_LESSONS = "availableLessons";
    private static final String PARAM_LESSON_START_DATE = "lessonStartDate";
    private static final String PARAM_LESSON_DAYS_TO_FINISH = "lessonDaysToFinish";
    private static final String PARAM_INDIVIDUAL_FINISH = "lessonIndividualFinish";
    private static ILessonService lessonService;
    private static IMonitoringService monitoringService;
    private static IGroupUserDAO groupUserDAO;
    private static ISecurityService securityService;

    public ActionForward getIndexLessonConditions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lsId", (boolean)false);
        if (!this.getSecurityService().isLessonMonitor(lessonId, this.getUser().getUserID(), "show lesson conditions", false)) {
            response.sendError(403, "User is not a monitor in the lesson");
            return null;
        }
        Lesson lesson = this.getLessonService().getLesson(lessonId);
        ArrayList<IndexLessonBean> precedingLessons = new ArrayList<IndexLessonBean>(lesson.getPrecedingLessons().size());
        for (Lesson precedingLesson : lesson.getPrecedingLessons()) {
            IndexLessonBean precedingLessonBean = new IndexLessonBean(precedingLesson.getLessonId(), precedingLesson.getLessonName());
            precedingLessons.add(precedingLessonBean);
        }
        request.setAttribute("lsId", (Object)lesson.getLessonId());
        request.setAttribute("title", (Object)lesson.getLessonName());
        request.setAttribute(PARAM_PRECEDING_LESSONS, precedingLessons);
        TreeSet organisationLessons = new TreeSet(new LessonComparator());
        organisationLessons.addAll(lesson.getOrganisation().getLessons());
        ArrayList<IndexLessonBean> availableLessons = new ArrayList<IndexLessonBean>(organisationLessons.size());
        for (Lesson organisationLesson : organisationLessons) {
            if (lessonId.equals(organisationLesson.getLessonId()) || lesson.getPrecedingLessons().contains(organisationLesson) || Lesson.REMOVED_STATE.equals(organisationLesson.getLessonStateId()) || Lesson.FINISHED_STATE.equals(organisationLesson.getLessonStateId())) continue;
            IndexLessonBean availableLessonBean = new IndexLessonBean(organisationLesson.getLessonId(), organisationLesson.getLessonName());
            availableLessons.add(availableLessonBean);
        }
        request.setAttribute(PARAM_AVAILABLE_LESSONS, availableLessons);
        Date endDate = lesson.getScheduleEndDate();
        if (endDate == null) {
            Integer daysToLessonFinish = lesson.getScheduledNumberDaysToLessonFinish();
            if (daysToLessonFinish != null) {
                request.setAttribute(PARAM_LESSON_DAYS_TO_FINISH, (Object)daysToLessonFinish);
                request.setAttribute(PARAM_INDIVIDUAL_FINISH, (Object)true);
            }
        } else {
            Date startDate = lesson.getStartDateTime() == null ? lesson.getScheduleStartDate() : lesson.getStartDateTime();
            long daysToLessonFinish = Duration.between(startDate.toInstant(), endDate.toInstant()).toDays();
            request.setAttribute(PARAM_LESSON_START_DATE, (Object)startDate);
            request.setAttribute(PARAM_LESSON_DAYS_TO_FINISH, (Object)daysToLessonFinish);
            request.setAttribute(PARAM_INDIVIDUAL_FINISH, (Object)false);
        }
        request.setAttribute("edit", (Object)lesson.getUser().getUserId().equals(this.getUser().getUserID()));
        return mapping.findForward(FORWARD_INDEX_LESSON_CONDITION);
    }

    public ActionForward removeLessonDependency(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lsId", (boolean)false);
        if (!this.getSecurityService().isLessonOwner(lessonId, this.getUser().getUserID(), "remove lesson dependency", false)) {
            response.sendError(403, "User is not the owner of the lesson");
            return null;
        }
        Long removedPrecedingLessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_PRECEDING_LESSON_ID, (boolean)false);
        Lesson lesson = this.getLessonService().getLesson(lessonId);
        Iterator precedingLessonIter = lesson.getPrecedingLessons().iterator();
        while (precedingLessonIter.hasNext()) {
            if (!((Lesson)precedingLessonIter.next()).getLessonId().equals(removedPrecedingLessonId)) continue;
            precedingLessonIter.remove();
            break;
        }
        return this.getIndexLessonConditions(mapping, form, request, response);
    }

    public ActionForward addLessonDependency(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lsId", (boolean)false);
        if (!this.getSecurityService().isLessonOwner(lessonId, this.getUser().getUserID(), "add lesson dependency", false)) {
            response.sendError(403, "User is not the owner of the lesson");
            return null;
        }
        Long addedPrecedingLessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_PRECEDING_LESSON_ID, (boolean)false);
        Lesson lesson = this.getLessonService().getLesson(lessonId);
        Lesson addedPrecedingLesson = this.getLessonService().getLesson(addedPrecedingLessonId);
        if (addedPrecedingLesson == null) {
            throw new IllegalArgumentException("Preceding lesson with ID: " + lessonId + " does not exist.");
        }
        lesson.getPrecedingLessons().add(addedPrecedingLesson);
        return this.getIndexLessonConditions(mapping, form, request, response);
    }

    public ActionForward setDaysToLessonFinish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)request, (String)"lsId", (boolean)false);
        if (!this.getSecurityService().isLessonOwner(lessonId, this.getUser().getUserID(), "set days to lesson finish", false)) {
            response.sendError(403, "User is not the owner of the lesson");
            return null;
        }
        int daysToLessonFinish = WebUtil.readIntParam((HttpServletRequest)request, (String)PARAM_LESSON_DAYS_TO_FINISH, (boolean)false);
        boolean individualFinish = WebUtil.readBooleanParam((HttpServletRequest)request, (String)PARAM_INDIVIDUAL_FINISH, (boolean)false);
        ActionMessages errors = new ActionMessages();
        Lesson lesson = this.getLessonService().getLesson(lessonId);
        HttpSession session = SessionManager.getSession();
        UserDTO currentUser = (UserDTO)session.getAttribute("user");
        try {
            this.getMonitoringService().finishLessonOnSchedule(lessonId.longValue(), individualFinish ? 0 : daysToLessonFinish, currentUser.getUserID());
            lesson.setScheduledNumberDaysToLessonFinish(individualFinish && daysToLessonFinish > 0 ? Integer.valueOf(daysToLessonFinish) : null);
            Group learnerGroup = lesson.getLessonClass().getLearnersGroup();
            if (learnerGroup != null) {
                for (User learner : learnerGroup.getUsers()) {
                    GroupUser groupUser = this.getGroupUserDAO().getGroupUser(lesson, learner.getUserId());
                    if (groupUser == null) continue;
                    if (individualFinish && daysToLessonFinish > 0) {
                        LearnerProgress learnerProgress = this.getLessonService().getUserProgressForLesson(learner.getUserId(), lessonId);
                        if (learnerProgress == null || learnerProgress.getStartDate() == null) {
                            if (groupUser.getScheduledLessonEndDate() == null) continue;
                            logger.warn((Object)("Improper DB value: User with ID " + learner.getUserId() + " has scheduledLessonEndDate set but has not started the lesson yet."));
                            continue;
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(learnerProgress.getStartDate());
                        calendar.add(5, daysToLessonFinish);
                        Date endDate = calendar.getTime();
                        groupUser.setScheduledLessonEndDate(endDate);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Reset time limit for user: " + learner.getLogin() + " in lesson: " + lesson.getLessonId() + " to " + endDate));
                        continue;
                    }
                    if (groupUser.getScheduledLessonEndDate() == null) continue;
                    groupUser.setScheduledLessonEndDate(null);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Remove time limit for user: " + learner.getLogin() + " in lesson: " + lesson.getLessonId()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.conditions.box.finish.date", new Object[]{e.getMessage()}));
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
        }
        return this.getIndexLessonConditions(mapping, form, request, response);
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private IMonitoringService getMonitoringService() {
        if (monitoringService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            monitoringService = (IMonitoringService)ctx.getBean("monitoringService");
        }
        return monitoringService;
    }

    private ISecurityService getSecurityService() {
        if (securityService == null) {
            WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            securityService = (ISecurityService)webContext.getBean("securityService");
        }
        return securityService;
    }

    private IGroupUserDAO getGroupUserDAO() {
        if (groupUserDAO == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            groupUserDAO = (IGroupUserDAO)ctx.getBean("groupUserDAO");
        }
        return groupUserDAO;
    }
}

