/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LessonOrderServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(LessonOrderServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Organisation org;
        response.setContentType("text/html;charset=utf-8");
        Integer orgId = WebUtil.readIntParam((HttpServletRequest)request, (String)"orgId", (boolean)false);
        String ids = request.getParameter("ids");
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        UserManagementService service = (UserManagementService)ctx.getBean("userManagementService");
        if (orgId != null && ids != null && (org = (Organisation)service.findById(Organisation.class, (Serializable)orgId)) != null) {
            boolean allowSorting = false;
            ArrayList<Integer> roles = new ArrayList<Integer>();
            List userOrganisationRoles = service.getUserOrganisationRoles(orgId, request.getRemoteUser());
            for (UserOrganisationRole userOrganisationRole : userOrganisationRoles) {
                Integer roleId = userOrganisationRole.getRole().getRoleId();
                roles.add(roleId);
                if (!roleId.equals(Role.ROLE_GROUP_MANAGER) && !roleId.equals(Role.ROLE_MONITOR)) continue;
                allowSorting = true;
                break;
            }
            if (!allowSorting) {
                log.warn((Object)("User " + request.getRemoteUser() + " tried to sort lessons in orgId " + orgId));
                response.sendError(403);
                return;
            }
            List<String> idList = Arrays.asList(ids.split(","));
            List lessons = service.findByProperty(Lesson.class, "organisation", (Object)org);
            for (String id : idList) {
                try {
                    Long l = new Long(Long.parseLong(id));
                    if (this.contains(lessons, l)) continue;
                    log.warn((Object)("Lesson with id " + l + " doesn't belong in org with id " + orgId));
                    response.sendError(400);
                    return;
                }
                catch (NumberFormatException e) {
                }
            }
            String oldIds = org.getOrderedLessonIds();
            String updatedIds = this.mergeLessonIds(oldIds != null ? oldIds : "", ids);
            org.setOrderedLessonIds(updatedIds);
            service.save((Object)org);
        }
    }

    private boolean contains(List lessons, Long id) {
        if (lessons != null) {
            for (Lesson lesson : lessons) {
                if (!lesson.getLessonId().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    private String mergeLessonIds(String old, String updated) {
        List<String> oldIds = Arrays.asList(old.split(","));
        List<String> updatedIds = Arrays.asList(updated.split(","));
        ArrayList<String> mergedIds = new ArrayList<String>(updatedIds);
        for (int i = 0; i < oldIds.size(); ++i) {
            String current = oldIds.get(i);
            if (updatedIds.contains(current)) continue;
            int indexNextExistingId = this.indexNextExistingId(i, oldIds, mergedIds);
            if (indexNextExistingId < 0) {
                mergedIds.add(current);
                continue;
            }
            mergedIds.add(indexNextExistingId, current);
        }
        return this.joinString(mergedIds);
    }

    private int indexNextExistingId(int i, List<String> oldIds, List<String> updatedIds) {
        for (int j = i; j < oldIds.size(); ++j) {
            String current = oldIds.get(j);
            int index = updatedIds.indexOf(current);
            if (index <= -1) continue;
            return index;
        }
        return -1;
    }

    private String joinString(List<String> list) {
        String s = "";
        if (list != null) {
            for (String i : list) {
                s = s + i + ",";
            }
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

