/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.integration.security.RandomPasswordGenerator;
import org.lamsfoundation.lams.security.UniversalLoginModule;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoginAsAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        IUserManagementService service = (IUserManagementService)ctx.getBean("userManagementService");
        MessageService messageService = (MessageService)ctx.getBean("centralMessageService");
        String login = WebUtil.readStrParam((HttpServletRequest)request, (String)"login", (boolean)false);
        if (service.isUserSysAdmin()) {
            User user;
            if (login != null && login.trim().length() > 0 && (user = service.getUserByLogin(login)) != null) {
                UserDTO sysadmin = (UserDTO)SessionManager.getSession().getAttribute("user");
                IAuditService auditService = (IAuditService)ctx.getBean("auditService");
                Object[] args = new String[]{sysadmin.getLogin() + "(" + sysadmin.getUserID() + ")", login};
                String message = messageService.getMessage("audit.admin.loginas", args);
                auditService.log("central", message);
                request.setAttribute("login", (Object)login);
                String token = "#LAMS" + RandomPasswordGenerator.nextPassword((int)10);
                request.setAttribute("password", (Object)token);
                UniversalLoginModule.setAuthenticationToken(token);
                return new ActionForward("/login.jsp?redirectURL=/lams/index.jsp");
            }
        } else {
            request.setAttribute("errorName", (Object)"LoginAsAction");
            request.setAttribute("errorMessage", (Object)messageService.getMessage("error.authorisation"));
            return mapping.findForward("error");
        }
        return mapping.findForward("usersearch");
    }
}

