/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.security.RandomPasswordGenerator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.integration.util.LoginRequestDispatcher;
import org.lamsfoundation.lams.security.UniversalLoginModule;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LoginRequestServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(LoginRequestServlet.class);
    private static IntegrationService integrationService = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession hses = request.getSession(true);
        String extUsername = request.getParameter("uid");
        String serverId = request.getParameter("sid");
        String extCourseId = request.getParameter("courseid");
        String timestamp = request.getParameter("ts");
        String hash = request.getParameter("hash");
        String method = request.getParameter("method");
        String countryIsoCode = request.getParameter("country");
        String langIsoCode = request.getParameter("lang");
        String courseName = request.getParameter("courseName");
        String usePrefix = request.getParameter("usePrefix");
        boolean isUpdateUserDetails = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"isUpdateUserDetails", (boolean)false);
        String firstName = request.getParameter("firstName");
        String lastName = request.getParameter("lastName");
        String email = request.getParameter("email");
        if (extUsername == null || method == null || serverId == null || timestamp == null || hash == null) {
            response.sendError(400, "Login Failed - login parameters missing");
            return;
        }
        if (request.getCharacterEncoding() == null) {
            log.debug((Object)"request.getCharacterEncoding is empty, parsing username and courseName as 8859_1 to UTF-8...");
            extUsername = new String(extUsername.getBytes("8859_1"), "UTF-8");
            if (courseName != null) {
                courseName = new String(courseName.getBytes("8859_1"), "UTF-8");
            }
        }
        ExtServer extServer = this.getIntegrationService().getExtServer(serverId);
        boolean prefix = usePrefix == null ? true : Boolean.parseBoolean(usePrefix);
        try {
            String role;
            ExtUserUseridMap userMap = null;
            userMap = firstName == null && lastName == null ? this.getIntegrationService().getExtUserUseridMap(extServer, extUsername, prefix) : this.getIntegrationService().getImplicitExtUserUseridMap(extServer, extUsername, firstName, lastName, langIsoCode, countryIsoCode, email, prefix, isUpdateUserDetails);
            String lsId = request.getParameter("lsid");
            if (("learnerStrictAuth".equals(method) || "monitor".equals(method)) && lsId == null) {
                response.sendError(400, "Login Failed - lsId parameter missing");
                return;
            }
            Authenticator.authenticateLoginRequest((ExtServer)extServer, (String)timestamp, (String)extUsername, (String)method, (String)lsId, (String)hash);
            if (extCourseId == null && lsId != null) {
                ExtCourseClassMap classMap = integrationService.getExtCourseClassMap(extServer.getSid(), Long.valueOf(Long.parseLong(lsId)));
                if (classMap == null) {
                    log.warn((Object)("Lesson " + lsId + " is not mapped to any course for server " + extServer.getServername()));
                } else {
                    extCourseId = classMap.getCourseid();
                }
            }
            if (extCourseId != null) {
                this.getIntegrationService().getExtCourseClassMap(extServer, userMap, extCourseId, countryIsoCode, langIsoCode, courseName, method, Boolean.valueOf(prefix));
            }
            User user = userMap.getUser();
            String login = user.getLogin();
            UserDTO loggedInUserDTO = (UserDTO)hses.getAttribute("user");
            String loggedInLogin = loggedInUserDTO == null ? null : loggedInUserDTO.getLogin();
            String string = role = method.equals("learnerStrictAuth") ? "learner" : method;
            if (loggedInLogin != null && loggedInLogin.equals(login) && request.isUserInRole(role)) {
                String url = LoginRequestDispatcher.getRequestURL((HttpServletRequest)request);
                response.sendRedirect(response.encodeRedirectURL(url));
                return;
            }
            String redirectURL = WebUtil.getBaseServerURL() + LoginRequestDispatcher.getRequestURL((HttpServletRequest)request);
            redirectURL = URLEncoder.encode(redirectURL, "UTF-8");
            hses.setAttribute("login", (Object)login);
            String token = "#LAMS" + RandomPasswordGenerator.nextPassword((int)10);
            hses.setAttribute("password", (Object)token);
            UniversalLoginModule.setAuthenticationToken(token);
            response.sendRedirect("login.jsp?redirectURL=" + redirectURL);
        }
        catch (AuthenticationException e) {
            log.error((Object)"Authentication error: ", (Throwable)e);
            response.sendError(401, "Login Failed - authentication error. " + e.getMessage());
        }
        catch (UserInfoFetchException e) {
            log.error((Object)"User fetch info error: ", (Throwable)e);
            response.sendError(502, "Login Failed - failed to fetch user info from the third party server");
        }
        catch (UserInfoValidationException e) {
            log.error((Object)"User validation error: ", (Throwable)e);
            response.sendError(400, e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private IntegrationService getIntegrationService() {
        if (integrationService == null) {
            integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        }
        return integrationService;
    }
}

