/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.CentralToolContentHandler;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.PortraitUtils;
import org.lamsfoundation.lams.web.PortraitActionForm;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortraitSaveAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(PortraitSaveAction.class);
    private static IUserManagementService service;
    private static CentralToolContentHandler centralToolContentHandler;
    private static int LARGEST_DIMENSION;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            return mapping.findForward("profile");
        }
        ActionMessages errors = new ActionMessages();
        PortraitActionForm portraitForm = (PortraitActionForm)form;
        FormFile file = portraitForm.getFile();
        String fileName = file.getFileName();
        log.debug((Object)("got file: " + fileName + " of type: " + file.getContentType() + " with size: " + file.getFileSize()));
        User user = this.getService().getUserByLogin(request.getRemoteUser());
        String mediaType = file.getContentType().split("/", 2)[0];
        if (!mediaType.equals("image")) {
            errors.add("file", new ActionMessage("error.portrait.not.image"));
            this.saveErrors(request, errors);
            return mapping.findForward("errors");
        }
        InputStream is = PortraitUtils.resizePicture(file.getInputStream(), LARGEST_DIMENSION);
        if (is == null) {
            errors.add("file", new ActionMessage("error.general.1"));
            this.saveErrors(request, errors);
            return mapping.findForward("errors");
        }
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)fileName)) {
            try {
                fileName = fileName.substring(0, fileName.indexOf(46)) + ".jpg";
                node = this.getCentralToolContentHandler().uploadFile(is, fileName, file.getContentType());
                is.close();
            }
            catch (Exception e) {
                request.setAttribute("errorMessage", (Object)e.getMessage());
                return mapping.findForward("error.system");
            }
        }
        log.debug((Object)("saved file with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
        if (user.getPortraitUuid() != null) {
            this.getCentralToolContentHandler().deleteFile(user.getPortraitUuid());
        }
        user.setPortraitUuid(node.getUuid());
        this.getService().saveUser(user);
        return mapping.findForward("profile");
    }

    public ActionForward saveWebcamPortrait(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = (UserDTO)ss.getAttribute("user");
        User user = this.getService().getUserByLogin(request.getRemoteUser());
        if (userDTO == null || user == null) {
            throw new UserAccessDeniedException("User hasn't been logged in");
        }
        String mediaType = request.getContentType().split("/", 2)[0];
        if (!mediaType.equals("image")) {
            throw new FileUtilException("The file is not an image.");
        }
        ServletInputStream is = request.getInputStream();
        if (is == null) {
            throw new FileUtilException("Sorry, there has been an error.");
        }
        String fileName = user.getFullName() + " portrait.jpg";
        NodeKey node = this.getCentralToolContentHandler().uploadFile((InputStream)is, fileName, "image/jpeg");
        is.close();
        log.debug((Object)("saved file with uuid: " + node.getUuid() + " and version: " + node.getVersion()));
        if (user.getPortraitUuid() != null) {
            this.getCentralToolContentHandler().deleteFile(user.getPortraitUuid());
        }
        user.setPortraitUuid(node.getUuid());
        this.getService().saveUser(user);
        return null;
    }

    private CentralToolContentHandler getCentralToolContentHandler() {
        if (centralToolContentHandler == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            centralToolContentHandler = (CentralToolContentHandler)((Object)wac.getBean("centralToolContentHandler"));
        }
        return centralToolContentHandler;
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }

    static {
        LARGEST_DIMENSION = 120;
    }
}

