/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.index.IndexLessonBean;
import org.lamsfoundation.lams.index.IndexOrgBean;
import org.lamsfoundation.lams.learning.service.ICoreLearnerService;
import org.lamsfoundation.lams.lesson.dto.LessonDTO;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.themes.service.IThemeService;
import org.lamsfoundation.lams.timezone.Timezone;
import org.lamsfoundation.lams.timezone.dto.TimezoneDTO;
import org.lamsfoundation.lams.timezone.service.ITimezoneService;
import org.lamsfoundation.lams.timezone.util.TimezoneDTOComparator;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.IndexUtils;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ProfileAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(ProfileAction.class);
    private static IUserManagementService service;
    private static List<SupportedLocale> locales;
    private static ICoreLearnerService learnerService;
    private static IThemeService themeService;
    private static ITimezoneService timezoneService;

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User requestor = this.getService().getUserByLogin(request.getRemoteUser());
        String fullName = (requestor.getTitle() != null ? requestor.getTitle() + " " : "") + requestor.getFirstName() + " " + requestor.getLastName();
        String email = requestor.getEmail();
        request.setAttribute("fullName", (Object)fullName);
        request.setAttribute("email", (Object)(email != null ? email : ""));
        request.setAttribute("portraitUuid", (Object)requestor.getPortraitUuid());
        return mapping.findForward("view");
    }

    public ActionForward lessons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User requestor = this.getService().getUserByLogin(request.getRemoteUser());
        LessonDTO[] lessons = this.getLearnerService().getActiveLessonsFor(requestor.getUserId());
        HashMap<Integer, IndexOrgBean> orgBeansMap = new HashMap<Integer, IndexOrgBean>();
        for (LessonDTO lesson : lessons) {
            Integer orgId = lesson.getOrganisationID();
            Organisation org = (Organisation)this.getService().findById(Organisation.class, (Serializable)orgId);
            Integer orgTypeId = org.getOrganisationType().getOrganisationTypeId();
            IndexLessonBean lessonBean = new IndexLessonBean(lesson.getLessonName(), "javascript:openLearner(" + lesson.getLessonID() + ")");
            lessonBean.setId(lesson.getLessonID());
            log.debug((Object)("Lesson: " + lesson.getLessonName()));
            if (orgTypeId.equals(OrganisationType.COURSE_TYPE)) {
                IndexOrgBean orgBean = !orgBeansMap.containsKey(orgId) ? new IndexOrgBean(org.getOrganisationId(), org.getName(), orgTypeId) : (IndexOrgBean)orgBeansMap.get(orgId);
                orgBean.addLesson(lessonBean);
                orgBeansMap.put(orgId, orgBean);
                continue;
            }
            if (!orgTypeId.equals(OrganisationType.CLASS_TYPE)) continue;
            Organisation parentOrg = org.getParentOrganisation();
            Integer parentOrgId = parentOrg.getOrganisationId();
            IndexOrgBean parentOrgBean = !orgBeansMap.containsKey(parentOrgId) ? new IndexOrgBean(parentOrg.getOrganisationId(), parentOrg.getName(), OrganisationType.COURSE_TYPE) : (IndexOrgBean)orgBeansMap.get(parentOrgId);
            IndexOrgBean orgBean = new IndexOrgBean(org.getOrganisationId(), org.getName(), orgTypeId);
            List childOrgBeans = parentOrgBean.getChildIndexOrgBeans();
            if (childOrgBeans.contains(orgBean)) {
                orgBean = this.getOrgBean(org.getName(), childOrgBeans);
                childOrgBeans.remove(orgBean);
                orgBean.addLesson(lessonBean);
                childOrgBeans.add(orgBean);
                parentOrgBean.setChildIndexOrgBeans(childOrgBeans);
            } else {
                orgBean.addLesson(lessonBean);
                parentOrgBean.addChildOrgBean(orgBean);
            }
            orgBeansMap.put(parentOrgId, parentOrgBean);
        }
        ArrayList beans = new ArrayList(orgBeansMap.values());
        Collections.sort(beans);
        for (IndexOrgBean b : beans) {
            Collections.sort(b.getChildIndexOrgBeans());
        }
        for (Object o : beans) {
            IndexOrgBean bean = (IndexOrgBean)o;
            Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)bean.getId());
            HashMap<Long, IndexLessonBean> map = new HashMap<Long, IndexLessonBean>();
            for (IndexLessonBean lbean : bean.getLessons()) {
                map.put(lbean.getId(), lbean);
            }
            bean.setLessons(IndexUtils.sortLessonBeans(org.getOrderedLessonIds(), map));
        }
        request.setAttribute("beans", beans);
        return mapping.findForward("lessons");
    }

    private IndexOrgBean getOrgBean(String name, List<IndexOrgBean> list) {
        for (IndexOrgBean bean : list) {
            if (!StringUtils.equals((String)name, (String)bean.getName())) continue;
            return bean;
        }
        return null;
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionMessages errors = (ActionMessages)request.getAttribute("org.apache.struts.action.ERROR");
        if (errors == null) {
            errors = new ActionMessages();
        }
        if (!Configuration.getAsBoolean((String)ConfigurationKeys.PROFILE_EDIT_ENABLE)) {
            if (!Configuration.getAsBoolean((String)ConfigurationKeys.PROFILE_PARTIAL_EDIT_ENABLE)) {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.edit.disabled"));
            } else {
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("message.partial.edit.only"));
            }
            this.saveErrors(request, errors);
        }
        User requestor = this.getService().getUserByLogin(request.getRemoteUser());
        DynaActionForm userForm = (DynaActionForm)form;
        BeanUtils.copyProperties((Object)userForm, (Object)requestor);
        SupportedLocale locale = requestor.getLocale();
        if (locale == null) {
            locale = LanguageUtil.getDefaultLocale();
        }
        userForm.set("localeId", (Object)locale.getLocaleId());
        request.setAttribute("locales", locales);
        if (requestor.isTwoFactorAuthenticationEnabled().booleanValue()) {
            request.setAttribute("sharedSecret", (Object)requestor.getTwoFactorAuthenticationSecret());
        }
        boolean hasLamsCommunityToken = requestor.getLamsCommunityToken() != null;
        request.setAttribute("hasLamsCommunityToken", (Object)hasLamsCommunityToken);
        themeService = this.getThemeService();
        List themes = themeService.getAllThemes();
        request.setAttribute("themes", (Object)themes);
        Long userSelectedTheme = null;
        if (requestor.getTheme() != null) {
            for (Theme theme : themes) {
                if (theme.getThemeId() != requestor.getTheme().getThemeId()) continue;
                userSelectedTheme = theme.getThemeId();
                break;
            }
        }
        if (userSelectedTheme == null) {
            userSelectedTheme = themeService.getDefaultTheme().getThemeId();
        }
        userForm.set("userTheme", (Object)userSelectedTheme);
        List availableTimeZones = this.getTimezoneService().getDefaultTimezones();
        TreeSet<TimezoneDTO> timezoneDtos = new TreeSet<TimezoneDTO>((Comparator<TimezoneDTO>)new TimezoneDTOComparator());
        for (Timezone availableTimeZone : availableTimeZones) {
            String timezoneId = availableTimeZone.getTimezoneId();
            TimezoneDTO timezoneDto = new TimezoneDTO();
            timezoneDto.setTimeZoneId(timezoneId);
            timezoneDto.setDisplayName(TimeZone.getTimeZone(timezoneId).getDisplayName());
            timezoneDtos.add(timezoneDto);
        }
        request.setAttribute("timezoneDtos", timezoneDtos);
        return mapping.findForward("edit");
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
            locales = this.getService().findAll(SupportedLocale.class);
            Collections.sort(locales);
        }
        return service;
    }

    private ICoreLearnerService getLearnerService() {
        if (learnerService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            learnerService = (ICoreLearnerService)ctx.getBean("learnerService");
        }
        return learnerService;
    }

    private IThemeService getThemeService() {
        if (themeService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            themeService = (IThemeService)ctx.getBean("themeService");
        }
        return themeService;
    }

    private ITimezoneService getTimezoneService() {
        if (timezoneService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            timezoneService = (ITimezoneService)ctx.getBean("timezoneService");
        }
        return timezoneService;
    }
}

