/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.ValidationUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ProfileSaveAction
extends Action {
    private static Logger log = Logger.getLogger(ProfileSaveAction.class);
    private static IUserManagementService service;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userEmail;
        String lastName;
        String firstName;
        if (this.isCancelled(request)) {
            return mapping.findForward("profile");
        }
        ActionMessages errors = new ActionMessages();
        if (!Configuration.getAsBoolean((String)ConfigurationKeys.PROFILE_EDIT_ENABLE) && !Configuration.getAsBoolean((String)ConfigurationKeys.PROFILE_PARTIAL_EDIT_ENABLE)) {
            return mapping.findForward("editprofile");
        }
        User requestor = this.getService().getUserByLogin(request.getRemoteUser());
        DynaActionForm userForm = (DynaActionForm)form;
        if (!requestor.getLogin().equals(userForm.get("login"))) {
            log.warn((Object)(requestor.getLogin() + " tried to edit profile of user " + userForm.get("login")));
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.authorisation"));
            this.saveErrors(request, errors);
            return mapping.findForward("editprofile");
        }
        String string = firstName = userForm.get("firstName") == null ? null : (String)userForm.get("firstName");
        if (StringUtils.isBlank((String)firstName)) {
            errors.add("firstName", new ActionMessage("error.firstname.required"));
        } else if (!ValidationUtil.isFirstLastNameValid((String)firstName)) {
            errors.add("firstName", new ActionMessage("error.firstname.invalid.characters"));
        }
        String string2 = lastName = userForm.get("lastName") == null ? null : (String)userForm.get("lastName");
        if (StringUtils.isBlank((String)lastName)) {
            errors.add("lastName", new ActionMessage("error.lastname.required"));
        } else if (!ValidationUtil.isFirstLastNameValid((String)lastName)) {
            errors.add("lastName", new ActionMessage("error.lastname.invalid.characters"));
        }
        String string3 = userEmail = userForm.get("email") == null ? null : (String)userForm.get("email");
        if (StringUtils.isBlank((String)userEmail)) {
            errors.add("email", new ActionMessage("error.email.required"));
        } else if (!ValidationUtil.isEmailValid((String)userEmail)) {
            errors.add("email", new ActionMessage("error.valid.email.required"));
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("editprofile");
        }
        if (!Configuration.getAsBoolean((String)ConfigurationKeys.PROFILE_EDIT_ENABLE) && Configuration.getAsBoolean((String)ConfigurationKeys.PROFILE_PARTIAL_EDIT_ENABLE)) {
            requestor.setEmail(userForm.getString("email"));
            requestor.setDayPhone(userForm.getString("dayPhone"));
            requestor.setEveningPhone(userForm.getString("eveningPhone"));
            requestor.setMobilePhone(userForm.getString("mobilePhone"));
            requestor.setFax(userForm.getString("fax"));
        } else {
            BeanUtils.copyProperties((Object)requestor, (Object)userForm);
            SupportedLocale locale = (SupportedLocale)this.getService().findById(SupportedLocale.class, (Serializable)((Integer)userForm.get("localeId")));
            requestor.setLocale(locale);
            Theme cssTheme = (Theme)this.getService().findById(Theme.class, (Serializable)((Long)userForm.get("userTheme")));
            requestor.setTheme(cssTheme);
            if (userForm.get("disableLamsCommunityUsername") != null && ((Boolean)userForm.get("disableLamsCommunityUsername")).booleanValue()) {
                requestor.setLamsCommunityToken(null);
                requestor.setLamsCommunityUsername(null);
            }
        }
        this.getService().saveUser(requestor);
        HttpSession ss = SessionManager.getSession();
        ss.setAttribute("user", (Object)requestor.getUserDTO());
        return mapping.findForward("profile");
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }
}

