/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.rating.dto.ItemRatingCriteriaDTO;
import org.lamsfoundation.lams.rating.model.LearnerItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.RatingCriteria;
import org.lamsfoundation.lams.rating.model.ToolActivityRatingCriteria;
import org.lamsfoundation.lams.rating.service.RatingService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RatingServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(RatingServlet.class);
    private static RatingService ratingService;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSONObject JSONObject2 = new JSONObject();
        this.getRatingService();
        String objectId = WebUtil.readStrParam((HttpServletRequest)request, (String)"idBox");
        Long ratingCriteriaId = Long.parseLong(objectId.split("-")[0]);
        Long itemId = Long.parseLong(objectId.split("-")[1]);
        RatingCriteria criteria = ratingService.getCriteriaByCriteriaId(ratingCriteriaId);
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        Integer userId = user.getUserID();
        try {
            boolean doSave = true;
            boolean ratingLimitsByCriteria = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"ratingLimitsByCriteria", (boolean)false);
            Long maxRatingsForItem = WebUtil.readLongParam((HttpServletRequest)request, (String)"maxRatingsForItem", (boolean)true);
            if (maxRatingsForItem != null && maxRatingsForItem > 0L) {
                if (!ToolActivityRatingCriteria.class.isInstance(criteria)) {
                    log.error((Object)"Unable to enforce max ratings on a non ToolActivityRatingCritera class. Need tool content id to do the db lookup!");
                } else {
                    ToolActivityRatingCriteria toolCriteria = (ToolActivityRatingCriteria)criteria;
                    LinkedList<Long> itemIds = new LinkedList<Long>();
                    itemIds.add(itemId);
                    Map itemIdToRatedUsersCountMap = ratingLimitsByCriteria ? ratingService.countUsersRatedEachItemByCriteria(ratingCriteriaId, itemIds, userId) : ratingService.countUsersRatedEachItem(toolCriteria.getToolContentId(), itemIds, userId);
                    Long currentRatings = (Long)itemIdToRatedUsersCountMap.get(itemId);
                    if (currentRatings != null && maxRatingsForItem.compareTo(currentRatings) <= 0) {
                        JSONObject2.put("error", true);
                        JSONObject2.put("message", (Object)"Maximum number of ratings for this item has been reached. No more may be saved.");
                        doSave = false;
                    }
                }
            }
            if (doSave) {
                boolean hasRatingLimits;
                String floatString;
                String comment;
                if (criteria.isCommentsEnabled() && (comment = WebUtil.readStrParam((HttpServletRequest)request, (String)"comment", (boolean)true)) != null) {
                    ratingService.commentItem(criteria, userId, itemId, comment);
                    JSONObject2.put("comment", (Object)StringEscapeUtils.escapeCsv((String)comment));
                }
                if ((floatString = request.getParameter("rate")) != null && floatString.length() > 0) {
                    float rating = Float.parseFloat(request.getParameter("rate"));
                    ItemRatingCriteriaDTO averageRatingDTO = ratingService.rateItem(criteria, userId, itemId, rating);
                    NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
                    numberFormat.setMaximumFractionDigits(1);
                    JSONObject2.put("userRating", (Object)numberFormat.format(rating));
                    JSONObject2.put("averageRating", (Object)averageRatingDTO.getAverageRating());
                    JSONObject2.put("numberOfVotes", (Object)averageRatingDTO.getNumberOfVotes());
                }
                if (hasRatingLimits = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"hasRatingLimits", (boolean)false)) {
                    LearnerItemRatingCriteria learnerItemRatingCriteria = (LearnerItemRatingCriteria)criteria;
                    Long toolContentId = learnerItemRatingCriteria.getToolContentId();
                    int countRatedItems = ratingLimitsByCriteria ? ratingService.getCountItemsRatedByUserByCriteria(ratingCriteriaId, userId) : ratingService.getCountItemsRatedByUser(toolContentId, userId);
                    JSONObject2.put("countRatedItems", countRatedItems);
                }
            }
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
        response.setContentType("application/json;charset=utf-8");
        response.getWriter().print(JSONObject2);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private RatingService getRatingService() {
        if (ratingService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            ratingService = (RatingService)ctx.getBean("ratingService");
        }
        return ratingService;
    }
}

