/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.action;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EditLessonIntroAction
extends DispatchAction {
    private static ILessonService lessonService;

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)req, (String)"lessonID");
        Lesson lesson = this.getLessonService().getLesson(lessonId);
        req.setAttribute("lesson", (Object)lesson);
        req.setAttribute("displayDesignImage", (Object)lesson.isDisplayDesignImage());
        req.setAttribute("contentFolderID", (Object)lesson.getLearningDesign().getContentFolderID());
        return mapping.findForward("editLessonIntro");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Long lessonId = WebUtil.readLongParam((HttpServletRequest)req, (String)"lessonID");
        Lesson lesson = this.getLessonService().getLesson(lessonId);
        String lessonName = WebUtil.readStrParam((HttpServletRequest)req, (String)"lessonName");
        String lessonDescription = WebUtil.readStrParam((HttpServletRequest)req, (String)"lessonDescription");
        boolean displayDesignImage = WebUtil.readBooleanParam((HttpServletRequest)req, (String)"displayDesignImage", (boolean)false);
        lesson.setLessonName(lessonName);
        lesson.setLessonDescription(lessonDescription);
        lesson.setDisplayDesignImage(Boolean.valueOf(displayDesignImage));
        this.getLessonService().saveLesson(lesson);
        return null;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }
}

