/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.lamscommunity;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.config.Registration;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.lamscommunity.LamsCommunityLoginForm;
import org.lamsfoundation.lams.web.lamscommunity.LamsCommunityUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LamsCommunityLoginAction
extends LamsDispatchAction {
    private IUserManagementService service;
    private static final String ATTR_ERROR_MESSAGE = "errorMessage";
    private static final String LC_METHOD_IMPORT = "import";
    private static final String LC_METHOD_NEWS = "news";
    private static final String LC_METHOD_SAVE = "save";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Registration reg;
        User user = this.getUser(request);
        String dest = WebUtil.readStrParam((HttpServletRequest)request, (String)"dest", (boolean)true);
        if (dest == null) {
            dest = LC_METHOD_NEWS;
        }
        if ((reg = Configuration.getRegistration()) == null || !reg.isEnableLamsCommunityIntegration()) {
            request.setAttribute("registered", (Object)Boolean.FALSE);
        } else {
            request.setAttribute("registered", (Object)Boolean.TRUE);
        }
        if (user.getLamsCommunityToken() == null || user.getLamsCommunityToken().equals("")) {
            return mapping.findForward("lamsCommunityLogin");
        }
        this.loginToLamsCommunity(mapping, form, request, response);
        return null;
    }

    public ActionForward getLCUserLogin(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("lamsCommunityLogin");
    }

    public ActionForward authenticate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LamsCommunityLoginForm loginForm = (LamsCommunityLoginForm)form;
        Registration reg = Configuration.getRegistration();
        String responseString = null;
        if (reg == null || reg.getServerID() == null || reg.getServerKey() == null) {
            throw new Exception("Attempt to authenticate in lams community without registration");
        }
        responseString = this.lamsCommunityAuth(loginForm.getLcUserName(), loginForm.getLcPassword(), reg.getServerID(), reg.getServerKey());
        if (responseString != null) {
            String[] result = responseString.split(",");
            if (result[0].equals("success")) {
                User user = this.getUser(request);
                user.setLamsCommunityUsername(loginForm.getLcUserName());
                user.setLamsCommunityToken(result[1]);
                this.getService().saveUser(user);
                return this.loginToLamsCommunity(mapping, form, request, response);
            }
            if (result.length == 2) {
                request.setAttribute(ATTR_ERROR_MESSAGE, (Object)result[1]);
            } else {
                request.setAttribute(ATTR_ERROR_MESSAGE, (Object)"lamscommunity.login.failed");
            }
            return mapping.findForward("lamsCommunityLogin");
        }
        request.setAttribute(ATTR_ERROR_MESSAGE, (Object)"lamscommunity.no.result");
        return mapping.findForward("lamsCommunityLogin");
    }

    public String lamsCommunityAuth(String userName, String lcPassword, String serverID, String serverKey) throws Exception {
        String timestamp = "" + new Date().getTime();
        String encryption = LamsCommunityUtil.encryptAuthenticationInfo(timestamp, userName, lcPassword, serverID, serverKey);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("hs", URLEncoder.encode(encryption, "UTF8"));
        params.put("sid", URLEncoder.encode(serverID, "UTF8"));
        InputStream is = WebUtil.getResponseInputStreamFromExternalServer((String)"http://lamscommunity.org/lams/x/auth", params);
        BufferedReader isReader = new BufferedReader(new InputStreamReader(is));
        String str = isReader.readLine();
        return str;
    }

    public ActionForward loginToLamsCommunity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = this.getUser(request);
        String lamscommunityDest = WebUtil.readStrParam((HttpServletRequest)request, (String)"dest", (boolean)true);
        Registration reg = Configuration.getRegistration();
        if (reg == null || reg.getServerID() == null || reg.getServerKey() == null) {
            throw new Exception("Attempt to authenticate in lams community without registration");
        }
        String serverID = reg.getServerID();
        String serverKey = reg.getServerKey();
        UserDTO userDTO = (UserDTO)SessionManager.getSession().getAttribute("user");
        userDTO.setLoggedIntoLamsCommunity(Boolean.valueOf(true));
        String timestamp = "" + new Date().getTime();
        String hash = LamsCommunityUtil.createAuthenticationHash(timestamp, user.getLamsCommunityUsername(), user.getLamsCommunityToken(), serverID, serverKey);
        String url = "http://lamscommunity.org/lams/x/sso?";
        url = LamsCommunityUtil.appendAuthInfoToURL(url, user);
        if (lamscommunityDest != null) {
            String customCSV = WebUtil.readStrParam((HttpServletRequest)request, (String)"customCSV", (boolean)true);
            url = this.appendReturnUrl(url, lamscommunityDest, customCSV);
        }
        log.debug((Object)("Redirecting to lamscommunity url: " + url));
        response.sendRedirect(url);
        return null;
    }

    private String appendReturnUrl(String url, String dest, String customCSV) throws Exception {
        url = url + "&dest=" + URLEncoder.encode(dest, "UTF8");
        if (dest != null && dest.equals(LC_METHOD_IMPORT)) {
            String returnURL = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/authoring/importToolContent.do?method=importLCFinish";
            url = url + "&returnURL=" + URLEncoder.encode(returnURL, "UTF8");
        } else if (dest == null || dest.equals(LC_METHOD_SAVE)) {
            // empty if block
        }
        if (customCSV != null && customCSV.length() != 0) {
            url = url + "&customCSV=" + customCSV;
        }
        return url;
    }

    private User getUser(HttpServletRequest request) {
        return this.getService().getUserByLogin(request.getRemoteUser());
    }

    private IUserManagementService getService() {
        if (this.service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            this.service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return this.service;
    }
}

