/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.CSSThemeUtil;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class CssTag
extends TagSupport {
    private static final long serialVersionUID = -3143529984657965761L;
    private static final Logger log = Logger.getLogger(CssTag.class);
    private String style = null;
    private static final String LEARNER_STYLE = "learner";
    private static final String RTL_DIR = "rtl";

    public int doStartTag() throws JspException {
        String serverURL = Configuration.get((String)ConfigurationKeys.SERVER_URL);
        String string = serverURL = serverURL == null ? null : serverURL.trim();
        if (serverURL != null) {
            try {
                HttpSession session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
                String pageDirection = (String)session.getAttribute("page_direction");
                boolean rtl = RTL_DIR.equalsIgnoreCase(pageDirection);
                List themeList = CSSThemeUtil.getAllUserThemes();
                String customStylesheetLink = null;
                for (String theme : themeList) {
                    if (theme != null) {
                        theme = this.appendStyle(theme, rtl);
                        customStylesheetLink = this.generateLink(theme, serverURL);
                    }
                    if (customStylesheetLink == null) continue;
                    JspWriter writer = this.pageContext.getOut();
                    writer.println(customStylesheetLink);
                }
            }
            catch (IOException e) {
                log.error((Object)"CssTag unable to write out CSS details due to IOException.", (Throwable)e);
            }
        } else {
            log.warn((Object)"CSSTag unable to write out CSS entries as the server url is missing from the configuration file.");
        }
        return 0;
    }

    private String appendStyle(String stylesheetName, boolean rtl) {
        String ssName = stylesheetName;
        if (ssName != null) {
            ssName = this.getStyle() == null || LEARNER_STYLE.equalsIgnoreCase(this.getStyle()) ? (rtl ? ssName + "_" + RTL_DIR + "_learner" : ssName + "_learner") : (rtl ? ssName + "_" + RTL_DIR : ssName);
        }
        return ssName;
    }

    private String generateLink(String stylesheetName, String serverURL) {
        if (serverURL.endsWith("/")) {
            return "<link href=\"" + serverURL + "css/" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
        }
        return "<link href=\"" + serverURL + "/css/" + stylesheetName + ".css\" rel=\"stylesheet\" type=\"text/css\">";
    }

    public int doEndTag() {
        return 6;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

