/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice.xml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.gradebook.GradebookUserLesson;
import org.lamsfoundation.lams.gradebook.service.IGradebookService;
import org.lamsfoundation.lams.index.IndexLessonBean;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServer;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.UserInfoValidationException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.tool.OutputType;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class LessonManagerServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(LessonManagerServlet.class);
    private static IntegrationService integrationService = null;
    private static IMonitoringService monitoringService = null;
    private static ILessonService lessonService = null;
    private static IExportToolContentService exportService = null;
    private static ILamsCoreToolService toolService = null;
    private static IGradebookService gradebookService = null;
    private static IUserManagementService userManagementService = null;
    private static ISecurityService securityService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        String serverId = request.getParameter("serverId");
        String datetime = request.getParameter("datetime");
        String hashValue = request.getParameter("hashValue");
        String username = request.getParameter("username");
        String courseId = request.getParameter("courseId");
        String ldIdStr = request.getParameter("ldId");
        String lsIdStr = request.getParameter("lsId");
        String country = request.getParameter("country");
        String title = request.getParameter("title");
        String desc = request.getParameter("desc");
        String startDate = request.getParameter("startdate");
        String lang = request.getParameter("lang");
        String method = request.getParameter("method");
        String filePath = request.getParameter("filePath");
        String outputsUser = request.getParameter("outputsUser");
        String userIds = request.getParameter("userIds");
        String learnerIds = request.getParameter("learnerIds");
        String monitorIds = request.getParameter("monitorIds");
        String customCSV = request.getParameter("customCSV");
        String firstNames = request.getParameter("firstNames");
        String lastNames = request.getParameter("lastNames");
        String emails = request.getParameter("emails");
        boolean presenceEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerSeeOnline", (boolean)false);
        boolean imEnable = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"learnerInstantMessaging", (boolean)false);
        boolean enableNotifications = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"enableNotifications", (boolean)false);
        Long ldId = null;
        Long lsId = null;
        ServletOutputStream outputStream = null;
        try {
            Long lessonId;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = null;
            if (hashValue == null || hashValue.equals("")) {
                throw new NullPointerException("Hash value missing in parameters");
            }
            if (method.equals("start")) {
                ldId = new Long(ldIdStr);
                lessonId = LessonManagerServlet.startLesson(serverId, datetime, hashValue, username, ldId, courseId, title, desc, country, lang, customCSV, presenceEnable, imEnable, enableNotifications);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lessonId.toString());
            } else if (method.equals("preview")) {
                ldId = new Long(ldIdStr);
                lessonId = this.startPreview(serverId, datetime, hashValue, username, ldId, courseId, title, desc, country, lang, customCSV, presenceEnable, imEnable);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lessonId.toString());
            } else if (method.equals("schedule")) {
                ldId = new Long(ldIdStr);
                lessonId = this.scheduleLesson(serverId, datetime, hashValue, username, ldId, courseId, title, desc, startDate, country, lang, customCSV, presenceEnable, imEnable, enableNotifications);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lessonId.toString());
            } else if (method.equals("clone")) {
                lsId = new Long(lsIdStr);
                lessonId = this.cloneLesson(serverId, datetime, hashValue, username, lsId, courseId, country, lang);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lessonId.toString());
            } else if (method.equals("delete") || method.equals("removeLesson")) {
                this.verifyPostRequestMethod(request);
                lsId = new Long(lsIdStr);
                Boolean deleted = this.removeLesson(serverId, datetime, hashValue, username, lsId);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lsId.toString());
                element.setAttribute("deleted", deleted.toString());
            } else if (method.equals("removeAllLessons")) {
                this.verifyPostRequestMethod(request);
                element = this.removeAllLessons(document, serverId, datetime, hashValue, username, courseId);
            } else if (method.equals("removeUser")) {
                this.verifyPostRequestMethod(request);
                lsId = new Long(lsIdStr);
                element = this.removeUser(document, serverId, datetime, hashValue, username, lsId, userIds);
            } else if (method.equals("removeAllUsers")) {
                this.verifyPostRequestMethod(request);
                lsId = new Long(lsIdStr);
                element = this.removeAllUsers(document, serverId, datetime, hashValue, username, lsId);
            } else if (method.equals("studentProgress")) {
                lsId = new Long(lsIdStr);
                element = this.getAllStudentProgress(document, serverId, datetime, hashValue, username, lsId, courseId);
            } else if (method.equals("singleStudentProgress")) {
                String firstName = request.getParameter("firstName");
                String lastName = request.getParameter("lastName");
                String email = request.getParameter("email");
                lsId = new Long(lsIdStr);
                element = this.getSingleStudentProgress(document, serverId, datetime, hashValue, username, firstName, lastName, lang, country, email, lsId, courseId);
            } else if (method.equals("import")) {
                Long ldID = this.importLearningDesign(request, response, filePath, username, serverId, customCSV);
                element = document.createElement("Lesson");
                element.setAttribute("ldId", ldID.toString());
            } else if (method.equals("join")) {
                Thread t = new Thread(new AddUsersToLessonThread(serverId, datetime, username, hashValue, lsIdStr, courseId, country, lang, learnerIds, monitorIds, firstNames, lastNames, emails, request));
                t.start();
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lsIdStr);
            } else if (method.equals("gradebookMarksUser")) {
                lsId = new Long(lsIdStr);
                element = this.getGradebookMarks(document, serverId, datetime, hashValue, username, lsId, null, outputsUser);
            } else if (method.equals("gradebookMarksLesson")) {
                lsId = new Long(lsIdStr);
                element = this.getGradebookMarks(document, serverId, datetime, hashValue, username, lsId, null, null);
            } else if (method.equals("gradebookMarksCourse")) {
                element = this.getGradebookMarks(document, serverId, datetime, hashValue, username, null, courseId, null);
            } else if (method.equals("toolOutputsAllUsers")) {
                lsId = new Long(lsIdStr);
                element = this.getToolOutputs(document, serverId, datetime, hashValue, username, lsId, courseId, false, null);
            } else if (method.equals("authoredToolOutputsAllUsers")) {
                lsId = new Long(lsIdStr);
                element = this.getToolOutputs(document, serverId, datetime, hashValue, username, lsId, courseId, true, null);
            } else if (method.equals("toolOutputsUser")) {
                lsId = new Long(lsIdStr);
                element = this.getToolOutputs(document, serverId, datetime, hashValue, username, lsId, courseId, false, outputsUser);
            } else if (method.equals("authoredToolOutputsUser")) {
                lsId = new Long(lsIdStr);
                element = this.getToolOutputs(document, serverId, datetime, hashValue, username, lsId, courseId, true, outputsUser);
            } else {
                if (method.equals("verify")) {
                    this.verify(serverId, datetime, hashValue);
                    response.setContentType("text/html");
                    PrintWriter out = response.getWriter();
                    out.write("1");
                    out.flush();
                    out.close();
                    return;
                }
                if (method.equals("listMonitor")) {
                    element = this.getLessonMonitorList(document, serverId, datetime, hashValue, username, courseId, country, lang);
                } else {
                    String msg = "Method :" + method + " is not recognised";
                    log.error((Object)msg);
                    response.sendError(400, msg);
                }
            }
            document.appendChild(element);
            outputStream = response.getOutputStream();
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)document.getImplementation());
            LSSerializer lsSerializer = domImplementation.createLSSerializer();
            LSOutput lsOutput = domImplementation.createLSOutput();
            lsOutput.setEncoding("UTF-8");
            lsOutput.setByteStream((OutputStream)outputStream);
            lsSerializer.write(document, lsOutput);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("lsId or ldId is not an integer" + lsIdStr + ldIdStr), (Throwable)nfe);
            response.sendError(400, "lsId or ldId is not an integer");
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Can not convert XML document to string", (Throwable)e);
            response.sendError(500);
        }
        catch (TransformerException e) {
            log.error((Object)"Can not convert XML document to string", (Throwable)e);
            response.sendError(500);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Can not build XML document", (Throwable)e);
            response.sendError(500);
        }
        catch (NullPointerException e) {
            log.error((Object)"Missing parameters", (Throwable)e);
            response.sendError(500);
        }
        catch (Exception e) {
            log.error((Object)"Problem loading learning manager servlet request", (Throwable)e);
            response.sendError(500);
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private static Long startLesson(String serverId, String datetime, String hashValue, String username, long ldId, String courseId, String title, String desc, String countryIsoCode, String langIsoCode, String customCSV, boolean presenceEnable, boolean imEnable, boolean enableNotifications) throws RemoteException {
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer, userMap, courseId, countryIsoCode, langIsoCode, null, "monitor");
            User user = userMap.getUser();
            Organisation organisation = orgMap.getOrganisation();
            Lesson lesson = monitoringService.initializeLesson(title, desc, ldId, organisation.getOrganisationId(), user.getUserId(), customCSV, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(presenceEnable), Boolean.valueOf(imEnable), Boolean.valueOf(true), Boolean.valueOf(enableNotifications), Boolean.valueOf(false), Boolean.valueOf(false), null, null);
            LessonManagerServlet.createLessonClass(lesson, organisation, user);
            monitoringService.startLesson(lesson.getLessonId().longValue(), user.getUserId());
            integrationService.createExtServerLessonMap(lesson.getLessonId(), extServer);
            return lesson.getLessonId();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private Long scheduleLesson(String serverId, String datetime, String hashValue, String username, long ldId, String courseId, String title, String desc, String startDate, String countryIsoCode, String langIsoCode, String customCSV, boolean presenceEnable, boolean imEnable, boolean enableNotifications) throws RemoteException {
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer, userMap, courseId, countryIsoCode, langIsoCode, null, "monitor");
            Lesson lesson = monitoringService.initializeLesson(title, desc, ldId, orgMap.getOrganisation().getOrganisationId(), userMap.getUser().getUserId(), customCSV, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(presenceEnable), Boolean.valueOf(imEnable), Boolean.valueOf(true), Boolean.valueOf(enableNotifications), Boolean.valueOf(false), Boolean.valueOf(false), null, null);
            LessonManagerServlet.createLessonClass(lesson, orgMap.getOrganisation(), userMap.getUser());
            Date date = DateUtil.convertFromString((String)startDate, (String)"dd/M/yyyy h:mm a");
            monitoringService.startLessonOnSchedule(lesson.getLessonId().longValue(), date, userMap.getUser().getUserId());
            return lesson.getLessonId();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private Long cloneLesson(String serverId, String datetime, String hashValue, String username, long lsId, String courseId, String countryIsoCode, String langIsoCode) throws RemoteException {
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
            Integer creatorId = userMap.getUser().getUserId();
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer, userMap, courseId, countryIsoCode, langIsoCode, null, "monitor");
            if (orgMap == null) {
                log.debug((Object)("No course exists for: " + courseId + ". Can't delete any lessons."));
                throw new Exception("Course with courseId: " + courseId + " could not be found");
            }
            Organisation organisation = orgMap.getOrganisation();
            Long newLessonId = monitoringService.cloneLesson(Long.valueOf(lsId), creatorId, Boolean.valueOf(true), Boolean.valueOf(true), null, null, organisation);
            integrationService.createExtServerLessonMap(newLessonId, extServer);
            return newLessonId;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private Element getAllStudentProgress(Document document, String serverId, String datetime, String hashValue, String username, long lsId, String courseID) throws RemoteException {
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            Lesson lesson = lessonService.getLesson(Long.valueOf(lsId));
            Element element = document.createElement("LessonProgress");
            element.setAttribute("lessonId", "" + lsId);
            String prefix = extServer.getPrefix();
            if (lesson != null) {
                int activitiesTotal = lesson.getLearningDesign().getActivities().size();
                for (LearnerProgress learnProg : lesson.getLearnerProgresses()) {
                    LearnerProgressDTO learnerProgress = learnProg.getLearnerProgressData();
                    String userNoPrefixName = learnerProgress.getUserName().substring(prefix.length() + 1);
                    ExtUserUseridMap learnerMap = integrationService.getExtUserUseridMap(extServer, userNoPrefixName);
                    Element learnerProgElem = document.createElement("LearnerProgress");
                    int completedActivities = learnerProgress.getCompletedActivities().length;
                    int attemptedActivities = learnerProgress.getAttemptedActivities().length;
                    if (learnerProgElem.getNodeType() == 1) {
                        learnerProgElem.setAttribute("lessonComplete", "" + learnerProgress.getLessonComplete());
                        learnerProgElem.setAttribute("activityCount", "" + activitiesTotal);
                        learnerProgElem.setAttribute("activitiesCompleted", "" + completedActivities);
                        learnerProgElem.setAttribute("attemptedActivities", "" + attemptedActivities);
                        learnerProgElem.setAttribute("studentId", "" + learnerMap.getSid());
                        learnerProgElem.setAttribute("courseId", courseID);
                        learnerProgElem.setAttribute("username", userNoPrefixName);
                        learnerProgElem.setAttribute("lessonId", "" + lsId);
                    }
                    element.appendChild(learnerProgElem);
                }
            } else {
                throw new Exception("Lesson with lessonID: " + lsId + " could not be found for learner progresses");
            }
            return element;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private Element getSingleStudentProgress(Document document, String serverId, String datetime, String hashValue, String username, String firstName, String lastName, String language, String country, String email, long lsId, String courseID) throws RemoteException {
        try {
            Element learnerProgElem;
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            Lesson lesson = lessonService.getLesson(Long.valueOf(lsId));
            Element element = document.createElement("LessonProgress");
            element.setAttribute("lessonId", "" + lsId);
            if (lesson != null) {
                int activitiesTotal = lesson.getLearningDesign().getActivities().size();
                boolean usePrefix = true;
                boolean isUpdateUserDetails = false;
                ExtUserUseridMap userMap = integrationService.getImplicitExtUserUseridMap(extServer, username, firstName, lastName, language, country, email, true, false);
                LearnerProgress learnProg = lessonService.getUserProgressForLesson(userMap.getUser().getUserId(), Long.valueOf(lsId));
                learnerProgElem = document.createElement("LearnerProgress");
                if (learnProg != null) {
                    LearnerProgressDTO learnerProgress = learnProg.getLearnerProgressData();
                    int completedActivities = learnerProgress.getCompletedActivities().length;
                    int attemptedActivities = learnerProgress.getAttemptedActivities().length;
                    if (learnerProgElem.getNodeType() == 1) {
                        learnerProgElem.setAttribute("lessonComplete", "" + learnerProgress.getLessonComplete());
                        learnerProgElem.setAttribute("activityCount", "" + activitiesTotal);
                        learnerProgElem.setAttribute("activitiesCompleted", "" + completedActivities);
                        learnerProgElem.setAttribute("attemptedActivities", "" + attemptedActivities);
                        learnerProgElem.setAttribute("studentId", "" + userMap.getSid());
                        learnerProgElem.setAttribute("courseId", courseID);
                        learnerProgElem.setAttribute("username", username);
                        learnerProgElem.setAttribute("lessonId", "" + lsId);
                    }
                } else if (learnerProgElem.getNodeType() == 1) {
                    learnerProgElem.setAttribute("lessonComplete", "false");
                    learnerProgElem.setAttribute("activityCount", "" + activitiesTotal);
                    learnerProgElem.setAttribute("activitiesCompleted", "0");
                    learnerProgElem.setAttribute("attemptedActivities", "0");
                    learnerProgElem.setAttribute("studentId", "" + userMap.getSid());
                    learnerProgElem.setAttribute("courseId", courseID);
                    learnerProgElem.setAttribute("username", username);
                    learnerProgElem.setAttribute("lessonId", "" + lsId);
                }
            } else {
                throw new Exception("Lesson with lessonID: " + lsId + " could not be found for learner progresses");
            }
            element.appendChild(learnerProgElem);
            return element;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private boolean removeLesson(String serverId, String datetime, String hashValue, String username, long lsId) throws RemoteException {
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
            monitoringService.removeLesson(lsId, userMap.getUser().getUserId());
            return true;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private Element removeAllLessons(Document document, String serverId, String datetime, String hashValue, String username, String courseId) throws Exception {
        Element lessonsElement = document.createElement("Lessons");
        ExtServer extServer = integrationService.getExtServer(serverId);
        Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
        ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
        ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer.getSid(), courseId);
        if (orgMap == null) {
            log.debug((Object)("No course exists for: " + courseId + ". Can't delete any lessons."));
            throw new Exception("Course with courseId: " + courseId + " could not be found");
        }
        Integer organisationId = orgMap.getOrganisation().getOrganisationId();
        List lessons = lessonService.getLessonsByGroup(organisationId);
        if (lessons != null) {
            for (Lesson lesson : lessons) {
                Long lessonId = lesson.getLessonId();
                monitoringService.removeLesson(lessonId.longValue(), userMap.getUser().getUserId());
                Element lessonElement = document.createElement("Lesson");
                lessonElement.setAttribute("lessonId", "" + lessonId);
                lessonElement.setAttribute("deleted", "true");
                lessonsElement.appendChild(lessonElement);
            }
        }
        return lessonsElement;
    }

    private Element removeUser(Document document, String serverId, String datetime, String hashValue, String username, long lsId, String userIds) throws Exception {
        String[] extUsernames;
        Element usersElement = document.createElement("Users");
        ExtServer extServer = integrationService.getExtServer(serverId);
        Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
        ExtUserUseridMap monitorMap = integrationService.getExtUserUseridMap(extServer, username);
        securityService.isLessonMonitor(Long.valueOf(lsId), monitorMap.getUser().getUserId(), "remove user", true);
        for (String extUsername : extUsernames = userIds != null ? userIds.split(",") : new String[]{}) {
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, extUsername);
            Integer userId = userMap.getUser().getUserId();
            lessonService.removeLearner(Long.valueOf(lsId), userId);
            Element lessonElement = document.createElement("User");
            lessonElement.setAttribute("userId", "" + userId);
            lessonElement.setAttribute("deleted", "true");
            usersElement.appendChild(lessonElement);
        }
        return usersElement;
    }

    private Element removeAllUsers(Document document, String serverId, String datetime, String hashValue, String username, long lsId) throws Exception {
        Element usersElement = document.createElement("Users");
        ExtServer extServer = integrationService.getExtServer(serverId);
        Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
        ExtUserUseridMap monitorMap = integrationService.getExtUserUseridMap(extServer, username);
        securityService.isLessonMonitor(Long.valueOf(lsId), monitorMap.getUser().getUserId(), "remove all users", true);
        Lesson lesson = lessonService.getLesson(Long.valueOf(lsId));
        Set users = lesson.getAllLearners();
        if (users != null) {
            for (User user : users) {
                Integer userId = user.getUserId();
                lessonService.removeLearner(Long.valueOf(lsId), userId);
                Element lessonElement = document.createElement("User");
                lessonElement.setAttribute("userId", "" + userId);
                lessonElement.setAttribute("deleted", "true");
                usersElement.appendChild(lessonElement);
            }
        }
        return usersElement;
    }

    private Long startPreview(String serverId, String datetime, String hashValue, String username, Long ldId, String courseId, String title, String desc, String countryIsoCode, String langIsoCode, String customCSV, boolean presenceEnable, boolean imEnable) throws RemoteException {
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer, userMap, courseId, countryIsoCode, langIsoCode, null, "monitor");
            Integer userId = userMap.getUser().getUserId();
            Lesson lesson = monitoringService.initializeLessonForPreview(title, desc, ldId.longValue(), userId, customCSV, Boolean.valueOf(presenceEnable), Boolean.valueOf(imEnable), Boolean.valueOf(false));
            monitoringService.createPreviewClassForLesson(userId.intValue(), lesson.getLessonId().longValue());
            monitoringService.startLesson(lesson.getLessonId().longValue(), userId);
            return lesson.getLessonId();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private Long importLearningDesign(HttpServletRequest request, HttpServletResponse response, String filePath, String username, String serverId, String customCSV) throws RemoteException {
        List ldErrorMsgs = new ArrayList();
        List toolsErrorMsgs = new ArrayList();
        Long ldId = null;
        Integer workspaceFolderUid = null;
        User user = null;
        ExtServer extServer = integrationService.getExtServer(serverId);
        try {
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(extServer, username);
            user = userMap.getUser();
            HttpSession ss = SessionManager.getSession();
            boolean createdTemporarySession = false;
            if (ss == null) {
                SessionManager.startSession((HttpServletRequest)request);
                ss = SessionManager.getSession();
                ss.setAttribute("user", (Object)user.getUserDTO());
                createdTemporarySession = true;
            }
            File designFile = new File(filePath);
            Object[] ldResults = exportService.importLearningDesign(designFile, user, workspaceFolderUid, toolsErrorMsgs, customCSV);
            ldId = (Long)ldResults[0];
            ldErrorMsgs = (List)ldResults[1];
            toolsErrorMsgs = (List)ldResults[2];
            if (createdTemporarySession) {
                SessionManager.endSession();
            }
            return ldId;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private static void createLessonClass(Lesson lesson, Organisation organisation, User creator) {
        LinkedList<User> staffList = new LinkedList<User>();
        staffList.add(creator);
        LinkedList learnerList = new LinkedList();
        Vector learnerVector = userManagementService.getUsersFromOrganisationByRole(organisation.getOrganisationId(), "LEARNER", true);
        learnerList.addAll(learnerVector);
        monitoringService.createLessonClassForLesson(lesson.getLessonId().longValue(), organisation, organisation.getName() + " learners", learnerList, organisation.getName() + " staff", staffList, creator.getUserId());
    }

    public void init() throws ServletException {
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        monitoringService = (IMonitoringService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("monitoringService");
        lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("lessonService");
        exportService = (IExportToolContentService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("exportToolContentService");
        toolService = (ILamsCoreToolService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("lamsCoreToolService");
        gradebookService = (IGradebookService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("gradebookService");
        userManagementService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("userManagementService");
        securityService = (ISecurityService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("securityService");
    }

    private Element getGradebookMarks(Document document, String serverId, String datetime, String hashValue, String username, Long lessonIdParam, String courseId, String outputsUser) throws Exception {
        ExtServer extServer = integrationService.getExtServer(serverId);
        Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
        LinkedList<Lesson> lessons = new LinkedList<Lesson>();
        if (courseId != null) {
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer.getSid(), courseId);
            if (orgMap == null) {
                log.debug((Object)("No course exists for: " + courseId + ". Cannot get tool outputs report."));
                throw new Exception("Course with courseId: " + courseId + " could not be found");
            }
            Integer organisationId = orgMap.getOrganisation().getOrganisationId();
            lessons.addAll(lessonService.getLessonsByGroup(organisationId));
        } else {
            Lesson lesson = lessonService.getLesson(lessonIdParam);
            if (lesson == null) {
                log.debug((Object)("No lesson exists for: " + lessonIdParam + ". Cannot get tool outputs report."));
                throw new Exception("Lesson with lessonID: " + lessonIdParam + " could not be found for learner progresses");
            }
            lessons.add(lesson);
        }
        Element gradebookMarksElement = document.createElement("GradebookMarks");
        for (Lesson lesson : lessons) {
            Long lessonId = lesson.getLessonId();
            Element lessonElement = document.createElement("Lesson");
            lessonElement.setAttribute("lessonId", "" + lessonId);
            lessonElement.setAttribute("lessonName", lesson.getLessonName());
            Set<ToolActivity> activities = this.getLessonActivities(lesson);
            Long lessonMaxPossibleMark = 0L;
            for (ToolActivity activity : activities) {
                Long activityMaxPossibleMark = toolService.getActivityMaxPossibleMark(activity);
                if (activityMaxPossibleMark == null) continue;
                lessonMaxPossibleMark = lessonMaxPossibleMark + activityMaxPossibleMark;
            }
            lessonElement.setAttribute("lessonMaxPossibleMark", lessonMaxPossibleMark.toString());
            LinkedList<GradebookUserLesson> gradebookUserLessons = new LinkedList<GradebookUserLesson>();
            if (outputsUser != null) {
                ExtUserUseridMap userMap = integrationService.getExistingExtUserUseridMap(extServer, outputsUser);
                if (userMap == null) {
                    throw new Exception("No user exists for: " + outputsUser + ". Cannot get tool outputs report.");
                }
                User user = userMap.getUser();
                Integer userId = user.getUserId();
                GradebookUserLesson gradebookUserLesson = gradebookService.getGradebookUserLesson(lessonId, userId);
                if (gradebookUserLesson == null) {
                    gradebookUserLesson = new GradebookUserLesson(lesson, user);
                }
                gradebookUserLessons.add(gradebookUserLesson);
            } else {
                gradebookUserLessons.addAll(gradebookService.getGradebookUserLesson(lessonId));
                log.debug((Object)("Getting tool ouputs report for: " + lessonId + ". With learning design: " + lesson.getLearningDesign().getLearningDesignId()));
            }
            List allUsers = integrationService.getExtUserUseridMapByExtServer(extServer);
            for (GradebookUserLesson gradebookUserLesson : gradebookUserLessons) {
                Integer userId = gradebookUserLesson.getLearner().getUserId();
                ExtUserUseridMap extUser = null;
                for (ExtUserUseridMap extUserIter : allUsers) {
                    if (!extUserIter.getUser().getUserId().equals(userId)) continue;
                    extUser = extUserIter;
                    break;
                }
                if (extUser == null) {
                    throw new Exception("User with userId: " + userId + " doesn't belong to extServer: " + extServer.getSid());
                }
                Element learnerElement = document.createElement("Learner");
                learnerElement.setAttribute("extUsername", extUser.getExtUsername());
                String userTotalMark = gradebookUserLesson.getMark() == null ? "" : gradebookUserLesson.getMark().toString();
                learnerElement.setAttribute("userTotalMark", userTotalMark);
                lessonElement.appendChild(learnerElement);
            }
            gradebookMarksElement.appendChild(lessonElement);
        }
        return gradebookMarksElement;
    }

    public Element getToolOutputs(Document document, String serverId, String datetime, String hashValue, String username, Long lessonId, String courseID, boolean isAuthoredToolOutputs, String outputsUser) throws Exception {
        ExtServer extServer = integrationService.getExtServer(serverId);
        Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
        Lesson lesson = lessonService.getLesson(lessonId);
        if (lesson == null) {
            log.debug((Object)("No lesson exists for: " + lessonId + ". Cannot get tool outputs report."));
            throw new Exception("Lesson with lessonID: " + lessonId + " could not be found for learner progresses");
        }
        Set<ToolActivity> activities = this.getLessonActivities(lesson);
        TreeSet<User> learners = new TreeSet<User>();
        if (outputsUser != null) {
            ExtUserUseridMap userMap = integrationService.getExistingExtUserUseridMap(extServer, outputsUser);
            if (userMap == null) {
                log.debug((Object)("No user exists for: " + outputsUser + ". Cannot get tool outputs report."));
                throw new Exception("No user exists for: " + outputsUser + ". Cannot get tool outputs report.");
            }
            learners.add(userMap.getUser());
        } else {
            learners.addAll(lesson.getAllLearners());
            log.debug((Object)("Getting tool ouputs report for: " + lessonId + ". With learning design: " + lesson.getLearningDesign().getLearningDesignId()));
        }
        Element toolOutputsElement = document.createElement("ToolOutputs");
        toolOutputsElement.setAttribute("lessonId", "" + lessonId);
        toolOutputsElement.setAttribute("name", lesson.getLessonName());
        List learnerProgresses = lessonService.getUserProgressForLesson(lesson.getLessonId());
        List toolSessions = toolService.getToolSessionsByLesson(lesson);
        TreeMap<Long, SortedMap> toolOutputDefinitionsMap = new TreeMap<Long, SortedMap>();
        for (ToolActivity activity : activities) {
            Long toolContentId = activity.getToolContentId();
            if (toolOutputDefinitionsMap.get(toolContentId) != null) continue;
            SortedMap toolOutputDefinitions = toolService.getOutputDefinitionsFromTool(toolContentId, 1);
            toolOutputDefinitionsMap.put(toolContentId, toolOutputDefinitions);
        }
        for (User learner : learners) {
            Element learnerElement = document.createElement("LearnerOutput");
            String userNoPrefixName = learner.getLogin().substring(extServer.getPrefix().length() + 1);
            learnerElement.setAttribute("userName", userNoPrefixName);
            learnerElement.setAttribute("lamsUserName", learner.getLogin());
            learnerElement.setAttribute("lamsUserId", learner.getUserId().toString());
            learnerElement.setAttribute("firstName", learner.getFirstName());
            learnerElement.setAttribute("lastName", learner.getLastName());
            LearnerProgress learnerProgress = null;
            for (LearnerProgress dbLearnerProgress : learnerProgresses) {
                if (!dbLearnerProgress.getUser().getUserId().equals(learner.getUserId())) continue;
                learnerProgress = dbLearnerProgress;
            }
            if (learnerProgress != null) {
                learnerElement.setAttribute("completedLesson", "" + learnerProgress.isComplete());
            }
            for (ToolActivity activity : activities) {
                ToolSession toolSession = null;
                for (ToolSession dbToolSession : toolSessions) {
                    if (!dbToolSession.getToolActivity().getActivityId().equals(activity.getActivityId()) || !dbToolSession.getLearners().contains(learner)) continue;
                    toolSession = dbToolSession;
                }
                Map toolOutputDefinitions = (Map)toolOutputDefinitionsMap.get(activity.getToolContentId());
                learnerElement.appendChild(this.getActivityOutputsElement(document, activity, learner, learnerProgress, toolSession, toolOutputDefinitions, isAuthoredToolOutputs));
            }
            toolOutputsElement.appendChild(learnerElement);
        }
        return toolOutputsElement;
    }

    private Set<ToolActivity> getLessonActivities(Lesson lesson) {
        TreeSet<Activity> activities = new TreeSet<Activity>();
        TreeSet<ToolActivity> toolActivities = new TreeSet<ToolActivity>();
        Activity firstActivity = monitoringService.getActivityById(lesson.getLearningDesign().getFirstActivity().getActivityId());
        activities.add(firstActivity);
        activities.addAll(lesson.getLearningDesign().getActivities());
        for (Activity activity : activities) {
            if (!(activity instanceof ToolActivity)) continue;
            ToolActivity toolActivity = (ToolActivity)activity;
            toolActivities.add(toolActivity);
        }
        return toolActivities;
    }

    private boolean verify(String serverId, String datetime, String hash) throws Exception {
        try {
            ExtServer extServer = integrationService.getExtServer(serverId);
            Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)hash);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("Problem verifying external server: " + serverId), (Throwable)e);
            throw new Exception(e);
        }
    }

    private Element getActivityOutputsElement(Document document, ToolActivity activity, User learner, LearnerProgress progress, ToolSession toolSession, Map<String, ToolOutputDefinition> toolOutputDefinitions, boolean isAuthoredToolOutputs) {
        Element activityElement = document.createElement("Activity");
        activityElement.setAttribute("title", activity.getTitle());
        activityElement.setAttribute("activityId", activity.getActivityId().toString());
        if (activity.getOrderId() != null) {
            activityElement.setAttribute("orderId", activity.getOrderId().toString());
        }
        boolean activityAttempted = false;
        if (progress != null) {
            boolean completed = progress.getProgressState((Activity)activity) == 1;
            activityElement.setAttribute("completed", "" + completed);
            activityAttempted = completed || progress.getProgressState((Activity)activity) == 2;
            activityElement.setAttribute("attempted", "" + activityAttempted);
        } else {
            activityElement.setAttribute("attempted", "false");
            activityElement.setAttribute("completed", "false");
        }
        if (activityAttempted && toolSession != null) {
            for (String outputName : toolOutputDefinitions.keySet()) {
                try {
                    ToolOutputDefinition definition = toolOutputDefinitions.get(outputName);
                    if (isAuthoredToolOutputs) {
                        Set activityEvaluations = activity.getActivityEvaluations();
                        if (activityEvaluations == null) continue;
                        for (ActivityEvaluation evaluation : activityEvaluations) {
                            if (!outputName.equals(evaluation.getToolOutputDefinition())) continue;
                            ToolOutput toolOutput = toolService.getOutputFromTool(outputName, toolSession, learner.getUserId());
                            activityElement.appendChild(this.getOutputElement(document, toolOutput, definition));
                        }
                        continue;
                    }
                    ToolOutput toolOutput = toolService.getOutputFromTool(outputName, toolSession, learner.getUserId());
                    if (toolOutput == null) continue;
                    activityElement.appendChild(this.getOutputElement(document, toolOutput, definition));
                }
                catch (RuntimeException e) {
                    log.error((Object)("Runtime exception when attempted to get outputs for activity: " + activity.getActivityId() + ", continuing for other activities"), (Throwable)e);
                }
            }
        }
        return activityElement;
    }

    private Element getOutputElement(Document document, ToolOutput toolOutput, ToolOutputDefinition definition) {
        Element toolOutputElement = document.createElement("ToolOutput");
        toolOutputElement.setAttribute("name", toolOutput.getName());
        toolOutputElement.setAttribute("description", toolOutput.getDescription());
        toolOutputElement.setAttribute("output", toolOutput.getValue().getString());
        Long marksPossible = this.getTotalMarksAvailable(definition);
        toolOutputElement.setAttribute("marksPossible", marksPossible != null ? marksPossible.toString() : "");
        OutputType outputType = toolOutput.getValue().getType();
        String type = outputType == OutputType.OUTPUT_BOOLEAN ? "boolean" : (outputType == OutputType.OUTPUT_COMPLEX ? "complex" : (outputType == OutputType.OUTPUT_DOUBLE ? "double" : (outputType == OutputType.OUTPUT_LONG ? "long" : (outputType == OutputType.OUTPUT_SET_BOOLEAN ? "set_boolean" : "string"))));
        toolOutputElement.setAttribute("type", type);
        return toolOutputElement;
    }

    private Long getTotalMarksAvailable(ToolOutputDefinition definition) {
        Object upperLimit = definition.getEndValue();
        if (upperLimit != null && upperLimit instanceof Long) {
            return (Long)upperLimit;
        }
        return null;
    }

    private boolean verifyPostRequestMethod(HttpServletRequest request) throws SecurityException {
        boolean isPost = "POST".equals(request.getMethod());
        if (!isPost) {
            throw new SecurityException("This API call allows only POST request method.");
        }
        return isPost;
    }

    private Element getLessonMonitorList(Document document, String serverId, String datetime, String hashValue, String username, String courseID, String countryIsoCode, String langIsoCode) throws Exception {
        ExtServer extServer = integrationService.getExtServer(serverId);
        Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)username, (String)hashValue);
        ExtUserUseridMap userMap = integrationService.getExistingExtUserUseridMap(extServer, username);
        ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer, userMap, courseID, countryIsoCode, langIsoCode, null, "monitor");
        Organisation organisation = orgMap.getOrganisation();
        Map map = lessonService.getLessonsByOrgAndUserWithCompletedFlag(userMap.getUser().getUserId(), organisation.getOrganisationId(), Role.ROLE_MONITOR);
        Element lessonsElem = document.createElement("Lessons");
        for (IndexLessonBean bean : map.values()) {
            Element lessonElem = document.createElement("Lesson");
            lessonElem.setAttribute("lessonId", bean.getId().toString());
            lessonElem.setAttribute("name", bean.getName());
            lessonElem.setAttribute("description", bean.getDescription());
            lessonElem.setAttribute("state", bean.getState().toString());
            lessonsElem.appendChild(lessonElem);
        }
        return lessonsElem;
    }

    private class AddUsersToLessonThread
    implements Runnable {
        private String serverId;
        private String datetime;
        private String username;
        private String hashValue;
        private String lsIdStr;
        private String courseId;
        private String country;
        private String lang;
        private String learnerIds;
        private String monitorIds;
        private String firstNames;
        private String lastNames;
        private String emails;
        private HttpServletRequest request;

        public AddUsersToLessonThread(String serverId, String datetime, String username, String hashValue, String lsIdStr, String courseId, String country, String lang, String learnerIds, String monitorIds, String firstNames, String lastNames, String emails, HttpServletRequest request) {
            this.serverId = serverId;
            this.datetime = datetime;
            this.username = username;
            this.hashValue = hashValue;
            this.lsIdStr = lsIdStr;
            this.courseId = courseId;
            this.country = country;
            this.lang = lang;
            this.learnerIds = learnerIds;
            this.monitorIds = monitorIds;
            this.firstNames = firstNames;
            this.lastNames = lastNames;
            this.emails = emails;
            this.request = request;
        }

        @Override
        public void run() {
            this.addUsersToLesson(this.serverId, this.datetime, this.username, this.hashValue, this.lsIdStr, this.courseId, this.country, this.lang, this.learnerIds, this.monitorIds, this.firstNames, this.lastNames, this.emails, this.request);
        }

        public Boolean addUsersToLesson(String serverId, String datetime, String requestorUsername, String hashValue, String lsIdStr, String courseId, String countryIsoCode, String langIsoCode, String learnerIds, String monitorIds, String firstNames, String lastNames, String emails, HttpServletRequest request) {
            try {
                String email;
                String lastName;
                String firstName;
                String[] emailArray;
                ExtServer extServer = integrationService.getExtServer(serverId);
                Authenticator.authenticate((ExtServer)extServer, (String)datetime, (String)requestorUsername, (String)hashValue);
                String[] learnerIdArray = learnerIds != null ? learnerIds.split(",") : new String[]{};
                String[] monitorIdArray = monitorIds != null ? monitorIds.split(",") : new String[]{};
                String[] firstNameArray = firstNames != null ? firstNames.split(",") : new String[]{};
                String[] lastNameArray = lastNames != null ? lastNames.split(",") : new String[]{};
                String[] stringArray = emailArray = emails != null ? emails.split(",") : new String[]{};
                if (firstNames != null && (firstNameArray.length != lastNameArray.length || firstNameArray.length != emailArray.length || firstNameArray.length != learnerIdArray.length + monitorIdArray.length)) {
                    log.error((Object)("Invalid parameters sent: wrong array length. learnerIds=" + learnerIds + " &monitorIds=" + monitorIds + " &firstNames=" + firstNames + " &lastNames=" + lastNames + " &emails=" + emails + " &array lengths=" + learnerIdArray.length + "!" + monitorIdArray.length + "!" + firstNameArray.length + "!" + lastNameArray.length + "!" + emailArray.length));
                    return false;
                }
                int i = 0;
                for (String userName : learnerIdArray) {
                    firstName = null;
                    lastName = null;
                    email = null;
                    if (firstNames != null) {
                        firstName = firstNameArray[i];
                        lastName = lastNameArray[i];
                        email = emailArray[i];
                    }
                    if (StringUtils.isNotBlank((String)userName)) {
                        this.addUserToLesson(request, extServer, "learner", lsIdStr, userName, firstName, lastName, email, courseId, countryIsoCode, langIsoCode);
                    }
                    ++i;
                }
                for (String userName : monitorIdArray) {
                    firstName = null;
                    lastName = null;
                    email = null;
                    if (firstNames != null) {
                        firstName = firstNameArray[i];
                        lastName = lastNameArray[i];
                        email = emailArray[i];
                    }
                    if (StringUtils.isNotBlank((String)userName)) {
                        this.addUserToLesson(request, extServer, "monitor", lsIdStr, userName, firstName, lastName, email, courseId, countryIsoCode, langIsoCode);
                    }
                    ++i;
                }
                return true;
            }
            catch (UserInfoFetchException e) {
                log.error((Object)e, (Throwable)e);
                return false;
            }
            catch (UserInfoValidationException e) {
                log.error((Object)e, (Throwable)e);
                return false;
            }
            catch (AuthenticationException e) {
                log.error((Object)e, (Throwable)e);
                return false;
            }
        }

        private void addUserToLesson(HttpServletRequest request, ExtServer extServer, String method, String lsIdStr, String username, String firstName, String lastName, String email, String courseId, String countryIsoCode, String langIsoCode) throws UserInfoFetchException, UserInfoValidationException {
            User user;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding user '" + username + "' as " + method + " to lesson with id '" + lsIdStr + "'."));
            }
            ExtUserUseridMap userMap = null;
            if (firstName == null && lastName == null) {
                userMap = integrationService.getExtUserUseridMap(extServer, username);
            } else {
                boolean usePrefix = true;
                boolean isUpdateUserDetails = false;
                userMap = integrationService.getImplicitExtUserUseridMap(extServer, username, firstName, lastName, langIsoCode, countryIsoCode, email, true, false);
            }
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(extServer, userMap, courseId, countryIsoCode, langIsoCode, null, method);
            if (lessonService == null) {
                lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("lessonService");
            }
            if ((user = userMap.getUser()) == null) {
                String error = "Unable to add user to lesson class as user is missing from the user map";
                log.error((Object)error);
                throw new UserInfoFetchException(error);
            }
            if ("learner".equals(method)) {
                lessonService.addLearner(Long.valueOf(Long.parseLong(lsIdStr)), user.getUserId());
            } else if ("monitor".equals(method)) {
                lessonService.addStaffMember(Long.valueOf(Long.parseLong(lsIdStr)), user.getUserId());
            }
        }
    }
}

