/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;

public class RequestSchemeAttribute
implements ExchangeAttribute {
    public static final String REQUEST_SCHEME = "%{SCHEME}";
    public static final ExchangeAttribute INSTANCE = new RequestSchemeAttribute();

    private RequestSchemeAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return exchange.getRequestScheme();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Request scheme", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request scheme";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RequestSchemeAttribute.REQUEST_SCHEME)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

