/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.dbupdates;

import com.tacitknowledge.util.migration.MigrationContext;
import com.tacitknowledge.util.migration.MigrationException;
import com.tacitknowledge.util.migration.MigrationTaskSupport;
import com.tacitknowledge.util.migration.jdbc.DataSourceMigrationContext;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Patch0016FixWorkspacePublicFolder
extends MigrationTaskSupport {
    private static Logger log = Logger.getLogger(Patch0016FixWorkspacePublicFolder.class);
    private static final Integer LEVEL = new Integer(16);
    private static final String NAME = "FixWkspcPublicFolder";
    private String insertWorkspacePublicFolder = "INSERT INTO lams_workspace_folder (parent_folder_id,name,user_id,create_date_time,last_modified_date_time,lams_workspace_folder_type_id) values(?,?,?,?,?,?);";
    private String insertNewWorkspace = "INSERT INTO lams_workspace (name, default_fld_id) values(?,?)";
    private String insertNewWkspcWkspcFolder = "INSERT INTO lams_wkspc_wkspc_folder (workspace_id, workspace_folder_id) values (?,?)";

    public Patch0016FixWorkspacePublicFolder() {
        this.setLevel(LEVEL);
        this.setName(NAME);
    }

    public void migrate(MigrationContext context) throws MigrationException {
        DataSourceMigrationContext ctx = (DataSourceMigrationContext)context;
        Connection conn = null;
        try {
            conn = ctx.getConnection();
            conn.setAutoCommit(false);
            String i18nMessage = this.getI18nMessage(conn);
            PreparedStatement query = conn.prepareStatement(this.insertWorkspacePublicFolder, 1);
            query.setLong(1, new Long(1L));
            query.setString(2, i18nMessage);
            query.setLong(3, new Long(1L));
            query.setDate(4, new Date(System.currentTimeMillis()));
            query.setDate(5, new Date(System.currentTimeMillis()));
            query.setInt(6, new Integer(3));
            int numUpdatedWorkspaces = query.executeUpdate();
            ResultSet results = query.getGeneratedKeys();
            log.info((Object)("Inserted " + numUpdatedWorkspaces + " new workspace folder."));
            long wkspcFolderId = -1L;
            if (results.next()) {
                wkspcFolderId = results.getLong(1);
            }
            query = conn.prepareStatement(this.insertNewWorkspace, 1);
            query.setString(1, i18nMessage);
            query.setLong(2, wkspcFolderId);
            numUpdatedWorkspaces = query.executeUpdate();
            results = query.getGeneratedKeys();
            log.info((Object)("Inserted " + numUpdatedWorkspaces + " new workspace."));
            long wkspcId = -1L;
            if (results.next()) {
                wkspcId = results.getLong(1);
            }
            query = conn.prepareStatement(this.insertNewWkspcWkspcFolder);
            query.setLong(1, wkspcId);
            query.setLong(2, wkspcFolderId);
            numUpdatedWorkspaces = query.executeUpdate();
            log.info((Object)("Inserted " + numUpdatedWorkspaces + " wkspc_wkspc_folder links."));
            ctx.commit();
        }
        catch (Exception e) {
            ctx.rollback();
            throw new MigrationException("Problem running update; ", (Throwable)e);
        }
    }

    private String getI18nMessage(Connection conn) throws MigrationException {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/lamsfoundation/lams/messageContext.xml");
        MessageService messageService = (MessageService)context.getBean("commonMessageService");
        String defaultLocale = "en_AU";
        String getDefaultLocaleStmt = "select config_value from lams_configuration where config_key='ServerLanguage'";
        try {
            PreparedStatement query = conn.prepareStatement(getDefaultLocaleStmt);
            ResultSet results = query.executeQuery();
            while (results.next()) {
                defaultLocale = results.getString("config_value");
            }
        }
        catch (Exception e) {
            throw new MigrationException("Problem running update; ", (Throwable)e);
        }
        String[] tokenisedLocale = defaultLocale.split("_");
        Locale locale = new Locale(tokenisedLocale[0], tokenisedLocale[1]);
        MessageSource messageSource = messageService.getMessageSource();
        String i18nMessage = messageSource.getMessage("public.folder.name", null, locale);
        if (i18nMessage != null && i18nMessage.startsWith("???")) {
            return "Public Folder";
        }
        return i18nMessage;
    }
}

