/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.DeliveryMethodMail;
import org.lamsfoundation.lams.events.Event;
import org.lamsfoundation.lams.events.IEventNotificationService;
import org.lamsfoundation.lams.events.Subscription;
import org.lamsfoundation.lams.events.dao.EventDAO;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.hibernate.HibernateSessionManager;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EventNotificationService
implements IEventNotificationService {
    private static final Logger log = Logger.getLogger(EventNotificationService.class);
    private EventDAO eventDAO = null;
    private MessageService messageService = null;
    private ILessonService lessonService = null;
    private ILamsToolService toolService = null;
    private IUserManagementService userManagementService = null;

    @Override
    public void createEvent(String scope, String name, Long eventSessionId, String defaultSubject, String defaultMessage, boolean isHtmlFormat) {
        if (!this.eventExists(scope, name, eventSessionId)) {
            Event event = new Event(scope, name, eventSessionId, defaultSubject, defaultMessage, isHtmlFormat);
            this.eventDAO.insertOrUpdate(event);
        }
    }

    @Override
    public void createLessonEvent(String scope, String name, Long toolContentId, String defaultSubject, String defaultMessage, boolean isHtmlFormat, AbstractDeliveryMethod deliveryMethod) throws InvalidParameterException {
        Lesson lesson = this.getLessonByToolContentId(toolContentId);
        if (!this.eventExists(scope, name, lesson.getLessonId())) {
            Event event = new Event(scope, name, lesson.getLessonId(), defaultSubject, defaultMessage, isHtmlFormat);
            Set<User> users = null;
            if (scope.equals("LESSON_MONITORS")) {
                users = lesson.getLessonClass().getStaffGroup().getUsers();
            } else if (scope.equals("LESSON_LEARNERS")) {
                users = lesson.getLessonClass().getLearners();
            }
            if (users != null) {
                for (User user : users) {
                    event.getSubscriptions().add(new Subscription(user.getUserId(), deliveryMethod));
                }
                this.eventDAO.insert(event);
            }
        }
    }

    @Override
    public boolean eventExists(String scope, String name, Long eventSessionId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        return this.eventDAO.getEvent(scope, name, eventSessionId) != null;
    }

    @Override
    public Set<AbstractDeliveryMethod> getAvailableDeliveryMethods() {
        return IEventNotificationService.availableDeliveryMethods;
    }

    @Override
    public boolean isSubscribed(String scope, String name, Long eventSessionId, Long userId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event != null) {
            for (Subscription subscription : event.getSubscriptions()) {
                if (!subscription.getUserId().equals(userId.intValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyLessonMonitors(Long lessonId, String subject, String message, boolean isHtmlFormat) {
        Map<User, Boolean> monitoringUsers = this.lessonService.getUsersWithLessonParticipation(lessonId, "MONITOR", null, null, null, true);
        if (monitoringUsers.isEmpty()) {
            return;
        }
        ArrayList<Integer> monitoringUsersIds = new ArrayList<Integer>();
        for (Map.Entry<User, Boolean> entry : monitoringUsers.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            monitoringUsersIds.add(entry.getKey().getUserId());
        }
        this.sendMessage(null, monitoringUsersIds.toArray(new Integer[monitoringUsersIds.size()]), (AbstractDeliveryMethod)IEventNotificationService.DELIVERY_METHOD_MAIL, subject, message, isHtmlFormat);
    }

    @Override
    public void notifyLessonMonitors(Long sessionId, String message, boolean isHtmlFormat) {
        List<User> monitoringUsers = this.lessonService.getMonitorsByToolSessionId(sessionId);
        if (monitoringUsers.isEmpty()) {
            return;
        }
        Integer[] monitoringUsersIds = new Integer[monitoringUsers.size()];
        for (int i = 0; i < monitoringUsersIds.length; ++i) {
            monitoringUsersIds[i] = monitoringUsers.get(i).getUserId();
        }
        ToolSession toolSession = this.toolService.getToolSession(sessionId);
        Lesson lesson = toolSession.getLesson();
        ToolActivity toolActivity = toolSession.getToolActivity();
        String lessonName = lesson.getLessonName();
        String activityTitle = toolActivity.getTitle();
        String toolName = toolActivity.getTool().getToolDisplayName();
        String emailSubject = toolName + " " + this.messageService.getMessage("email.notifications.tool") + ": " + activityTitle + " " + this.messageService.getMessage("email.notifications.activity") + " - " + lessonName + " " + this.messageService.getMessage("email.notifications.lesson");
        String courseName = lesson.getOrganisation().getName();
        String serverUrl = Configuration.get(ConfigurationKeys.SERVER_URL).trim();
        String emailBody = this.messageService.getMessage("email.notifications.course") + ": " + courseName + '\n' + this.messageService.getMessage("email.notifications.lesson.caption") + ": " + lessonName + "\n\n" + message + "\n\n" + serverUrl;
        this.sendMessage(null, monitoringUsersIds, (AbstractDeliveryMethod)IEventNotificationService.DELIVERY_METHOD_MAIL, emailSubject, emailBody, isHtmlFormat);
    }

    public void notifyUser(Subscription subscription, String subject, String message, boolean isHtmlFormat) {
        log.debug((Object)("EventNotificationService notifyUser " + this.toString()));
        subscription.setLastOperationMessage(subscription.getDeliveryMethod().send(null, subscription.getUserId(), subject, message, isHtmlFormat));
    }

    @Override
    public void resendMessages() {
        try {
            log.debug((Object)"The resend messages thread is running..");
            List<Event> events = this.eventDAO.getEventsToResend();
            for (Event event : events) {
                this.trigger(event, null, null);
                if (event.getFailTime() == null || event.getSubscriptions().isEmpty() || System.currentTimeMillis() - event.getFailTime().getTime() < 172800000L) continue;
                StringBuilder body = new StringBuilder(this.messageService.getMessage("mail.resend.abandon.body1")).append(event.getMessage()).append(this.messageService.getMessage("mail.resend.abandon.body2"));
                for (Subscription subscription : event.getSubscriptions()) {
                    User user = (User)this.userManagementService.findById(User.class, subscription.getUserId());
                    body.append(user.getLogin()).append('\n');
                }
                IEventNotificationService.DELIVERY_METHOD_MAIL.notifyAdmin(this.messageService.getMessage("mail.resend.abandon.subject"), body.toString(), event.isHtmlFormat());
                this.eventDAO.delete(event);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while resending messages", (Throwable)e);
        }
    }

    @Override
    public boolean sendMessage(Integer fromUserId, Integer toUserId, AbstractDeliveryMethod deliveryMethod, String subject, String message, boolean isHtmlFormat) throws InvalidParameterException {
        String result = deliveryMethod.send(fromUserId, toUserId, subject, message, isHtmlFormat);
        if (result == null) {
            return true;
        }
        Event event = new Event("SINGLE_MESSAGE", String.valueOf(System.currentTimeMillis()), null, subject, message, isHtmlFormat, new Date());
        this.subscribe(event, toUserId, deliveryMethod);
        this.eventDAO.insertOrUpdate(event);
        return false;
    }

    @Override
    public void sendMessage(Integer fromUserId, Integer[] toUserIds, AbstractDeliveryMethod deliveryMethod, String subject, String message, boolean isHtmlFormat) throws InvalidParameterException {
        if (toUserIds == null) {
            throw new InvalidParameterException("User IDs array must not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method must not be null.");
        }
        new Thread(() -> {
            try {
                HibernateSessionManager.openSession();
                WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)SessionManager.getServletContext());
                IEventNotificationService eventNotificationService = (IEventNotificationService)ctx.getBean("eventNotificationService");
                for (Integer id : toUserIds) {
                    eventNotificationService.sendMessage(fromUserId, id, deliveryMethod, subject, message, isHtmlFormat);
                }
            }
            finally {
                HibernateSessionManager.closeSession();
            }
        }).start();
    }

    @Override
    public List<Subscription> getNotificationSubscriptions(Long lessonId, Integer userId, boolean pendingOnly, Integer limit, Integer offset) {
        return this.eventDAO.getLessonEventSubscriptions(lessonId, userId, pendingOnly, limit, offset);
    }

    @Override
    public long getNotificationPendingCount(Long lessonId, Integer userId) {
        return this.eventDAO.getPendingNotificationCount(lessonId, userId);
    }

    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    public void setLessonService(ILessonService lessonService) {
        this.lessonService = lessonService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
        DeliveryMethodMail.setUserManagementService(userManagementService);
    }

    private void subscribe(Event event, Integer userId, AbstractDeliveryMethod deliveryMethod) throws InvalidParameterException {
        if (userId == null) {
            throw new InvalidParameterException("User ID can not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method can not be null.");
        }
        boolean substriptionFound = false;
        ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>(event.getSubscriptions());
        for (int index = 0; index < subscriptionList.size(); ++index) {
            Subscription subscription = (Subscription)subscriptionList.get(index);
            if (!subscription.getUserId().equals(userId) || !subscription.getDeliveryMethod().equals(deliveryMethod)) continue;
            substriptionFound = true;
            break;
        }
        if (!substriptionFound) {
            event.getSubscriptions().add(new Subscription(userId, deliveryMethod));
        }
        this.eventDAO.insertOrUpdate(event);
    }

    @Override
    public void subscribe(String scope, String name, Long eventSessionId, Integer userId, AbstractDeliveryMethod deliveryMethod) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method should not be null.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        this.subscribe(event, userId, deliveryMethod);
    }

    private void trigger(Event event, String subject, String message) {
        String subjectToSend = subject == null ? event.getSubject() : subject;
        String messageToSend = message == null ? event.getMessage() : message;
        new Thread(() -> {
            try {
                HibernateSessionManager.openSession();
                WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)SessionManager.getServletContext());
                IEventNotificationService eventNotificationService = (IEventNotificationService)ctx.getBean("eventNotificationService");
                eventNotificationService.triggerInternal(event, subjectToSend, messageToSend);
            }
            finally {
                HibernateSessionManager.closeSession();
            }
        }).start();
    }

    @Override
    public void triggerInternal(Event eventData, String subject, String message) {
        Event event = (Event)this.eventDAO.find(Event.class, eventData.getUid());
        Event eventFailCopy = null;
        Iterator<Subscription> subscriptionIterator = event.getSubscriptions().iterator();
        while (subscriptionIterator.hasNext()) {
            Subscription subscription = subscriptionIterator.next();
            this.notifyUser(subscription, subject, message, event.isHtmlFormat());
            if (!subscription.getDeliveryMethod().lastOperationFailed(subscription)) {
                if (event.getFailTime() == null) continue;
                subscriptionIterator.remove();
                continue;
            }
            if (event.getFailTime() != null) continue;
            if (eventFailCopy == null) {
                eventFailCopy = (Event)event.clone();
            }
            this.subscribe(eventFailCopy, subscription.getUserId(), subscription.getDeliveryMethod());
        }
        if (event.getSubscriptions().isEmpty()) {
            log.debug((Object)("Deleting event " + event.getUid() + " " + event.getFailTime()));
            this.eventDAO.delete(event);
        } else {
            this.eventDAO.insertOrUpdate(event);
        }
        if (eventFailCopy != null) {
            eventFailCopy.setFailTime(new Date());
            eventFailCopy.setSubject(subject);
            eventFailCopy.setMessage(message);
            this.eventDAO.insertOrUpdate(eventFailCopy);
        }
    }

    @Override
    public void trigger(String scope, String name, Long eventSessionId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        this.trigger(event, null, null);
    }

    @Override
    public void trigger(String scope, String name, Long eventSessionId, Object[] parameterValues) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        String message = event.getMessage();
        if (parameterValues != null && parameterValues.length > 0) {
            for (int index = 0; index < parameterValues.length; ++index) {
                Object value = parameterValues[index];
                String replacement = value == null ? "" : value.toString();
                message = message.replace("{" + index + "}", replacement);
            }
        }
        this.trigger(event, null, message);
    }

    @Override
    public void triggerLessonEvent(String scope, String name, Long toolContentId, String subject, String message) {
        Lesson lesson = this.getLessonByToolContentId(toolContentId);
        this.trigger(scope, name, lesson.getLessonId(), subject, message);
    }

    @Override
    public void trigger(String scope, String name, Long eventSessionId, String title, String message) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        this.trigger(event, title, message);
    }

    private void triggerForSingleUser(Event event, Integer userId, String subject, String message) {
        for (Subscription subscription : event.getSubscriptions()) {
            if (!subscription.getUserId().equals(userId)) continue;
            this.triggerForSingleUser(subscription.getUid(), subject, message);
        }
    }

    @Override
    public void triggerForSingleUser(Long subscriptionUid, String subject, String message) {
        Subscription subscription = (Subscription)this.eventDAO.find(Subscription.class, subscriptionUid);
        Event event = subscription.getEvent();
        String subjectToSend = subject == null ? event.getSubject() : subject;
        String messageToSend = message == null ? event.getMessage() : message;
        this.notifyUser(subscription, subjectToSend, messageToSend, event.isHtmlFormat());
        if (subscription.getDeliveryMethod().lastOperationFailed(subscription)) {
            Event eventFailCopy = (Event)event.clone();
            eventFailCopy.setFailTime(new Date());
            eventFailCopy.setSubject(subjectToSend);
            eventFailCopy.setMessage(messageToSend);
            this.subscribe(eventFailCopy, subscription.getUserId(), subscription.getDeliveryMethod());
            this.eventDAO.insertOrUpdate(eventFailCopy);
        }
    }

    @Override
    public void triggerForSingleUser(String scope, String name, Long eventSessionId, Integer userId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        this.triggerForSingleUser(event, userId, null, null);
    }

    @Override
    public void triggerForSingleUser(String scope, String name, Long eventSessionId, Integer userId, Object[] parameterValues) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        String message = event.getMessage();
        if (parameterValues != null && parameterValues.length > 0) {
            for (int index = 0; index < parameterValues.length; ++index) {
                Object value = parameterValues[index];
                String replacement = value == null ? "" : value.toString();
                message = message.replace("{" + index + "}", replacement);
            }
        }
        this.triggerForSingleUser(event, userId, null, message);
    }

    @Override
    public void triggerForSingleUser(String scope, String name, Long eventSessionId, Integer userId, String subject, String message) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        this.triggerForSingleUser(event, userId, subject, message);
    }

    protected void unsubscribe(Event event, Integer userId) throws InvalidParameterException {
        if (userId == null) {
            throw new InvalidParameterException("User ID can not be null.");
        }
        Iterator<Subscription> subscriptionIterator = event.getSubscriptions().iterator();
        while (subscriptionIterator.hasNext()) {
            Subscription subscription = subscriptionIterator.next();
            if (!subscription.getUserId().equals(userId)) continue;
            subscriptionIterator.remove();
        }
        if (event.getSubscriptions().isEmpty()) {
            this.eventDAO.delete(event);
        } else {
            this.eventDAO.insertOrUpdate(event);
        }
    }

    protected void unsubscribe(Event event, Integer userId, AbstractDeliveryMethod deliveryMethod) throws InvalidParameterException {
        if (userId == null) {
            throw new InvalidParameterException("User ID can not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method can not be null.");
        }
        Iterator<Subscription> subscriptionIterator = event.getSubscriptions().iterator();
        while (subscriptionIterator.hasNext()) {
            Subscription subscription = subscriptionIterator.next();
            if (!subscription.getUserId().equals(userId) || !subscription.getDeliveryMethod().equals(deliveryMethod)) continue;
            subscriptionIterator.remove();
        }
        if (event.getSubscriptions().isEmpty()) {
            this.eventDAO.delete(event);
        } else {
            this.eventDAO.insertOrUpdate(event);
        }
    }

    @Override
    public void unsubscribe(String scope, String name, Long eventSessionId, Integer userId) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        this.unsubscribe(event, userId);
    }

    @Override
    public void unsubscribe(String scope, String name, Long eventSessionId, Integer userId, AbstractDeliveryMethod deliveryMethod) throws InvalidParameterException {
        if (scope == null) {
            throw new InvalidParameterException("Scope should not be null.");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new InvalidParameterException("Name should not be blank.");
        }
        if (userId == null) {
            throw new InvalidParameterException("User ID should not be null.");
        }
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery nethod should not be null.");
        }
        Event event = this.eventDAO.getEvent(scope, name, eventSessionId);
        if (event == null) {
            throw new InvalidParameterException("An event with the given parameters does not exist.");
        }
        this.unsubscribe(event, userId, deliveryMethod);
    }

    private Lesson getLessonByToolContentId(Long toolContentId) {
        ToolActivity activity = (ToolActivity)this.eventDAO.findByProperty(ToolActivity.class, "toolContentId", toolContentId).get(0);
        return (Lesson)activity.getLearningDesign().getLessons().iterator().next();
    }

    static {
        IEventNotificationService.availableDeliveryMethods.add(IEventNotificationService.DELIVERY_METHOD_MAIL);
        IEventNotificationService.availableDeliveryMethods.add(IEventNotificationService.DELIVERY_METHOD_NOTIFICATION);
    }
}

