/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.security;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import io.undertow.Handlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.util.Headers;
import java.io.IOException;
import java.security.AccessController;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.usermanagement.service.UserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SsoHandler
implements ServletExtension {
    private static ILogEventService logEventService = null;
    private static IUserManagementService userManagementService = null;
    private static final String REDIRECT_KEY = "io.undertow.servlet.form.auth.redirect.location";
    static final String KEEP_SESSION_ID_KEY = "lams.keepSessionId";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        boolean keepSessionId = Boolean.parseBoolean(System.getProperty(KEEP_SESSION_ID_KEY));
        if (keepSessionId) {
            deploymentInfo.setChangeSessionIdOnLogin(false);
        }
        SessionManager.setServletContext(servletContext);
        deploymentInfo.addOuterHandlerChainWrapper(handler -> Handlers.path().addPrefixPath("/", handler).addExactPath("/j_security_check", exchange -> {
            Integer failedAttempts;
            ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            HttpServletResponse response = (HttpServletResponse)context.getServletResponse();
            HttpServletRequest request = (HttpServletRequest)context.getServletRequest();
            if (SessionManager.getJvmRoute() == null) {
                SsoHandler.setJvmRoute(request);
            }
            HttpSession session = request.getSession();
            String login = request.getParameter("j_username");
            User user = null;
            if (StringUtils.isBlank((String)login)) {
                SsoHandler.serveLoginPage(exchange, request, response, "/login.jsp?failed=true");
                return;
            }
            user = this.getUserManagementService(session.getServletContext()).getUserByLogin(login);
            if (user == null) {
                SsoHandler.serveLoginPage(exchange, request, response, "/login.jsp?failed=true");
                return;
            }
            UserDTO userDTO = user.getUserDTO();
            String password = request.getParameter("j_password");
            if (user.getLockOutTime() != null && user.getLockOutTime().getTime() > System.currentTimeMillis() && password != null && !password.startsWith("#LAMS")) {
                SsoHandler.serveLoginPage(exchange, request, response, "/login.jsp?lockedOut=true");
                return;
            }
            String redirectURL = request.getParameter("redirectURL");
            if (!StringUtils.isBlank((String)redirectURL)) {
                SsoHandler.handleRedirectBack(context, redirectURL);
            }
            if (request.getRemoteUser() == null && user.isTwoFactorAuthenticationEnabled().booleanValue() && user.getTwoFactorAuthenticationSecret() != null) {
                String verificationCodeStr = request.getParameter("verificationCode");
                int verificationCode = NumberUtils.toInt((String)verificationCodeStr);
                GoogleAuthenticator gAuth = new GoogleAuthenticator();
                boolean isCodeValid = gAuth.authorize(user.getTwoFactorAuthenticationSecret(), verificationCode);
                if (!isCodeValid) {
                    session.setAttribute("login", (Object)login);
                    session.setAttribute("password", (Object)password);
                    String redirectUrl = "/lams/loginTwoFactorAuth.jsp" + (verificationCodeStr == null ? "" : "?failed=true");
                    response.sendRedirect(redirectUrl);
                    return;
                }
            }
            HttpSession existingSession = SessionManager.getSessionForLogin(login);
            SessionManager.startSession(request);
            String oldSessionID = session.getId();
            handler.handleRequest(exchange);
            SessionManager.updateSessionID(oldSessionID);
            if (login.equals(request.getRemoteUser())) {
                session.setAttribute("user", (Object)userDTO);
                if (existingSession != null) {
                    SessionManager.removeSessionByID(existingSession.getId(), true, false);
                }
                if ((failedAttempts = user.getFailedAttempts()) != null && failedAttempts > 0 && password != null && !password.startsWith("#LAMS")) {
                    user.setFailedAttempts(null);
                    user.setLockOutTime(null);
                    this.getUserManagementService(session.getServletContext()).save(user);
                }
            } else {
                failedAttempts = user.getFailedAttempts();
                if (failedAttempts == null) {
                    failedAttempts = 1;
                } else {
                    Integer isCodeValid = failedAttempts;
                    Integer redirectUrl = failedAttempts = Integer.valueOf(failedAttempts + 1);
                }
                user.setFailedAttempts(failedAttempts);
                Integer failedAttemptsConfig = Configuration.getAsInt(ConfigurationKeys.FAILED_ATTEMPTS);
                if (failedAttempts >= failedAttemptsConfig) {
                    Integer lockOutTimeConfig = Configuration.getAsInt(ConfigurationKeys.LOCK_OUT_TIME);
                    Long lockOutTimeMillis = (long)lockOutTimeConfig.intValue() * 60L * 1000L;
                    Long currentTimeMillis = System.currentTimeMillis();
                    Date date = new Date(currentTimeMillis + lockOutTimeMillis);
                    user.setLockOutTime(date);
                    String message = "User " + user.getLogin() + "(" + user.getUserId() + ") is locked out for " + Configuration.getAsInt(ConfigurationKeys.LOCK_OUT_TIME) + " mins after " + failedAttempts + " failed attempts.";
                    this.getLogEventService(session.getServletContext()).logEvent(15, user.getUserId(), user.getUserId(), null, null, message);
                }
                this.getUserManagementService(session.getServletContext()).save(user);
            }
            SessionManager.endSession();
        }));
    }

    private static Integer serveLoginPage(HttpServerExchange exchange, HttpServletRequest request, HttpServletResponse response, String location) throws ServletException, IOException {
        exchange.getResponseHeaders().add(Headers.CACHE_CONTROL, "no-cache, no-store, must-revalidate");
        exchange.getResponseHeaders().add(Headers.PRAGMA, "no-cache");
        exchange.getResponseHeaders().add(Headers.EXPIRES, "0");
        request.getRequestDispatcher(location).forward((ServletRequest)request, (ServletResponse)response);
        return null;
    }

    private static void handleRedirectBack(ServletRequestContext context, String redirectURL) {
        if (redirectURL.contains("\n") || redirectURL.contains("\r")) {
            throw new SecurityException("redirectURL contains forbidden characters: \\n or \\r. Possible HTTP Response Splitting attack.");
        }
        HttpSessionImpl httpSession = context.getCurrentServletContext().getSession(context.getExchange(), true);
        if (httpSession != null) {
            Session session = System.getSecurityManager() == null ? httpSession.getSession() : (Session)AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction((HttpSession)httpSession));
            session.setAttribute(REDIRECT_KEY, (Object)redirectURL);
        }
    }

    private static void setJvmRoute(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            int index;
            if (!cookie.getName().equals("JSESSIONID") || (index = cookie.getValue().indexOf(46)) <= 0) continue;
            SessionManager.setJvmRoute(cookie.getValue().substring(index + 1));
            return;
        }
    }

    private IUserManagementService getUserManagementService(ServletContext context) {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            userManagementService = (UserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    protected ILogEventService getLogEventService(ServletContext context) {
        if (logEventService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)context);
            logEventService = (ILogEventService)ctx.getBean("logEventService");
        }
        return logEventService;
    }
}

