/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.AlphanumComparator;

public class GroupDTO {
    public static final Comparator<GroupDTO> GROUP_NAME_COMPARATOR = new Comparator<GroupDTO>(){

        @Override
        public int compare(GroupDTO grp1, GroupDTO grp2) {
            String grp1Name = grp1 != null ? grp1.getGroupName() : "";
            String grp2Name = grp2 != null ? grp2.getGroupName() : "";
            AlphanumComparator comparator = new AlphanumComparator();
            return comparator.compare(grp1Name, grp2Name);
        }
    };
    private Long groupID;
    private String groupName;
    private int orderID;
    private List userList;
    private Integer groupUIID;

    public GroupDTO(Group group, boolean setupUserList) {
        this.groupID = group.getGroupId();
        this.groupName = group.getGroupName();
        this.orderID = group.getOrderId();
        this.groupUIID = group.getGroupUIID();
        this.userList = new ArrayList();
        if (setupUserList && group.getUsers() != null) {
            Iterator<User> iter = group.getUsers().iterator();
            while (iter.hasNext()) {
                this.userList.add(iter.next().getUserBasicDTO());
            }
        }
    }

    public Long getGroupID() {
        return this.groupID;
    }

    public void setGroupID(Long groupID) {
        this.groupID = groupID;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getOrderID() {
        return this.orderID;
    }

    public void setOrderID(int orderID) {
        this.orderID = orderID;
    }

    public Integer getGroupUIID() {
        return this.groupUIID;
    }

    public void setGroupUIID(Integer groupUIID) {
        this.groupUIID = groupUIID;
    }

    public List getUserList() {
        return this.userList;
    }

    public void setUserList(List userList) {
        this.userList = userList;
    }
}

