/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.security.ISecurityDAO;
import org.lamsfoundation.lams.security.ISecurityService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationType;

public class SecurityService
implements ISecurityService {
    private static Logger log = Logger.getLogger(SecurityService.class);
    private static final String[] GROUP_MONITOR_ROLES = new String[]{"GROUP MANAGER", "MONITOR"};
    private static final List<String> GROUP_SUPER_ROLES = Collections.unmodifiableList(Arrays.asList("GROUP ADMIN", "GROUP MANAGER"));
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ISecurityDAO securityDAO;
    private ILogEventService logEventService;

    @Override
    public boolean isLessonLearner(Long lessonId, Integer userId, String action, boolean escalate) throws SecurityException {
        boolean hasOrgRole;
        if (lessonId == null) {
            String error = "Missing lesson ID when checking if user " + userId + " is learner and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if is learner in lesson " + lessonId + " and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Lesson lesson = (Lesson)this.securityDAO.find(Lesson.class, lessonId);
        if (lesson == null) {
            String error = "Could not find lesson " + lessonId + " when checking if user " + userId + " is learner and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Organisation org = lesson.getOrganisation();
        Integer orgId = org == null ? null : org.getOrganisationId();
        boolean hasSysadminRole = this.securityDAO.isSysadmin(userId);
        boolean bl = hasOrgRole = orgId == null || this.securityDAO.hasOrgRole(orgId, userId, "LEARNER");
        if (!(hasSysadminRole || hasOrgRole && this.securityDAO.isLessonLearner(lessonId, userId))) {
            String error = "User " + userId + " is not learner in lesson " + lessonId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isLessonMonitor(Long lessonId, Integer userId, String action, boolean escalate) throws SecurityException {
        boolean hasMonitorRole;
        if (lessonId == null) {
            String error = "Missing lesson ID when checking if user " + userId + " is monitor and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if is monitor in lesson " + lessonId + " and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Lesson lesson = (Lesson)this.securityDAO.find(Lesson.class, lessonId);
        if (lesson == null) {
            String error = "Could not find lesson " + lessonId + " when checking if user " + userId + " is monitor and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Organisation org = lesson.getOrganisation();
        Integer orgId = org == null ? null : org.getOrganisationId();
        boolean hasSysadminRole = this.securityDAO.isSysadmin(userId);
        boolean hasGroupManagerRole = hasSysadminRole || orgId != null && this.securityDAO.isGroupManager(orgId, userId);
        boolean bl = hasMonitorRole = hasGroupManagerRole || orgId == null || this.securityDAO.hasOrgRole(orgId, userId, "MONITOR");
        if (!(hasGroupManagerRole || hasMonitorRole && this.securityDAO.isLessonMonitor(lessonId, userId, true))) {
            String error = "User " + userId + " is not monitor in lesson " + lessonId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isLessonOwner(Long lessonId, Integer userId, String action, boolean escalate) throws SecurityException {
        if (lessonId == null) {
            String error = "Missing lesson ID when checking if user " + userId + " is owner and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if is owner of lesson " + lessonId + " and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Lesson lesson = (Lesson)this.securityDAO.find(Lesson.class, lessonId);
        if (lesson == null) {
            String error = "Could not find lesson " + lessonId + " when checking if user " + userId + " is owner and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (!lesson.getUser().getUserId().equals(userId)) {
            String error = "User " + userId + " is not owner of lesson " + lessonId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isLessonParticipant(Long lessonId, Integer userId, String action, boolean escalate) throws SecurityException {
        boolean hasRole;
        if (lessonId == null) {
            String error = "Missing lesson ID when checking if user " + userId + " is participant and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if is participant in lesson " + lessonId + " and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Lesson lesson = (Lesson)this.securityDAO.find(Lesson.class, lessonId);
        if (lesson == null) {
            String error = "Could not find lesson " + lessonId + " when checking if user " + userId + " is participant and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        Organisation org = lesson.getOrganisation();
        Integer orgId = org == null ? null : org.getOrganisationId();
        boolean hasSysadminRole = this.securityDAO.isSysadmin(userId);
        boolean hasGroupManagerRole = hasSysadminRole || orgId != null && this.securityDAO.isGroupManager(orgId, userId);
        boolean bl = hasRole = hasGroupManagerRole || orgId == null || this.securityDAO.hasOrgRole(orgId, userId, "LEARNER", "MONITOR");
        if (!(hasGroupManagerRole || hasRole && (this.securityDAO.isLessonLearner(lessonId, userId) || this.securityDAO.isLessonMonitor(lessonId, userId, true)))) {
            String error = "User " + userId + " is not participant in lesson " + lessonId + " and can not \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, lessonId, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSysadmin(Integer userId, String action, boolean escalate) {
        if (userId == null) {
            String error = "Missing user ID when checking if is sysadmin and can \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, null, null, error);
            throw new SecurityException(error);
        }
        if (!this.securityDAO.isSysadmin(userId)) {
            String error = "User " + userId + " is not sysadmin and can not \"" + action + "\"";
            log.error((Object)error);
            this.logEventService.logEvent(14, userId, userId, null, null, error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isGroupMonitor(Integer orgId, Integer userId, String action, boolean escalate) throws SecurityException {
        return this.hasOrgRole(orgId, userId, GROUP_MONITOR_ROLES, action, escalate);
    }

    @Override
    public boolean hasOrgRole(Integer orgId, Integer userId, String[] roles, String action, boolean escalate) throws SecurityException {
        if (orgId == null) {
            String error = "Missing organisation ID when checking if user " + userId + " has any of " + Arrays.toString(roles) + " roles in organisation " + orgId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        if (userId == null) {
            String error = "Missing user ID when checking if has any of " + Arrays.toString(roles) + " roles in organisation " + orgId + " and can \"" + action + "\"";
            log.error((Object)error);
            if (escalate) {
                throw new SecurityException(error);
            }
            return false;
        }
        try {
            if (this.securityDAO.isSysadmin(userId) || this.securityDAO.hasOrgRole(orgId, userId, roles)) {
                return true;
            }
            ArrayList<String> roleList = new ArrayList<String>(Arrays.asList(roles));
            roleList.retainAll(GROUP_SUPER_ROLES);
            if (!roleList.isEmpty()) {
                Organisation organisation = (Organisation)this.securityDAO.find(Organisation.class, orgId);
                if (OrganisationType.CLASS_TYPE.equals(organisation.getOrganisationType().getOrganisationTypeId())) {
                    organisation = organisation.getParentOrganisation();
                }
                if (this.securityDAO.hasOrgRole(organisation.getOrganisationId(), userId, roleList.toArray(EMPTY_STRING_ARRAY))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while checking user " + userId + " role in organisation " + orgId), (Throwable)e);
        }
        String error = "User " + userId + " does not have any of " + Arrays.toString(roles) + " roles in organisation " + orgId + " and can not \"" + action + "\"";
        log.error((Object)error);
        this.logEventService.logEvent(14, userId, userId, null, null, error);
        if (escalate) {
            throw new SecurityException(error);
        }
        return false;
    }

    public void setSecurityDAO(ISecurityDAO securityDAO) {
        this.securityDAO = securityDAO;
    }

    public void setLogEventService(ILogEventService logEventService) {
        this.logEventService = logEventService;
    }
}

